# -*- coding: utf-8 -*-

from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.sandboxsdk import environments

from sandbox.projects.common import utils
from sandbox.projects.logs.common import GetArcadia
import sandbox.projects.common.build.parameters as build_parameters


import os
import sys
import time
import shlex
import random
import string
import logging
from os.path import join as pj
from sandbox.common.types import task as ctt
from sandbox.common.errors import TaskFailure
from sandbox.projects.logs.UserSessionsReactorTest import UserSessionsReactorTest

DEFAULT_NIRVANA_QUOTA = 'user-sessions-ci'
DEFAULT_YT_POOL = 'sessions-search-daily'
DEFAULT_YT_PREFIX = '//user_sessions/recalc'
DEFAULT_REACTOR_PREFIX = '/user_sessions/preprod/recalc/sandbox_test'
DEFAULT_DAYS_TO_STORE_OUTPUT = 3


class UserSessionsRecalc(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('yandex-yt', version='0.10.8'),
            environments.PipEnvironment('requests'),
            environments.PipEnvironment('networkx', version='2.2', use_wheel=True),
        ]

    class Parameters(sdk2.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('Arcadia URL', required=True, default_value=Arcadia.ARCADIA_TRUNK_URL)
        arcadia_patch = sdk2.parameters.String(
            build_parameters.ArcadiaPatch.description,
            default=build_parameters.ArcadiaPatch.default,
            multiline=True
        )

        with sdk2.parameters.Group("YT params") as yt_group:
            yt_cluster = sdk2.parameters.String('YT cluster', default='hahn')
            yt_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with yt token", required=True, default="USERSESSIONSTOOLS")
            yt_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with yt token", required=True, default='ROBOT_MAKE_SESSIONS_YQL_TOKEN')
            yt_pool = sdk2.parameters.String('YT pool', default=DEFAULT_YT_POOL)
            yt_root_path = sdk2.parameters.String('YT working path', default=DEFAULT_YT_PREFIX)
            days_to_store = sdk2.parameters.Integer('Days to store output', default=DEFAULT_DAYS_TO_STORE_OUTPUT)

        with sdk2.parameters.Group("Reactor params") as reactor_group:
            reactor_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with reactor token", required=True, default="USERSESSIONSTOOLS")
            reactor_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with reactor token", required=True, default='ROBOT_MAKE_SESSIONS_REACTOR_TOKEN')
            reactor_root_path = sdk2.parameters.String("Reactor working path", required=True, default=DEFAULT_REACTOR_PREFIX)
            reactor_queue_parallelism = sdk2.parameters.Integer('Queue parallelism', default=3)
            reactor_retries_count = sdk2.parameters.Integer('Reactions retries count', default=5)
            reactor_retries_delay = sdk2.parameters.Integer('Reactions retries delay, minutes', default=20)

        with sdk2.parameters.Group("Nirvana params") as nirvana_group:
            nirvana_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with nirvana token", required=True, default="USERSESSIONSTOOLS")
            nirvana_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with nirvana token", required=True, default='ci_nirvana_token')
            nirvana_yt_token_secret_name = sdk2.parameters.String("Name of nirvana-secret with YT token", required=True, default='robot-make-sessions-yt-token')
            nirvana_quota_name = sdk2.parameters.String("Quota name on nirvana", required=True, default=DEFAULT_NIRVANA_QUOTA)
            nirvana_graph_owner = sdk2.parameters.String("Launched graphs owner", required=True, default='robot-make-sessions')

        with sdk2.parameters.Group("Build binaries") as build_group:
            bin_use_prod = sdk2.parameters.Bool("Use production binaries", required=True, default=False)

        daily_datetime = sdk2.parameters.String("Datetime in format YYYY-MM-DD, comma-separated", required=True,)
        daily_labels = sdk2.parameters.String("Labels, comma-separated")

        with sdk2.parameters.Group("Debug") as debug:
            fail_on_first = sdk2.parameters.Bool("Fail on first error", default=True)

        need_recalc_antifraud_rules = sdk2.parameters.Bool("Very big changes, need to recalc antifraud rules", default=True)
        recalc_labels = sdk2.parameters.Bool("Turn off if you want use archive and ssd mode from usual labels", default=True)



    def RunLoadAndRunRecalc(self):
        daily_labels = self.Parameters.daily_labels
        if self.Parameters.recalc_labels:
            daily_labels = daily_labels + ",!ssd,!archive,!step"

        task = UserSessionsReactorTest(
            self,
            description="Load and run recalc graph. Child of task {}".format(self.id),
            arcadia_url = self.Parameters.arcadia_url,
            arcadia_patch = self.Parameters.arcadia_patch,
            yt_cluster = self.Parameters.yt_cluster,
            yt_token_secret_owner = self.Parameters.yt_token_secret_owner,
            yt_token_secret_name = self.Parameters.yt_token_secret_name,
            yt_pool = self.Parameters.yt_pool,
            yt_root_path = self.Parameters.yt_root_path,
            days_to_store = self.Parameters.days_to_store,
            reactor_token_secret_owner = self.Parameters.reactor_token_secret_owner,
            reactor_token_secret_name = self.Parameters.reactor_token_secret_name,
            reactor_root_path = self.Parameters.reactor_root_path,
            reactor_queue_parallelism = self.Parameters.reactor_queue_parallelism,
            reactor_retries_count = self.Parameters.reactor_retries_count,
            reactor_retries_delay = self.Parameters.reactor_retries_delay,
            nirvana_token_secret_owner = self.Parameters.nirvana_token_secret_owner,
            nirvana_token_secret_name = self.Parameters.nirvana_token_secret_name,
            nirvana_yt_token_secret_name = self.Parameters.nirvana_yt_token_secret_name,
            nirvana_quota_name = self.Parameters.nirvana_quota_name,
            nirvana_graph_owner = self.Parameters.nirvana_graph_owner,
            bin_use_prod = self.Parameters.bin_use_prod,
            period_daily = True,
            period_fast = False,
            daily_datetime = self.Parameters.daily_datetime,
            daily_labels = daily_labels,
            fail_on_first = self.Parameters.fail_on_first,
            recalc_mode = True,
        )
        task_id = task.enqueue().id
        return task_id

    def RunAntifraudNotification(self):
        return
        '''
        if self.Parameters.change_rules:
            task = RtmrRollbackUsertaskYF(
                self,
                description="Rollback account {account} to version {previous_version} at {cluster}".format(
                    account=self.Parameters.account,
                    previous_version=previous_version,
                    cluster=self.Parameters.cluster),
                priority=self.Parameters.priority,
                rtmr_deploy_resource=self.Parameters.rtmr_deploy_resource,
                cluster=self.Parameters.cluster,
                account=self.Parameters.account,
                config_backup_resource=config_backup,
                rollback_version=previous_version,
                oauth_token_name=self.Parameters.oauth_token_name)
            task.save()
            self.Context.rollback_task = task.id
            self.Context.save()
            return
        '''

    def PrepareCopyTask(self):
        return

    def PrepareDeleteTask(self):
        return

    def check_subtasks(self):
        subtasks = self.find()
        if any(subtask.status != ctt.Status.SUCCESS for subtask in subtasks):
            for subtask in subtasks:
                if subtask.status != ctt.Status.SUCCESS:
                    raise TaskFailure("Subtask {} finished with status {}".format(subtask.id, subtask.status))
        else:
            logging.info("Success testing!")

    def on_execute(self):
        with self.memoize_stage.load_and_start_graph:
            self.Context.run_graph_task_id = self.RunLoadAndRunRecalc()
            raise sdk2.WaitTask([self.Context.run_graph_task_id], ctt.Status.Group.FINISH, wait_all=True)
        self.check_subtasks()
        '''
        self.RunAntifraudNotification()
        self.PrepareCopyTask()
        self.PrepareDeleteTask()
        '''
