import sys
import logging

from sandbox.projects.logs.common import RunProcess


def RegisterReactorFiles(file_name, token_path, env={}):
    cmd = [
        sys.executable,
        "-m", "us_processes.create_file_artifacts_and_reactions",
        "-t", token_path,
        "--file-name", file_name,
        "--verbose",
    ]

    logging.info("command {}".format(str(cmd)))
    result, _ = RunProcess(cmd, env, log_prefix="create_file_artifacts_and_reactions", exception_if_nonzero_code=True)

    return result
