from sandbox import sdk2
from sandbox.sdk2.vcs.svn import Arcadia
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process  # maybe sdk2.helpers.ProcessLog?

from sandbox.projects.common.arcadia import sdk as arcadia_sdk

import logging

from os.path import join as pj
import os
import sys
import random
import time
import string

# from threading import Thread


def RunProcess(cmd, env, log_prefix=None, exception_if_nonzero_code=True):
    cmd_str = ' '.join([str(cmd_elem) for cmd_elem in cmd])
    process = run_process(
        cmd_str,
        outs_to_pipe=False, check=False, shell=True, wait=True,
        environment=env,
        log_prefix=log_prefix,
    )
    process.communicate()

    result = ""
    error = ""
    exc_msg = ''

    error_file_path = process.stderr_path
    if error_file_path is not None:
        with open(error_file_path, 'r') as error_file:
            error = error_file.read().strip()
        exc_msg += 'error: {}\n'.format(error)

    result_file_path = process.stdout_path
    if result_file_path is not None:
        with open(result_file_path, 'r') as result_file:
            result = result_file.read().strip()
        exc_msg += 'result: {}\n'.format(result)

    if process.returncode != 0 and exception_if_nonzero_code:
        raise Exception(exc_msg)

    return process.returncode, result, error


class DeactivateAndDeleteOldUsReactionsAndArtifacts(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            environments.PipEnvironment('requests'),
            environments.PipEnvironment('networkx', version='2.2', use_wheel=True),
        ]

    class Parameters(sdk2.Parameters):
        with sdk2.parameters.Group("Reactor token") as reactor_token_block:
            reactor_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with reactor token", required=True)  # on practice: USERSESSIONSTOOLS. But do not specify default here for safety
            reactor_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with reactor token", required=True)  # on practice: robot-make-sessions-reactor-token (TODO: create secret). But do not specify default here for safety
            # TODO: maybe add defaults at least to description?

    class Context(sdk2.Context):
        pass

    def GetReactorTokenPath(self):
        secret_content = self.GetReactorToken()
        reactor_token_path = pj(str(self.path()), 'reactor_token_file')
        os.system('echo {} > {}'.format(secret_content, reactor_token_path))

        return reactor_token_path

    def GetEnv(self, arcadia_user_sessions_local_abs_path):
        env = dict(os.environ)
        paths = env['PYTHONPATH'].split(':') if 'PYTHONPATH' in env else []
        paths.extend([arcadia_user_sessions_local_abs_path])
        env['PYTHONPATH'] = ':'.join(set(paths))

        return env

    def CheckoutArcadiaSubfolder(self, arcadia_subfolder, arcadia_src_dir, svn_url, use_cache=True):
        pos = svn_url.rfind('@')

        if pos != -1:
            dir_url = pj(svn_url[:pos], arcadia_subfolder) + svn_url[pos:]
        else:
            dir_url = pj(svn_url, arcadia_subfolder)

        arcadia_subfolder_local_abs_path = pj(arcadia_src_dir, arcadia_subfolder)

        if use_cache:
            with arcadia_sdk.mount_arc_path(dir_url, use_arc_instead_of_aapi=True) as p:
                sdk2.paths.copy_path(str(p), arcadia_subfolder_local_abs_path)
        else:
            sdk2.svn.Arcadia.checkout(dir_url, arcadia_subfolder_local_abs_path)

        return arcadia_subfolder_local_abs_path

    def PrepareArcadia(self, svn_url):
        if svn_url in self.arcadia_key_to_reactor_dir:
            return

        arcadia_src_dir = pj(str(self.path()), 'local_arcadia_' + \
            ''.join(random.SystemRandom(time.time()).choice(
                string.ascii_lowercase + string.ascii_uppercase + string.digits
            ) for _ in range(20)))

        self.arcadia_key_to_reactor_dir[svn_url] = self.CheckoutArcadiaSubfolder('quality/user_sessions/reactor', arcadia_src_dir, svn_url=svn_url)

    def GetReactorToken(self):
        secret_owner = self.Parameters.reactor_token_secret_owner
        secret_name = self.Parameters.reactor_token_secret_name
        token = sdk2.Vault.data(secret_owner, secret_name)
        return token

    def RunAndLogProcess(self, cmd, env, cmd_alias, failed_cmd_to_returncode, errors):
        returncode, result, error = RunProcess(cmd, env, log_prefix=cmd_alias, exception_if_nonzero_code=False)
        if returncode != 0:
            failed_cmd_to_returncode[cmd_alias] = returncode

        logging.info("stdout of the last command: {}".format(result))
        logging.info("stderr of the last command: {}".format(error))
        if error.strip():
            errors.append(error.strip())

    def on_execute(self):
        logging.info('DeactivateAndDeleteOldUsReactionsAndArtifactsTask: Start')

        self.arcadia_key_to_reactor_dir = {}
        self.PrepareArcadia(Arcadia.ARCADIA_TRUNK_URL)

        clusters = ["freud", "hume", "arnold", "hahn"]
        errors = []
        failed_cmd_to_returncode = {}

        reactor_token_path = self.GetReactorTokenPath()
        env = self.GetEnv(self.arcadia_key_to_reactor_dir[Arcadia.ARCADIA_TRUNK_URL])

        root_namespace_paths = ','.join(["/user_sessions/{cluster}".format(cluster=cluster) for cluster in clusters])
        cmd = ["{} -m {}".format(sys.executable, "us_processes.deactivate_old_reactions"), "-t", reactor_token_path,
               "-rn {rn} -da 1 -mda 10 -mdnd 15 -mdaa 20".format(rn=root_namespace_paths)]
        self.RunAndLogProcess(cmd, env, "deactivate", failed_cmd_to_returncode, errors)

        if errors or failed_cmd_to_returncode:
            fail_msg = ""
            for error in errors:
                fail_msg += error + "\n"
            for failed_cmd_alias, returncode in failed_cmd_to_returncode.iteritems():
                fail_msg += "failed_cmd_alias: {}; returncode: {}".format(failed_cmd_alias, returncode) + "\n"
            raise Exception(fail_msg)
