# -*- coding: utf-8 -*-
import time
import logging
from sandbox import sdk2
import datetime
import sandbox.projects.common.utils as utils
from sandbox.common.types import task as ctt
from sandbox.common.errors import TaskFailure
import sandbox.common.types.misc as ctm
import sandbox.common.types.notification as ctn
import sandbox.sandboxsdk.environments as environments
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.logs.deploy.rule_monitoring.RunRuleMonitoring import RunRuleMonitoring
from sandbox.projects.logs.deploy.rule_monitoring.RunRuleMonitoring import UserSessionsRuleMonitoringResult
from sandbox.projects.logs.deploy.rule_monitoring.RuleMonitoringTaskReleaser import RuleMonitoringTaskReleaser
from sandbox.projects.release_machine_tasks.ReleaseSearchComponentZ2 import ReleaseSearchComponentZ2
from sandbox.projects.release_machine.components.configs.user_sessions import UserSessionsCfg
from sandbox.projects.common import link_builder as lb
from sandbox.projects.common.build.YaPackage import YaPackage
from sandbox.projects.logs.UserSessionsProcessesTest import UserSessionsProcessesTest
from sandbox.projects.logs.release_helpers.UserSessionsHelper import UserSessionsHelper
import sandbox.projects.release_machine.rm_notify as rm_notify
from sandbox.projects.release_machine.rm_notify import const
from sandbox.projects.logs.release_binaries import ReleaseUserSessionsBinaries


MIN_DIFF_THRESHOLD = 0.01


class RuleMonitoringDiffHelper:
    HEAD_TEMPLATE = '''<!DOCTYPE html><html lang="en">
    <head>
        <meta charset="UTF-8">
        <title>Rule Monitoring diff</title>
    </head>
    <body>
    {}
    </body>
    </html>'''
    TABLE_3_TEMPLATE = '''<table border="1" cellpadding="5" align="center" style="border-collapse: collapse; border: 1px solid black;"><thead>
    <tr><td></td><td>Commit in production</td><td colspan="3">Previous commit</td><td colspan="3">Your commit</td></tr>
    <tr><td>Metrica Name</td><td>Base Value</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td></tr>
    </thead><tbody>'''
    TABLE_4_TEMPLATE = '<table border="1" cellpadding="5" align="center" style="border-collapse: collapse; border: 1px solid black;"><tr><td></td><td></td><td colspan="3">Old CS NEW RuleMonitoring</td><td colspan="3">New CS Old RuleMonitoring</td><td colspan="3">NEW CS NEW RuleMonitoring</td></tr><tr><td>Metrica Name</td><td>Base Value</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td><td>status</td><td>new value</td><td>diff</td></tr>'
    TR_3_TEMPLATE = "<tr><td>{}</td><td>{}</td>{}{}</tr>"
    TR_4_TEMPLATE = "<tr><td>{}</td><td>{}</td>{}{}{}</tr>"
    TD_TEMPLATE = "<td>{}</td><td>{}</td><td>{}</td>"

    HAS_DIFF_TEMPLATE = '<font id="HAS_DIFF" style="color: #000000; background-color: #FFFF00">HAS_DIFF</font>'
    MINOR_DIFF_TEMPLATE = '<font id="MINOR_DIFF" style="color: #888888; background-color: #FFFFFF">MINOR_DIFF</font>'
    ADD_VALUE_TEMPLATE = '<font id="ADD" style="color: #ffffff; background-color: #66CC66">ADDED</font>'
    REMOVE_VALUE_TEMPLATE = '<font id="REMOVE" style="color: #ffffff; background-color: #FF3333">REMOVED</font>'
    TECH_VALUE_TEMPLATE = '<font id="TECH" style="color: #0033FF; background-color: #FFFFFF">TECH</font>'

    OODICT = dict()
    ONDICT = dict()
    NODICT = dict()
    NNDICT = dict()

    is_two_rm = True
    has_diff = False

    def __init__(self, base_res, on_res, no_res=None, nn_res=None, ignored_metrics=[], important_metrics=[]):
        self.ignored_metrics = ignored_metrics
        self.important_metrics = important_metrics
        self.important_metrics_table = ""

        self.prepare_dict(self.OODICT, base_res)
        self.prepare_dict(self.ONDICT, on_res)
        self.prepare_dict(self.NODICT, no_res)
        if no_res and nn_res:
            self.is_two_rm = False
            self.prepare_dict(self.NNDICT, nn_res)

    def get_html(self, result_dir, keep_OK_metrics=False):
        result_html = open(result_dir, "w")
        if self.is_two_rm:
            result_html.write(self.prepare_3_res_html(self.OODICT, self.ONDICT, self.NODICT, keep_OK_metrics))
        else:
            result_html.write(self.prepare_4_res_html(self.OODICT, self.ONDICT, self.NODICT, self.NNDICT, keep_OK_metrics))
        result_html.close()

    def get_important_metrics_html(self, result_dir):
        with open(result_dir, "w") as result_html:
            if not self.is_two_rm:
                result_html.write(self.prepare_4_imp_res_html(self.OODICT, self.ONDICT, self.NODICT, self.NNDICT, True))

    def _prepare_4_res_html_impl(self, OODICT, ONDICT, NODICT, NNDICT, key_pred, keep_OK_metrics):
        tr_add = []
        tr_remove = []
        tr_has_diff = []
        tr_no_diff = []
        table = RuleMonitoringDiffHelper.TABLE_4_TEMPLATE
        all_keys = set(OODICT.keys())
        all_keys.update(set(ONDICT.keys()))
        all_keys.update(set(NODICT.keys()))
        all_keys.update(set(NNDICT.keys()))
        for key in sorted(all_keys):
            if not key_pred(key):
                continue
            base_value = OODICT[key] if key in OODICT else "-"
            on_td = self.prepare_td(key, base_value, ONDICT[key] if key in ONDICT else "-")
            no_td = self.prepare_td(key, base_value, NODICT[key] if key in NODICT else "-")
            nn_td = self.prepare_td(key, base_value, NNDICT[key] if key in NNDICT else "-")
            tr = self.TR_4_TEMPLATE.format(key, base_value, on_td, no_td, nn_td)
            if 'id="HAS_DIFF"' in tr:
                tr_has_diff.append(tr)
            elif 'id="ADD"' in tr:
                tr_add.append(tr)
            elif 'id="REMOVE"' in tr:
                tr_remove.append(tr)
            else:
                tr_no_diff.append(tr)
        if len(tr_has_diff) + len(tr_remove) + len(tr_add) > 0:
            self.has_diff = True
        if keep_OK_metrics:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + ''.join(tr_no_diff) + '</table>'
        else:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + '</table>'
        return table

    def prepare_4_res_html(self, OODICT, ONDICT, NODICT, NNDICT, keep_OK_metrics):
        truePred = lambda x: True
        table = self._prepare_4_res_html_impl(OODICT, ONDICT, NODICT, NNDICT, truePred, keep_OK_metrics)
        return self.HEAD_TEMPLATE.format(table)

    def prepare_4_imp_res_html(self, OODICT, ONDICT, NODICT, NNDICT, keep_OK_metrics):
        filterImportantPred = lambda x: x in self.important_metrics
        self.important_metrics_table = self._prepare_4_res_html_impl(OODICT, ONDICT, NODICT, NNDICT, filterImportantPred, keep_OK_metrics)
        return self.important_metrics_table

    def prepare_3_res_html(self, OODICT, previousCommit, ONDICT, keep_OK_metrics):
        tr_add = []
        tr_remove = []
        tr_has_diff = []
        tr_no_diff = []
        table = self.TABLE_3_TEMPLATE
        all_keys = set(OODICT.keys())
        all_keys.update(set(ONDICT.keys()))
        all_keys.update(set(previousCommit.keys()))
        for key in sorted(all_keys):
            base_value = OODICT[key] if key in OODICT else "-"
            previous_commit_td = self.prepare_td(key, base_value, previousCommit[key] if key in previousCommit else "-")
            on_td = self.prepare_td(key, base_value, ONDICT[key] if key in ONDICT else "-")
            tr = self.TR_3_TEMPLATE.format(key, base_value, previous_commit_td, on_td)
            if 'id="HAS_DIFF"' in tr:
                tr_has_diff.append(tr)
            elif 'id="ADD"' in tr:
                tr_add.append(tr)
            elif 'id="REMOVE"' in tr:
                tr_remove.append(tr)
            else:
                tr_no_diff.append(tr)
        if len(tr_has_diff) + len(tr_remove) + len(tr_add) > 0:
            self.has_diff = True
        if keep_OK_metrics:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + ''.join(tr_no_diff) + '</table>'
        else:
            table = table + ''.join(tr_add) + ''.join(tr_remove) + ''.join(tr_has_diff) + '</table>'
        return self.HEAD_TEMPLATE.format(table)

    def prepare_td(self, key, base_value, new_value):
        status = None
        diff = None
        if base_value == new_value:
            status = 'OK'
            diff = '&nbsp;'
        else:
            if base_value == '-':
                status = self.ADD_VALUE_TEMPLATE
                diff = '{}'.format(new_value)
            else:
                if new_value == '-':
                    status = self.REMOVE_VALUE_TEMPLATE
                    new_value = '&nbsp;'
                    diff = '&nbsp;'
                else:
                    status = self.HAS_DIFF_TEMPLATE
                    diff_value = new_value-base_value
                    if base_value == 0:
                        base_value = 1
                    diff_percente = diff_value/base_value*100
                    diff = '{} ({} %)'.format(diff_value, round(diff_percente, 2))
                    if abs(diff_percente) > MIN_DIFF_THRESHOLD:
                        status = self.HAS_DIFF_TEMPLATE
                    else:
                        status = self.MINOR_DIFF_TEMPLATE
        if key in self.ignored_metrics:
            status = self.TECH_VALUE_TEMPLATE
        return self.TD_TEMPLATE.format(status, new_value, diff)

    def prepare_dict(self, dict, file):
        with open(file, 'r') as result_file:
            for line in result_file:
                a = line.split()
                dict[a[0]] = float(a[1])

class UserSessionsRuleMonitoringInfo(sdk2.Resource):
    """
      Rule monitoring info for trunk run
    """
    releasers = ["ARC_AUTOCOMMIT_USERS", "USERSESSIONSTOOLS"]
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()
    table = sdk2.parameters.String()

class UserSessionsRuleMonitoringInfoForRelease(sdk2.Resource):
    """
       Rule monitoring run for release machine
    """
    releasers = ["ARC_AUTOCOMMIT_USERS", "USERSESSIONSTOOLS"]
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()


DEFAULT_ARCADIA_URL = 'arcadia:/arc/trunk/arcadia@4228478'
YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'userdata-sessions-build-ci-token'
TECH_VALUE = ['task=common.metric=time_calc', 'task=common.metric=time_from_build', 'task=common.metric=revision']
IMPORTANT_METRICS = ['task=common.metric=users_total_count', 'task=common.metric=users_fat_count']

@rm_notify.notify2()
class DeployRuleMonitoring(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        cores = 1
        ram = 4096

        environments = [
            environments.PipEnvironment('yandex-yt', version='0.10.8'),
            environments.PipEnvironment('yandex-yt-yson-bindings-skynet', version='0.3.32-0')
        ]

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
	is_get_old_branch_auto = sdk2.parameters.Bool(
            "Get previous Rule Monitoring path automatically",
            default=True,
        )
        is_release_machine_mode = sdk2.parameters.Bool(
            "Collect user sessions logs from raw, and check 4 situations",
            default=False,
        )
        commit_author = sdk2.parameters.String("Author of new commit", default=None)
        is_set_custom_table = sdk2.parameters.Bool(
            "Set table path manually",
            default=False,
        )
        with is_set_custom_table.value[True]:
            custom_table = sdk2.parameters.String("custom table path", default=None)
        with is_get_old_branch_auto.value[False]:
            old_revision = sdk2.parameters.ArcadiaUrl('path for old release branch', required=False)
        new_revision = sdk2.parameters.ArcadiaUrl('path for new release branch', required=True)
        release_number = sdk2.parameters.String('RM release number', required=False)
        just_testing_no_release = sdk2.parameters.Bool(
            "just testing no release",
            default=False,
        )

        show_OK_metrics = sdk2.parameters.Bool(
            "shown OK metrics in rule monitoring diff",
            default=False,
        )

        is_set_custom_rule_monitoring_tasks_ids = sdk2.parameters.Bool(
            "Set rule_monitoring child tasks ids manually",
            default=False,
        )
        with is_set_custom_rule_monitoring_tasks_ids.value[True]:
            custom_old_CS_old_RM_id = sdk2.parameters.String("Custom old_CS_old_RM_id", default=None)
            custom_old_CS_new_RM_id = sdk2.parameters.String("Custom old_CS_new_RM_id", default=None)
            custom_new_CS_new_RM_id = sdk2.parameters.String("Custom new_CS_new_RM_id", default=None)
            custom_new_CS_old_RM_id = sdk2.parameters.String("Custom new_CS_old_RM_id", default=None)

    def get_prepared_logs_table(self):
        import yt.wrapper
        yt.wrapper.config.set_proxy("hahn")
        yt.wrapper.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        table = "//home/userdata-sessions-build-ci/rule_monitoring/fresh_table"
        cl = yt.wrapper.read_table(table, format='json', raw=False)
        for item in cl:
            return item["value"]

    def get_sesions_path(self):
        if not self.Parameters.is_release_machine_mode:
            return self.get_prepared_logs_table()
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
	yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
	da = datetime.datetime.now()
        da = da.replace(hour=3, minute=0, second=0)
        ts = int(time.mktime(da.timetuple()))
        table_str = "//user_sessions/pub/search/fast/{}/clean"
        table = table_str.format(ts)
        if not yt.exists(table):
            da = da - datetime.timedelta(days=1)
            while not yt.exists(table):
                da = da + datetime.timedelta(minutes=30)
                table = table_str.format(int(time.mktime(da.timetuple())))
        self.Context.date_time = da.strftime("%Y-%m-%d:%H:%M")
        self.Context.timestamp = int(time.mktime(da.timetuple()))
        return table

    def run_rule_monitoring(self, arcadia_url, input_table=None):
        if not input_table:
            input_table = self.Context.input_table_path
        task = RunRuleMonitoring(
                self,
                description="Child of task {}".format(self.id),
                component_name=self.Parameters.component_name,
                cluster = 'hahn',
                input_table_path = input_table,
                rule_monitoring_path = arcadia_url
            )
        task.enqueue()
        return task

    def prepare_yt_path(self, revision):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        yt.create('map_node', '//home/userdata-sessions-build-ci/rule_monitoring/{}/1'.format(revision), True, True)
        yt.create('map_node', '//home/userdata-sessions-build-ci/rule_monitoring/{}/2'.format(revision), True, True)
        yt.link('//home/logfeller/logs', '//home/userdata-sessions-build-ci/rule_monitoring/{}/1/logs'.format(revision), ignore_existing=True)
        yt.link('//home/logfeller/logs', '//home/userdata-sessions-build-ci/rule_monitoring/{}/2/logs'.format(revision), ignore_existing=True)

    def check_prepared_sessions(self, revision):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        old_sessions = yt.exists('//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search'.format(revision))
        new_sessions = yt.exists('//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search'.format(revision))
        return old_sessions & new_sessions

    def run_create_sessions(self, branch, input_table):
        params = {
            'exception_on_build_fail': False,
            'arcadia_url_with_revision': branch,
            'custom_whole_prefix_path': input_table,
            'custom_yt_pool': 'sessions-minor',
            'days_to_store_output': 7,
            'extra_labels_for_fast': 'search',
            'fast_datetime': self.Context.date_time,
            'fast_sessions_to_check': 'search',
            'fetch_path': 'home/userdata-sessions-build-ci/user-sessions-processes-ci/2016-12-12',
            'launch_daily': False,
            'launch_fast': True,
            'set_output_removal_attrs': True,
            'yt-token': 'CI-token',
        }
        create_sessions_task = sdk2.Task[UserSessionsProcessesTest.type](self, **params)
        task_id = create_sessions_task.enqueue().id
        return task_id

    def build_bin(self, branch):
        task = ReleaseUserSessionsBinaries(
                self,
                description="Child of task {}".format(self.id),
                component_name=self.Parameters.component_name,
                cluster='hahn',
                reg_customize_binaries = False,
                nonreg_customize_binaries = False,
                reg_general_arcadia_url = self.Parameters.new_revision,
                reg_nirvana_ttl_days = 365,
                reg_binaries_build_method = 'general_arcadia_url',
                nonreg_binaries_build_method = 'do_not_build',
                reactor_token_secret_owner = 'USERSESSIONSTOOLS',
                reactor_token_secret_name = 'prod_reactor_token',
                nirvana_token_secret_owner = 'USERSESSIONSTOOLS',
                nirvana_token_secret_name = 'prod_nirvana_token',
                nirvana_quota_name = 'user-sessions',
                build_only_one_binary = 'ralib_rules',
            )
        task.RM_NOTIFY_STATUSES_DO_NOT_SEND = [const.RMStatus.on_success, const.RMStatus.on_break]
        self.Context.build_bin_task_id = task.id

        task.enqueue()
        return task

    def run_release_task(self):
        task = RuleMonitoringTaskReleaser(
                self,
                description="Child of task {}".format(self.id),
                rule_moniroting_task_id = self.id,
            )
        task.enqueue()

    def release_binary(self):
        if self.Parameters.just_testing_no_release:
            return
        build_task_id = self.Context.build_bin_task_id
        last_released_branch_revision = self.get_revision(self.get_branch_from_last_released_resource())
        if last_released_branch_revision < self.get_revision(self.Parameters.new_revision):
            self.server.release(
                task_id = build_task_id,
                type="stable",
                subject="Release"
            )

            self.Context.released = True
            self.run_release_task()
        else:
            raise Exception("You try to release revision older than deployed on reactor")

    def get_revision(self, url):
        if url.count("@") != 1:
            return None
        return url.split("@")[-1]

    def find_rule_monitoring_resource(self, name, parent_task_id=None, branch=None, table=None):
        attrs = {}
        if branch:
            attrs['branch'] = branch
        if table:
            attrs['table'] = table

        resource = UserSessionsRuleMonitoringResult.find(attrs=attrs).first()
        resource_path = str(sdk2.ResourceData(resource).path)
        print(resource_path)
        assert resource, "Can't find {} USER_SESSIONS_RULE_MONITORING_RESULT resource from {}".format(name, lb.task_link(parent_task_id, plain=True))

        return resource_path

    def create_simple_diff(self):
        baseline = self.find_rule_monitoring_resource('baseline',
                                                      branch=self.Context.old_rule_monitoring_branch,
                                                      table=self.Context.input_table_path)
        prev_revision = self.find_rule_monitoring_resource('prev_revision',
                                                           branch=self.Context.previous_commit_revision,
                                                           table=self.Context.input_table_path)
        new_revision = self.find_rule_monitoring_resource('new_revision',
                                                          branch=self.Parameters.new_revision,
                                                          table=self.Context.input_table_path)
        rm_differ = RuleMonitoringDiffHelper(baseline, prev_revision, new_revision, ignored_metrics=TECH_VALUE)
        rm_differ.get_html(str(self.path('diff.html')), self.Parameters.show_OK_metrics)
        self.diff_to_resource(str(self.path('diff.html')), None)
        self.Context.has_diff = rm_differ.has_diff

    def create_diff_for_rm(self):
        old_CS_old_RM_res = self.find_rule_monitoring_resource('old_CS_old_RM', parent_task_id=self.Context.old_CS_old_RM_id)
        old_CS_new_RM_res = self.find_rule_monitoring_resource('old_CS_new_RM', parent_task_id=self.Context.old_CS_new_RM_id)
        new_CS_old_RM_res = self.find_rule_monitoring_resource('new_CS_old_RM', parent_task_id=self.Context.new_CS_old_RM_id)
        new_CS_new_RM_res = self.find_rule_monitoring_resource('new_CS_new_RM', parent_task_id=self.Context.new_CS_new_RM_id)
        rm_differ = RuleMonitoringDiffHelper(old_CS_old_RM_res, old_CS_new_RM_res, new_CS_old_RM_res, new_CS_new_RM_res, ignored_metrics=TECH_VALUE, important_metrics=IMPORTANT_METRICS)
        rm_differ.get_html(str(self.path('diff.html')), self.Parameters.show_OK_metrics)
        rm_differ.get_important_metrics_html(str(self.path("diff_important_metrics.html")))
        self.diff_to_resource(str(self.path('diff.html')), str(self.path("diff_important_metrics.html")))
        self.Context.has_diff = rm_differ.has_diff
        self.important_metrics_diff_content = rm_differ.important_metrics_table

    def diff_to_resource(self, path_to_all_diff, path_to_important_metrics_diff):
        if self.Parameters.is_release_machine_mode:
            resource = UserSessionsRuleMonitoringInfoForRelease(
                self,
                "Rule monitoring output",
                str(path_to_all_diff),
                branch=self.Parameters.new_revision,
            )
            sdk2.ResourceData(resource)
            self.Context.diff_res_id = resource.id
            if path_to_important_metrics_diff is not None:
                imp_metr_res = UserSessionsRuleMonitoringInfoForRelease(
                    self,
                    "Rule monitoring output",
                    str(path_to_important_metrics_diff),
                    branch=self.Parameters.new_revision,
                )
                sdk2.ResourceData(imp_metr_res)
                self.Context.imp_metr_diff_res_id = imp_metr_res.id
            else:
                self.Context.imp_metr_diff_res_id = None
        else:
            resource = UserSessionsRuleMonitoringInfo(
                self,
                "Rule monitoring output",
                str(path_to_all_diff),
                branch=self.Parameters.new_revision,
                table=self.Context.input_table_path
            )
            sdk2.ResourceData(resource)
            self.Context.diff_res_id = resource.id
            self.Context.imp_metr_diff_res_id = None

    def get_previous_revision(self):
        resources = UserSessionsRuleMonitoringResult.find().limit(100)
        max_revision = 0
        res_branch = None
        new_rev = self.get_revision(self.Parameters.new_revision)
        for res in resources:
            splited_branch = res.branch.split("@")
            if not len(splited_branch) == 2:
                continue
            rev = splited_branch[1]
            if not "branches" in res.branch and rev > max_revision and rev < new_rev:
                res_branch = res.branch
                max_revision = rev
        self.Context.previous_commit_revision = res_branch
        logging.info("$$$$$$ {}".format(res_branch))

    def get_branch_from_last_released_resource(self):
        last_released_res = sdk2.Resource.find(
                type= UserSessionsRuleMonitoringInfo,
            ).order(-sdk2.Resource.id).limit(50)
        for res in last_released_res:
            if sdk2.Resource[res.id].task.status in ctt.Status.RELEASED:
                logging.info('$$$$$$$$$$$$$$$${}'.format(res.id))
                return sdk2.Resource[res.id].branch
        raise Exception("No release in last 50 resources")

    def get_last_released_branch(self):
        if not self.Parameters.is_get_old_branch_auto and self.Parameters.old_revision:
            self.Context.old_rule_monitoring_branch = self.Parameters.old_revision
            return
        else:
            self.Context.old_rule_monitoring_branch = self.get_branch_from_last_released_resource()
            return
        raise Exception("No release in last 50 resources")

    def resolve_sessions_timestamp(self, revision):
        import yt.wrapper as yt
        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        self.Context.sessions_timestamp_old = max(yt.list('//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search/fast'.format(revision)))
        self.Context.sessions_timestamp_new = max(yt.list('//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search/fast'.format(revision)))

    def send_notification_to_rm(self, message):
        UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            branch_url=self.Parameters.new_revision,
            message=message,
            send_to_tg=True,
            send_to_st=True,
            release_num=self.Parameters.release_number,
            is_summon_people_to_st=True,
            add_duty_login=True,
            component_name=self.Parameters.component_name,
        ).enqueue()

    def set_expiration_time(self, table_path, delay=1440):
        import yt.wrapper as yt
        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        utc_now = datetime.datetime.utcnow()
        delayed_time = utc_now + datetime.timedelta(minutes=int(delay))
        delayed_time_iso = delayed_time.isoformat() + 'Z'
        logging.info('delayed_time_iso delayed_time_iso delayed_time_iso {}'.format(delayed_time_iso))
        yt.set(str(table_path) + '/@expiration_time', delayed_time_iso)

    def custom_change_child_task_id_if_needed(self, context_attr):
        if getattr(self.Parameters, "custom_" + context_attr) not in [ctm.NotExists, None, ""]:
            setattr(self.Context, context_attr, getattr(self.Parameters, "custom_" + context_attr))


    def create_run_rule_monitoring_task_if_needed(self, run_rule_context_attr, rule_monitoring_branch, cs_table):
        if not hasattr(self.Context, run_rule_context_attr) or (getattr(self.Context, run_rule_context_attr) in [None, "", ctm.NotExists]):
            new_task = self.run_rule_monitoring(rule_monitoring_branch, cs_table)
            setattr(self.Context, run_rule_context_attr, new_task.id)
            return [new_task]
        else:
            return []

    def check_subtasks(self):
        subtasks = self.find()
        for subtask in subtasks:
            if subtask.status != ctt.Status.SUCCESS:
                raise TaskFailure("Subtask {} finished with status {}".format(subtask.id, subtask.status))

        logging.info("Subtasks statuses successfully checked")


    def on_execute(self):
        self.Context.input_table_path = self.get_sesions_path()
        self.get_last_released_branch()
        if self.Parameters.is_release_machine_mode:
            if not self.Parameters.release_number:
                raise ValueError("You need to set release_number")
            new_revision = self.get_revision(self.Parameters.new_revision)
            with self.memoize_stage.prepare_user_sessions:
                if not self.check_prepared_sessions(new_revision):
                    self.prepare_yt_path(new_revision)
                    self.Context.create_sessions_old = self.run_create_sessions(
                        self.Context.old_rule_monitoring_branch,
			'//home/userdata-sessions-build-ci/rule_monitoring/{}/1'.format(new_revision))
                    self.Context.create_sessions_new = self.run_create_sessions(
                        self.Parameters.new_revision,
			'//home/userdata-sessions-build-ci/rule_monitoring/{}/2'.format(new_revision))
                    prepare_logs_tasks = [self.Context.create_sessions_old, self.Context.create_sessions_new]
                    raise sdk2.WaitTask(prepare_logs_tasks, ctt.Status.Group.FINISH|ctt.Status.Group.BREAK, wait_all=True)

            self.check_subtasks()

            self.custom_change_child_task_id_if_needed("old_CS_old_RM_id")
            self.custom_change_child_task_id_if_needed("old_CS_new_RM_id")
            self.custom_change_child_task_id_if_needed("new_CS_new_RM_id")
            self.custom_change_child_task_id_if_needed("new_CS_old_RM_id")
            with self.memoize_stage.run_rule_monitoring:
                self.resolve_sessions_timestamp(new_revision)
                old_cs_table = '//home/userdata-sessions-build-ci/rule_monitoring/{}/1/user_sessions/pub/search/fast/{}/clean'.format(new_revision, self.Context.sessions_timestamp_old)
                new_cs_table = '//home/userdata-sessions-build-ci/rule_monitoring/{}/2/user_sessions/pub/search/fast/{}/clean'.format(new_revision, self.Context.sessions_timestamp_new)
                self.set_expiration_time('//home/userdata-sessions-build-ci/rule_monitoring/{}'.format(new_revision))
                #build_bin_task = self.build_bin(str(self.Parameters.new_revision))

                tasks_to_wait = []
                tasks_to_wait += self.create_run_rule_monitoring_task_if_needed("old_CS_old_RM_id", self.Context.old_rule_monitoring_branch, old_cs_table)
                tasks_to_wait += self.create_run_rule_monitoring_task_if_needed("old_CS_new_RM_id", self.Parameters.new_revision, old_cs_table)
                tasks_to_wait += self.create_run_rule_monitoring_task_if_needed("new_CS_old_RM_id", self.Context.old_rule_monitoring_branch, new_cs_table)
                tasks_to_wait += self.create_run_rule_monitoring_task_if_needed("new_CS_new_RM_id", self.Parameters.new_revision, new_cs_table)

                if tasks_to_wait:
                    raise sdk2.WaitTask(
                        tasks_to_wait,
                        ctt.Status.Group.FINISH|ctt.Status.Group.BREAK,
                        wait_all=True)
            self.create_diff_for_rm()
        else:
            with self.memoize_stage.run_rule_monitoring:
                self.get_previous_revision()
                build_bin_task = self.build_bin(str(self.Parameters.new_revision))
                baseline_rule_monitoring = self.run_rule_monitoring(self.Context.old_rule_monitoring_branch)
                previous_commit = self.run_rule_monitoring(self.Context.previous_commit_revision)
                checked_rule_monitoring = self.run_rule_monitoring(self.Parameters.new_revision)
                baseline_rule_monitoring.id

                simple_child_task = [build_bin_task, baseline_rule_monitoring, previous_commit, checked_rule_monitoring]


                raise sdk2.WaitTask(simple_child_task, ctt.Status.Group.FINISH|ctt.Status.Group.BREAK, wait_all=True)

        self.check_subtasks()

        if self.Parameters.is_release_machine_mode:
            self.create_diff_for_rm()
            if self.Context.has_diff:
                rm_message_template = (u"Rule Monitoring\n"
                                       u"DIFF - https://sandbox.yandex-team.ru/resource/{}/view \n"
                                       u"Прямая ссылка на html c DIFF https://proxy.sandbox.yandex-team.ru/{} \n")
                self.send_notification_to_rm(rm_message_template.format(self.Context.diff_res_id, self.Context.diff_res_id))
                rm_important_metric_template = (u"Important metrics!!!\n"
                                                u"<#{}#>\n"
                                                u"Прямая ссылка на html c DIFF https://proxy.sandbox.yandex-team.ru/{} \n")
                self.send_notification_to_rm(rm_important_metric_template.format(self.important_metrics_diff_content, self.Context.imp_metr_diff_res_id))

        else:
            self.create_simple_diff()
            if not self.Context.has_diff:
                self.release_binary()
            else:
                message_template = (
                    u"После твоего коммита https://a.yandex-team.ru/arc/commit/{} был запущен Rule Monitoring.\n"
                    u"Таска в сендбокс https://sandbox.yandex-team.ru/task/{}/view\n"
                    u"Необходимо посмотреть DIFF между твоим коммитом, и версией RULE MONITORING в production https://sandbox.yandex-team.ru/resource/{}/view \n"
                    u"Прямая ссылка на html c diff https://proxy.sandbox.yandex-team.ru/{}\n"
                    u"Если дифф ожидаемый - ничего делать не надо, мы уже зарелизили код на veles02.\n"
                    u"Если дифф НЕ ожидаем, то необходимо разобраться, что изменилось и либо откатить, либо исправить баг\n"
                    u"Узнать, что такое Rule Monitoring можно здесь https://wiki.yandex-team.ru/logs/monitorings/ralib/ \n"
                    u"Если остались какие-то вопросы - напиши на logs-team@yandex-team.ru")
                commit_author = self.Parameters.commit_author if self.Parameters.commit_author else self.author
                self.server.notification(
                    subject='You need to check rule monitoring diff',
                    body=message_template.format(self.get_revision(self.Parameters.new_revision), self.id, self.Context.diff_res_id, self.Context.diff_res_id, self.id),
                    recipients=[commit_author, 'logs-ci'],
                    transport=ctn.Transport.EMAIL,
                    urgent=True,
                )
                self.release_binary()
        if self.Context.diff_res_id:
            self.set_info('Result diff file - ((https://sandbox.yandex-team.ru/resource/{}/view))'.format(self.Context.diff_res_id))
        else:
            self.set_info('Empty diff')

    def on_release(self, release_params):
        if not self.Context.released and not self.Parameters.is_release_machine_mode:
            self.release_binary()

