# -*- coding: utf-8 -*-
import os
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.release_machine.input_params2 as rm_params
import datetime
import time

YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'SCARAB_YQL_TOKEN'

CREATE_TEST_TABLE_PATH = 'quality/user_sessions/tools/sample_by_uid'


class PrepareRuleMonitoringTable(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass
    class Parameters(sdk2.Task.Parameters):
        arcadia_url = sdk2.parameters.ArcadiaUrl('arcadia url', required=True)

    def get_sesions_path(self):
        import yt.wrapper as yt

        yt.config.set_proxy("hahn")
        yt.config["token"] = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        da = datetime.datetime.now()
        da = da.replace(hour=3, minute=0, second=0)
        ts = int(time.mktime(da.timetuple()))
        table_str = "//user_sessions/pub/search/fast/{}/clean"
        table = table_str.format(ts)
        if not yt.exists(table):
            da = da - datetime.timedelta(days=1)
            while not yt.exists(table):
                da = da + datetime.timedelta(minutes=30)
                table = table_str.format(int(time.mktime(da.timetuple())))
        self.Context.timestamp = int(time.mktime(da.timetuple()))
        return table

    def clone_and_build(self, arcadia_url, api, result_dir):
        arcadia_dir = sdk.do_clone(arcadia_url, self)
        sdk.do_build(
             build_system=consts.YMAKE_BUILD_SYSTEM,
             source_root=arcadia_dir,
             targets=[api],
             build_type=consts.RELEASE_BUILD_TYPE,
             results_dir=str(result_dir),
             clear_build=False,
             use_dev_version=False,
             sanitize=False,
             checkout=True,
         )

    def write_new_table_info(self):
        import yt.wrapper
        yt.wrapper.config.set_proxy("hahn")
        table = "//home/userdata-sessions-build-ci/rule_monitoring/fresh_table"
        records = list(yt.wrapper.read_table(table, format=yt.wrapper.JsonFormat()))
        for rec in records:
            yt.wrapper.remove(rec["value"])
        yt.wrapper.write_table(table, [
            {"key": "", "value": "//home/userdata-sessions-build-ci/rule_monitoring/{}".format(self.Context.timestamp)},
        ], format=yt.wrapper.JsonFormat())


    def on_execute(self):
        token = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        os.environ["YT_TOKEN"] = token
        os.environ['MR_RUNTIME'] = 'YT'
        result_path = self.path('builded')
        work_dir = str(result_path) + '/' + CREATE_TEST_TABLE_PATH
        input_table = self.get_sesions_path()
        self.clone_and_build(self.Parameters.arcadia_url, CREATE_TEST_TABLE_PATH, result_path)
        rule_monitoring_bin_path = str(work_dir) + '/sample_by_uid'
        run_process(
            [rule_monitoring_bin_path,
            '-frac', '0.1',
            '-server', 'hahn',
            '-src', input_table,
            '-dst', '//home/userdata-sessions-build-ci/rule_monitoring/{}'.format(self.Context.timestamp)],
            work_dir=work_dir,
            shell=True,
            timeout=10000,
            log_prefix='run_rule_monitoring_preparing',
            outputs_to_one_file=True
        )
        self.write_new_table_info()

