# -*- coding: utf-8 -*-
import os
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import logging

class RuleMonitoringTaskReleaser(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        rule_moniroting_task_id = sdk2.parameters.String('task for release', required=True)

    def on_execute(self):
        logging.info('Creating Rule monitoring release')
        release_subj = "Fresh release of task: https://sandbox.yandex-team.ru/task/{}/view".format(self.Context.rule_moniroting_task_id)

        release_params = {
            'task_id': self.Parameters.rule_moniroting_task_id,
            'type': 'stable',
            'subject': release_subj,
            'to': [],
            'cc': [],
            'params': {},
            'message': '',
        }

        self.server.release(release_params)
        logging.info('Rule monitoring release created')
