# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.common.types.resource as ctr
from sandbox.common.types import task as ctt
from sandbox.projects.yql.RunYQL2 import RunYQL2

import datetime
import os
import json
import logging

CREATE_TABLE_BACKUPS_PATH = 'quality/user_sessions/money_rt/create_table_backups'
YT_TOKEN_OWNER = 'robot-make-money'
YT_TOKEN_NAME = 'sec-01fj1xfn3pd7c62yfddmr6bgsk#secret'


class CreateTableBackupsBinary(sdk2.Resource):
    '''
       Create Table Backups binary
    '''
    releasable = False
    any_arch = True
    executable = True
    auto_backup = True
    branch = sdk2.parameters.String()
    parent_task_id = sdk2.parameters.String()


class RunCreateTableBackups(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096
        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
        with sdk2.parameters.RadioGroup('stand name') as stand:
            stand.values.prestable = stand.Value('prestable', default=True)
            stand.values.stable = stand.Value('stable')

        with sdk2.parameters.RadioGroup('tables to backup') as backup_mode:
            backup_mode.values.queues = backup_mode.Value('queues')
            backup_mode.values.states = backup_mode.Value('states', default=True)
            backup_mode.values.custom = backup_mode.Value('custom')
            backup_mode.values.full = backup_mode.Value('full')

        with backup_mode.value['states']:
            tables_str = sdk2.parameters.String('specify particular tables incompatible with full mode', required=False, default='')

        with backup_mode.value['queues']:
            queues_str = sdk2.parameters.String('specify particular queues incompatible with full mode', required=False, default='')

        with backup_mode.value['custom']:
            tables_str = sdk2.parameters.String('specify particular tables incompatible with full mode', required=False, default='')
            queues_str = sdk2.parameters.String('specify particular queues incompatible with full mode', required=False, default='')

        backup_master = sdk2.parameters.Bool(
            'use backup master',
            required=False,
            default=False
        )
        dry_mode = sdk2.parameters.Bool('dry mode(not commit) ',  required=False, default=True)
        create_table_backups_arc_path = sdk2.parameters.ArcadiaUrl('Arcadia url for create_table_backups', required=True)
        arcadia_patch = sdk2.parameters.String('Patch for tasks', required=False, default=None)
        # dont_use_cached_result = sdk2.parameters.Bool('Do not use cached result resource', required=False, default=False)
        yt_token = sdk2.parameters.YavSecret('YavSecret with yt-token', default=YT_TOKEN_NAME)

    def clone_and_build(self, arcadia_url, api, result_dir, patch=None):
        with sdk.mount_arc_path(arcadia_url,
                                use_arc_instead_of_aapi=True) as arcadia_dir:
            sdk.do_build(
                 build_system=consts.YMAKE_BUILD_SYSTEM,
                 source_root=arcadia_dir,
                 targets=[api],
                 build_type=consts.RELEASE_BUILD_TYPE,
                 results_dir=str(result_dir),
                 clear_build=False,
                 use_dev_version=False,
                 sanitize=False,
                 checkout=False,
                 patch=patch
             )

    def prepare_bin_as_resource(self, path):
        sdk2.ResourceData(CreateTableBackupsBinary(
            self,
            'create table backups for rtyt',
            str(path),
            branch=self.Parameters.create_table_backups_arc_path,
            parent_task_id=self.id,
        ))

    def search_bin(self):
        try:
            resource = CreateTableBackupsBinary.find(attrs=dict(branch=self.Parameters.create_table_backups_arc_path)).first()
            if resource:
                self.Context.use_bin_from_res = True
                return str(sdk2.ResourceData(resource).path)
        except:
            return None
        return None

    def on_execute(self):
        prep_res = None
        if not prep_res:
            self.token = self.Parameters.yt_token.data()[self.Parameters.yt_token.default_key]
            os.environ['YT_TOKEN'] = self.token
            result_path = self.path('builded')
            work_dir = str(self.path())
            create_table_backups_path = self.search_bin()
            work_dir = str(result_path) + '/' + CREATE_TABLE_BACKUPS_PATH
            self.clone_and_build(self.Parameters.create_table_backups_arc_path, CREATE_TABLE_BACKUPS_PATH, result_path, self.Parameters.arcadia_patch)
            create_table_backups_path = str(work_dir)+'/create_table_backups'
            if not self.Context.backupped:
                logging.info('Running backup')
                is_full = self.Parameters.backup_mode == 'full' or self.Parameters.backup_mode == 'custom'
                backup_states = self.Parameters.backup_mode == 'states' or is_full
                backup_queues = self.Parameters.backup_mode == 'queues' or is_full

                if backup_states:
                    if not is_full and len(self.Parameters.tables_str) == 0:
                        logging.warn('You have not provided tables for backup switching to all mode instead')

                    cmd_args = [create_table_backups_path,
                        'table',
                        '-S', self.Parameters.stand]
                    if is_full or len(self.Parameters.queues_str) == 0:
                        cmd_args.append('-N')
                        cmd_args.append('all')
                        cmd_args.append('--force-vital-stand-all-commit')
                    else:
                        cmd_args.append('-N')
                        cmd_args.append(self.Parameters.tables_str)

                    if not self.Parameters.dry_mode:
                        cmd_args.append('--commit')

                    if self.Parameters.backup_mode:
                        cmd_args.append('--backup-master')

                    run_process(
                        cmd_args,
                        work_dir=work_dir,
                        shell=True,
                        timeout=10000,
                        log_prefix='create_table_backups_path',
                        outputs_to_one_file=True
                    )

                if backup_queues:
                    if not is_full and len(self.Parameters.queues_str) == 0:
                        logging.warn('You have not provided queues for backup switching to all mode instead')

                    cmd_args = [create_table_backups_path,
                        'queue',
                        '-S', self.Parameters.stand]
                    if is_full or len(self.Parameters.queues_str) == 0:
                        cmd_args.append('-N')
                        cmd_args.append('all')
                    else:
                        cmd_args.append('-N')
                        cmd_args.append(self.Parameters.queues_str)

                    if not self.Parameters.dry_mode:
                        cmd_args.append('--commit')

                    run_process(
                        cmd_args,
                        work_dir=work_dir,
                        shell=True,
                        timeout=10000,
                        log_prefix='create_table_backups_path',
                        outputs_to_one_file=True
                    )
                self.Context.backupped = True
