# -*- coding: utf-8 -*-
import os
from sandbox import sdk2
import datetime
import time
import datetime
import json
import time
import logging
import requests
import calendar
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import sandbox.common.types.resource as ctr
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.logs.release_helpers.UserSessionsHelper import UserSessionsHelper

YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'USER_SESSIONS_YT_TOKEN'

# common-failure-event-log - lifetime is not infinite and this session is not very important
NOT_LOGS_PATH = ["late",
                 "sample_by_uid_1p",
                 "trip-test-redir-log",
                 "renderer-profile-event-log",
                 "yandex_staff",
                 "common-failure-event-log",
                 "hamster-search",
                 "hamster-images",
                 "hamster-video",
                 "hamster-splitted-proto-reqans-rt",
                 "hamster-splitted-proto-reqans-fat"]

BORDER_TIMESTAMP = int(time.time()) - 259200

class UserSessionsLostTablesInfo(sdk2.Resource):
    """
        File with RM US announcement info
    """
    cluster = sdk2.parameters.String()
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True

class CheckLostDays(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass
    class Parameters(rm_params.ComponentName2):
        sessions_path = sdk2.parameters.String(
            'sessions_path',
            description='Путь к директории с сессиями. Пример: //user_sessions/pub/',
            multiline=False,
            required=True
        )
        ingored_logs = sdk2.parameters.String(
            'ingored_logs',
            description='Имена директорий с логами, которые нужно проигнорировать, разделенные запятой.',
            multiline=False,
            required=False
        )
        cluster = sdk2.parameters.String(
            'cluster',
            description='Имя кластера',
            multiline=False,
            required=True
        )
        token_name = sdk2.parameters.String(
            'token_name',
            description='Имя токена для работы с кластером на YT',
            multiline=False,
            required=True
        )
        token_owner = sdk2.parameters.String(
            'token_owner',
            description='Имя владельца токена для работы с кластером на YT',
            multiline=False,
            required=True
        )
        is_initial_run = sdk2.parameters.Bool(
            "First run for initialize graphs and resources",
            default_value=False,
        )
        with sdk2.parameters.Group("Solomon token") as solomon_token_block:
            solomon_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with solomon token", required=True, default="USERSESSIONSTOOLS")
            solomon_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with solomon token", required=True, default="robot_make_sessions_solomon_token")
        debug_options = sdk2.parameters.Bool(
            "Debug options",
            default_value=False,
        )


    def is_need_to_collect(self, day):
        if self.dt2ts(datetime.datetime.strptime(day, "%Y-%m-%d")) > BORDER_TIMESTAMP:
            return False
        return True

    def get_previous_tables_result(self):
        resource = UserSessionsLostTablesInfo.find(attrs=dict(cluster = self.Parameters.cluster), state=ctr.State.READY).first()
        if resource:
            return sdk2.ResourceData(resource).path
        return None

    def prepare_tables_result(self, big_json):
        result_path = self.path('result.txt')
        f = open(str(result_path), 'w')
        json.dump(big_json, f, sort_keys=True,)
        f.close()
        sdk2.ResourceData(UserSessionsLostTablesInfo(
            self,
            "Output file",
            str(result_path),
            cluster = self.Parameters.cluster,
        ))


    def GetSolomonToken(self):
        secret_owner = self.Parameters.solomon_token_secret_owner
        secret_name = self.Parameters.solomon_token_secret_name
        token = sdk2.Vault.data(secret_owner, secret_name)
        return token

    def initiation_of_graph_and_json(self, last_json):
        sensor_count = 0
        sansors_arr = []

        for log in last_json:
            one_log_json = last_json[log]
            day_count = len(one_log_json)
            for log_day in sorted(one_log_json):
                is_last_day = False
                day_count -=1
                if day_count == 0:
                    is_last_day = True
                try:
                    ts = self.dt2ts(datetime.datetime.strptime(log_day, "%Y-%m-%d"))
                    self.fill_senson(sansors_arr, str(log), str("clean"), ts, one_log_json[log_day], is_last_day)
                    sensor_count+=2
                    if sensor_count > 1000:
                        self.send_to_solomon(sansors_arr)
                        sansors_arr = []
                        sensor_count = 0
                except Exception as e:
                    logging.info(e)
                    logging.info("Broken date {} {}".format(str(log), str(log_day)))


    def dt2ts(self, dt):
        return calendar.timegm(dt.utctimetuple())

    def send_to_solomon(self, sensors):
        token = self.GetSolomonToken()
        SOLOMON_URL = 'http://solomon.yandex.net/api/v2/push?project=user_sessions&cluster={}&service=lost_days'.format(self.Parameters.cluster)
        solomon_json = {
            "commonLabels": {
                "time-period": "1d"
            },
            "sensors": []
        }
        solomon_json["sensors"] = sensors

        logging.info("Sending data to solomon")
        headers = {
            "Content-type": "application/json",
            "Accept": "application/json",
            "Authorization": "OAuth {}".format(token)
        }
        response = requests.post(SOLOMON_URL, data=json.dumps(solomon_json), headers=headers)
        logging.info(response.content)
        response.raise_for_status()
        logging.info("Data to solomon: " + json.dumps(solomon_json))
        logging.info("Sent all to solomon")

    def fill_senson(self, sensor_list, log_name, type_of_table, ts, is_exist, is_last_day):
        start_value = 1 if is_exist == False else 0
        end_value = 0 if is_last_day == True else 1
        start_day = ts - 10800
        end_day = ts + 75600
        sensor_list.append({"labels": {"log_name": log_name, "type_of_table": type_of_table},"ts": start_day,"value": start_value})
        sensor_list.append({"labels": {"log_name": log_name, "type_of_table": type_of_table},"ts": end_day,"value": end_value})

    def check_expiration_time(self, path):
        import yt.wrapper as yt
        yt.config["token"] = sdk2.Vault.data(self.Parameters.token_owner, self.Parameters.token_name)
        yt.config.set_proxy(self.Parameters.cluster)
        return 'expiration_time' in yt.get(path, attributes=['expiration_time'], format="json")

    def check_day(self, input_, check_table):
        return 1 if check_table in input_ else 0

    def send_lost_day_alarm(self, message):
        UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            message=message,
            send_to_tg=True,
            add_duty_login=True,
            component_name=self.Parameters.component_name,
        ).enqueue()

    def check_logs(self):
        import yt.wrapper as yt
        import yt.wrapper as yt
        yt.config["token"] = sdk2.Vault.data(self.Parameters.token_owner, self.Parameters.token_name)
        yt.config.set_proxy(self.Parameters.cluster)
        path = self.Parameters.sessions_path
        logs_paths = yt.list(path)
        good_days = 0
        logs_json = {}

        for log_path in logs_paths:
            logging.debug("Checking log {log_name}".format(log_name=log_path))
            if log_path in NOT_LOGS_PATH:
                continue
            daily_path = path + "/" + log_path + "/daily"
            if not yt.exists(daily_path):
                continue
            logging.debug("Adding log {log_name} to further comparison".format(log_name=log_path))
            log_json = yt.get(daily_path, format="json")
            logs_json[log_path] = log_json

        sensors_arr = []
        has_expiration_time = False

        big_json = {}
        for log in logs_json:
            has_expiration_time = has_expiration_time | self.check_expiration_time(path + '/' + log)
            big_json[log] = {}
            one_log_json = json.loads(logs_json[log])
            good_days+=len(one_log_json)
            for log_day in one_log_json:
                try:
                    is_exist_clean = self.check_day(one_log_json[log_day], "clean")
                    if self.Parameters.debug_options and log_day == '2019-01-01':
                        continue
                    if not self.is_need_to_collect(log_day):
                        continue
                    if log == "nano_sessions" and one_log_json[log_day]:
                        nano_sessions = one_log_json[log_day]
                        for nano_sessions_log in nano_sessions:
                            if nano_sessions_log == 'errors':
                                continue
                            nano_sessions_log_full_name = log + "_" + nano_sessions_log
                            if nano_sessions_log_full_name not in big_json:
                               big_json[nano_sessions_log_full_name] = {}
                            is_exist_clean = self.check_day(nano_sessions[nano_sessions_log], "clean")
                            big_json[nano_sessions_log_full_name][log_day] = is_exist_clean
                    else:
                        big_json[log][log_day] = is_exist_clean
                except Exception as e:
                    logging.info(e)
                    logging.info("Broken date {} {}".format(str(log), str(log_day)))

        if has_expiration_time:
            UserSessionsHelper(
                self,
                description="Child of test task {}".format(self.id),
                message='ПОЯВИЛСЯ УЗЕЛ С expiration_time!!! https://sandbox.yandex-team.ru/task/{}/view'.format(self.id),
                send_to_tg=True,
                add_duty_login=True,
                component_name=self.Parameters.component_name,
            ).enqueue()
        logging.info("Pub has expiration time attr " + str(has_expiration_time))

        if self.Parameters.is_initial_run:
            self.initiation_of_graph_and_json(big_json)

        if not self.Parameters.is_initial_run:
            previous_tables_result_path = self.get_previous_tables_result()
            logging.info("previous res " + str(previous_tables_result_path))

        self.prepare_tables_result(big_json)
        if not self.Parameters.is_initial_run:
            with open(str(previous_tables_result_path)) as input_json:
                data = json.load(input_json)
                lost_day = []
                solomon_sensor = []
                for log in data:
                    if log not in big_json:
                        lost_day.append('ALL LOG!! - ' + log)
                        continue
                    one_log_json = data[log]
                    for log_day in one_log_json:
                        if not log_day in big_json[log]:
                            lost_day.append(log + '/' +log_day)
                            logging.info("error "   + log + log_day)
                            self.prepare_lost_day(solomon_sensor, log, log_day)
                        else:
                            if big_json[log][log_day] < one_log_json[log_day]:
                                lost_day.append(log + '/' +log_day)
                                logging.info("error " + log + log_day)
                                self.prepare_lost_day(solomon_sensor, log, log_day)
                if len(lost_day) > 0:
                    self.send_to_solomon(solomon_sensor)
                    message = 'ALARM!!! ALARM!!! ALARM!!!\n Cluster:' + self.Parameters.cluster  + '\nNew lost clean tables: ' + ', '.join([str(x) for x in lost_day])
                    message += '\nhttps://sandbox.yandex-team.ru/task/{}/view'.format(self.id)
                    self.send_lost_day_alarm(message)

    def prepare_lost_day(self, solomon_sensor, log_name, log_day):
        ts = self.dt2ts(datetime.datetime.strptime(log_day, "%Y-%m-%d"))
        self.fill_senson(solomon_sensor, str(log_name), str("clean"), ts, False, False)

    def on_execute(self):
        if self.Parameters.ingored_logs:
            NOT_LOGS_PATH.extend(self.Parameters.ingored_logs.split(','))
        if self.Parameters.debug_options:
            NOT_LOGS_PATH.append("translate")
        self.check_logs()


