# -*- coding: utf-8 -*-
import logging
import datetime
import sandbox.common.types.task as ctt
from sandbox import sdk2
from sandbox.sandboxsdk import environments
import sandbox.projects.release_machine.core.task_env as task_env
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.release_machine.tasks.GetLastGoodRevision import GetLastGoodRevision

YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'SCARAB_YQL_TOKEN'
WAIT_TIMEOUT = 10 * 3600

class RalibPerformanceRunner(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [task_env.TaskRequirements.startrek_client, environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        wait_sessions_check_interval = sdk2.parameters.Integer(
            "Check sessions interval in seconds",
            default_value=3600,
        )
        date_for_test = sdk2.parameters.String(
            "Date for ralib test, FORMAT YYYY-MM-DD",
        )

    def _create_sdk1_subtask(self, task_type, description, parameters):
        task = self.server.task({
            'type': task_type,
            'context': parameters,
            'children': True,
         })

        update = {
             'description': description,
             'owner': self.owner,
             'priority': {
                 'class': self.Parameters.priority.cls,
                 'subclass': self.Parameters.priority.cls,
             },
         }

        task_id = task['id']
        self.server.task[task_id].update(update)
        self.server.batch.tasks.start.update([task_id])

        return task_id

    def get_last_good_revision(self):
        last_rev_subtask = GetLastGoodRevision(
            self,
            description="Child of test task {}".format(self.id),
            component_name="user_sessions",
            jobs_list="USER_SESSIONS_ENVIRONMENT_TEST"
        )
        last_rev_subtask.enqueue()
        self.Context.get_rev_task_id = last_rev_subtask.id
        targets = {last_rev_subtask.id: 'good_revision'}
        raise sdk2.WaitOutput(targets, wait_all=True, timeout=1200)

    def wait_sessions(self):
        from yt.wrapper import YtClient
        token = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        client = YtClient('hahn', token)
        yt_sessions_path = self.Context.yt_sessions_path
        message = ''
        attempts = 24
        while((not client.exists(yt_sessions_path)) and (attempts != 0)):
            attempts -= 1
            logging.info('counter is {}'.format(str(attempts)))
            raise sdk2.WaitTime(self.Parameters.wait_sessions_check_interval)
        if attempts == 0:
            raise Exception("Sessions {} is late. Check them manually https://yt.yandex-team.ru/hahn/operation?filter={}".format(yt_sessions_path, yt_sessions_path))
        else:
            return

    def RunPerformanceTask(self, parameters):
        subtask = self._create_sdk1_subtask(
            task_type='TEST_RALIB_PERFOMANCE',
            description='TEST_RALIB_PERFOMANCE',
            parameters=parameters,
        )

        logging.debug('TEST_RALIB_PERFOMANCE task id: {}'.format(subtask))

        self.Context.TEST_RALIB_PERFOMANCE_id = subtask

        raise sdk2.WaitTask(
            subtask,
            ctt.Status.Group.FINISH | ctt.Status.Group.BREAK,
            timeout=max(self.Parameters.kill_timeout, WAIT_TIMEOUT),
            wait_all=True,
        )

    def on_execute(self):
        with self.memoize_stage.getting_revision:
            if not self.Parameters.date_for_test:
                now = datetime.datetime.now()
                self.Context.current_date = now.strftime("%Y-%m-%d")
            else:
                self.Context.current_date = self.Parameters.date_for_test
            self.Context.yt_sessions_path = "//user_sessions/pub/sample_by_uid_1p/search/daily/{}/clean".format(self.Context.current_date)
            self.get_last_good_revision()

        checked_revision_task = sdk2.Task.find(id=self.Context.get_rev_task_id, children=True).limit(1).first()
        logging.info('GOOD REVISION' + str(checked_revision_task.Context.good_revision))
        self.Context.checked_revision = checked_revision_task.Context.good_revision

        self.wait_sessions()

        with self.memoize_stage.running_performance_test:
            parameters = {
                'fetched_sessions_path':self.Context.yt_sessions_path,
                'fetched_sessions_percent':1,
                'fetcher_binary_resource_id':'350051534',
                'is_release_machine_mode':True,
                'max_processes_count':2,
                'memory_limit_gb':8,
                'ralib_versions_count':1,
                'revisions': str(self.Context.checked_revision),
                'revisions_mode':True,
                'revisions_mode_fetched_date':self.Context.current_date,
                'send_to_statface':True
            }
            self.RunPerformanceTask(parameters)
