from sandbox import sdk2
from sandbox.common.types import task as ctt
import sandbox.common.types.misc as ctm
from sandbox.sandboxsdk.process import run_process  # maybe sdk2.helpers.ProcessLog?
from sandbox.sandboxsdk.environments import PipEnvironment
from sandbox.projects.common.arcadia import sdk as arcadia_sdk
from sandbox.projects import resource_types as rst  # OK to use resources from there and use SDK2 on the in spite the fact that they are inherited from AbstractResource (it is inherited from sdk2.TResource)
import sandbox.projects.release_machine.rm_notify as rm_notify
import sandbox.projects.release_machine.input_params2 as rm_params


import sandbox.projects.common.constants as consts
import json
import logging
from sandbox import common

from os.path import join as pj
import os
import shutil
import sys

from sandbox.common.types import task
import sandbox.projects.logs.resources as resources
from sandbox.projects.logs.common import ReactorPathJoin
from sandbox.projects.logs.common.binaries import (
    CUSTOM_ARCADIA_URL,
    GENERAL_ARCADIA_URL,
    DO_NOT_BUILD,
    DEFAULT_GENERAL_METHOD,
    REACTOR_BINARIES,
    ParamBinarySpecsRegular,
    ParamBinarySpecsNonRegular,
)


DEFAULT_NIRVANA_QUOTA_NAME = "user-sessions"
REGULAR_RELEASEABLE_NIRVANA_DEFAULT_TTL_DAYS = 30
NONREGULAR_RELEASEABLE_NIRVANA_DEFAULT_TTL_DAYS = 1000000000


def GetRevision(url):
    if url.count("@") != 1:
        return "HEAD"
    return url.split("@")[-1]


def get_how_to_build_bin_parameter_str(bin_name):
    return "how_to_build_binary_{}".format(bin_name)


def get_arcadia_url_bin_parameter_str(bin_name):
    return "arcadia_url_for_{}".format(bin_name)


def RunProcess(cmd, env, log_prefix=None, exception_if_nonzero_code=True):
    cmd_str = ' '.join([str(cmd_elem) for cmd_elem in cmd])
    process = run_process(
        cmd_str,
        outs_to_pipe=True, check=False, shell=True, wait=True,
        environment=env,
        log_prefix=log_prefix,
    )

    result, error = process.communicate()

    if error:
        logging.info(error)

    if exception_if_nonzero_code and process.returncode != 0:
        raise Exception(error)

    return result, error


class UsOneBinReleaseInfo(sdk2.resource.AbstractResource):
    """
        File with serialized json with artifacts info for releasing
    """
    releasers = resources.user_sessions_releasers
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


@rm_notify.notify2()
class ReleaseUserSessionsBinaries(sdk2.Task):
    class Requirements(sdk2.Requirements):
        environments = [
            PipEnvironment('requests'),
            PipEnvironment('networkx', version='2.2', use_wheel=True),
        ]

    class Parameters(rm_params.ComponentName2):
        with sdk2.parameters.Group("For regular release") as reg_group:
            reg_nirvana_ttl_days = sdk2.parameters.Integer("Reg. Nirvan storage: how many days (integer) binaries should live, some adhoc recomendation - {}".format(REGULAR_RELEASEABLE_NIRVANA_DEFAULT_TTL_DAYS), required=True)
            with sdk2.parameters.String(
                "Reg. How to build binaries. Default method. Will be used for binaries which don\'t have specified custom building method", required=True
            ) as reg_binaries_build_method:
                reg_binaries_build_method.values[DO_NOT_BUILD] = "do_not_build"  # TODO if sandbox will required default setting, it will be DO_NOT_BUILD
                reg_binaries_build_method.values[GENERAL_ARCADIA_URL] = "general_arcadia_url"  # later maybe new methods will be added, that's why I do not call this method just "build"
                                                                                                                      # for example, method "build only if not released at all (ever)"

            with reg_binaries_build_method.value[GENERAL_ARCADIA_URL]:
                reg_general_arcadia_url = sdk2.parameters.ArcadiaUrl('Reg. svvnn url for binaries (should be with revision). For example: arcadia:/arc/branches/userdata/<date>/arcadia@<rev>', required=True)

            reg_customize_binaries = sdk2.parameters.Bool("Reg. Customize some binaries. If you want to use special special methods for some binaries", default=False)

            with reg_customize_binaries.value[True]:
                ext_reg_specs = ParamBinarySpecsRegular()

        with sdk2.parameters.Group("NOT for regular release") as nonreg_group:
            nonreg_nirvana_ttl_days = sdk2.parameters.Integer("Nonreg. Nirvan storage: how many days (integer) binaries should live, some adhoc recomendation - {}".format(NONREGULAR_RELEASEABLE_NIRVANA_DEFAULT_TTL_DAYS), required=True)
            with sdk2.parameters.String(
                "Nonreg. How to build binaries. Default method. Will be used for binaries which don\'t have specified custom building method", required=True
            ) as nonreg_binaries_build_method:  # TODO: maybe default do_not_build?
                nonreg_binaries_build_method.values[DO_NOT_BUILD] = "do_not_build"  # TODO if sandbox will required default setting, it will be DO_NOT_BUILD
                nonreg_binaries_build_method.values[GENERAL_ARCADIA_URL] = "general_arcadia_url"  # later maybe new methods will be added, that's why I do not call this method just "build"
                                                                                                                      # for example, method "build only if not released at all (ever)"

            with nonreg_binaries_build_method.value[GENERAL_ARCADIA_URL]:
                nonreg_general_arcadia_url = sdk2.parameters.String('Nonreg. svn url for binaries (should be with revision)', required=True)

            nonreg_customize_binaries = sdk2.parameters.Bool("Nonreg. Customize some binaries. If you want to use special special methods for some binaries", default=False)

            with nonreg_customize_binaries.value[True]:
                ext_nonreg_specs = ParamBinarySpecsNonRegular()

        with sdk2.parameters.Group("Reactor params") as reactor_group:
            reactor_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with reactor token", required=True, default="USERSESSIONSTOOLS")
            reactor_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with reactor token", required=True)
            reactor_root_path = sdk2.parameters.String("Debug reactor path prefix", default="")

        with sdk2.parameters.Group("Nirvana params") as nirvana_group:
            nirvana_token_secret_owner = sdk2.parameters.String("Owner of sb-vault-secret with nirvana token", required=True, default="USERSESSIONSTOOLS")
            nirvana_token_secret_name = sdk2.parameters.String("Name of sb-vault-secret with nirvana token", required=True)
            nirvana_quota_name = sdk2.parameters.String("Quota name on nirvana", required=True, default=DEFAULT_NIRVANA_QUOTA_NAME)

        build_only_one_binary = sdk2.parameters.String("Build only one binary", default="")

        # TODO: later, for cash-logic
        # prohibit_using_cache = sdk2.parameters.Bool("Prohibit using cached binaries; use only build", default=False)
        # do_not_cache_bins = sdk2.parameters.Bool("Build, but do not cache them", default=False)

    class Context(sdk2.Context):
        pass
        # YQL_executor_task_id = None
        # ReportLogsTester_id = None

    def Validate(self):
        pass
        # TODO validate owner rights and fail if needed
        # TODO and maybe fullness of dict in reactor-scripts, but in this case we'll need checkouting (PrepareArcadia)
        # TODO: check revisions in arcadia-url here or later
        # TODO: check for regress using reactor-api here or later (art-instances should have revision. If not - fail!)
        # how to fail:
        # raise common.errors.TaskFailure("...")

    def GetNirvanaTokenPath(self):
        secret_owner = self.Parameters.nirvana_token_secret_owner
        secret_name = self.Parameters.nirvana_token_secret_name
        secret_content = sdk2.Vault.data(secret_owner, secret_name)
        nirvana_token_path = pj(str(self.path()), 'nirvana_token_file')
        os.system('echo {} > {}'.format(secret_content, nirvana_token_path))

        return nirvana_token_path

    def GetReactorTokenPath(self):
        secret_owner = self.Parameters.reactor_token_secret_owner
        secret_name = self.Parameters.reactor_token_secret_name
        secret_content = sdk2.Vault.data(secret_owner, secret_name)
        reactor_token_path = pj(str(self.path()), 'reactor_token_file')
        os.system('echo {} > {}'.format(secret_content, reactor_token_path))

        return reactor_token_path

    def GetNirvanaResourceDescription(self, res_id, bin_name, build_from_svn_url):
        data_json = {"svn_url": build_from_svn_url, "sandbox_res_id": res_id}
        return json.dumps(data_json)

    def GetEnv(self):
        env = dict(os.environ)
        env['PYTHONPATH'] = ':'.join(sys.path)

        return env

    def DoSyncBinary(self, res_id, bin_name, build_from_svn_url):
        resource = sdk2.Resource.find(id=res_id).limit(1).first()
        resource_data = sdk2.ResourceData(resource)
        resource_path = resource_data.path
        p = sdk2.path.Path(resource_path)
        new_resource_path = pj(os.path.dirname(str(p)), bin_name)
        shutil.move(str(p), new_resource_path)

        nirv_token_path = self.GetNirvanaTokenPath()
        ttl_days = self.Parameters.reg_nirvana_ttl_days if REACTOR_BINARIES[bin_name].regular_release else self.Parameters.nonreg_nirvana_ttl_days
        description = self.GetNirvanaResourceDescription(res_id, bin_name, build_from_svn_url)

        cmd = ["{} {}".format(sys.executable, pj(self.reactor_dir, "us_nirvana", "tools", "sync_file_to_nirvana.py")), "-t", nirv_token_path, "--ttl-days", ttl_days, "--description", "'{}'".format(description.replace("'", "\"")),
               "-p", new_resource_path, "-q", self.Parameters.nirvana_quota_name]
        result, error = RunProcess(cmd, self.GetEnv(), log_prefix="sync_to_nirvana_{}".format(bin_name))
        return result

    def SyncBinariesToNirvanaAndCashIt(self):
        # # build subtasks have been created and have already finished
        # import sessions_processes_config as scripts_config # noqa

        # TODO: for cash-logic
        # # sync binaries which have already been built long ago
        # for bin_name, res_id in self.ctx[BIN_NAME_TO_READY_RESOURCE_ID].iteritems():
            # self.DoSyncBinary(res_id, bin_name, local_bin_folder)

        failed_builds_count = 0
        # # sync binaries which our subtasks have just built
        self.bin_name_to_res_id = {}
        self.bin_name_to_nirvana_data_id = {}
        self.bin_name_to_nirvana_storage_id = {}
        for bin_name, build_task_id_and_svn_url in self.Context.bin_name_to_task_id_and_svn_url.iteritems():
            build_task_id, build_from_svn_url = build_task_id_and_svn_url

            subtask = sdk2.Task[build_task_id]  # it's dangerous to search for child_bin_tasks through "find my child tasks" because there might be some not actual child tasks
            # in case some (but not all) child tasks have been created but then task failed with exception and then you pressed "Run" and new child tasks have been created but those old ones exist and
            # you might accidentally get them through "find my child tasks" although they are not of interest for you anymore
            # another idea: to cash in Context subtasks and bot their ids - but I am not sure it's possible to cash in Context such non-trivial data as subtasks

            # if subtask.is_failure(): # plan B if the following doesn't work
            if subtask.status in (task.Status.FAILURE, task.Status.EXCEPTION):
                failed_builds_count += 1
                continue

            res_id = subtask.Context.ap_packs["project"]
            self.bin_name_to_res_id[bin_name] = res_id
            result = self.DoSyncBinary(res_id, bin_name, build_from_svn_url)
            logging.info("RESULT of nirvana with bin_name {}: {}".format(bin_name, result))
            result_json = json.loads(result.strip())
            self.bin_name_to_nirvana_data_id[bin_name] = result_json["data_id"]
            self.bin_name_to_nirvana_storage_id[bin_name] = result_json["storage_id"]
            # TODO: for cash-logic
            # if self.ShouldApplyBinariesCashingLogic(build_from_svn_url):
                # attr_value_to_set = build_from_svn_url
                # channel.sandbox.set_resource_attribute(res_id,
                                                       # BUILD_SVN_PATH_ATTR_NAME,
                                                       # attr_value_to_set)
        if failed_builds_count > 0:
            raise common.errors.TaskFailure("{} build subtasks FAILED".format(failed_builds_count))

    def PrepareBinaries(self):
        self.SyncBinariesToNirvanaAndCashIt()

    def CashBinariesInSandbox(self):
        pass
        # TODO: release-testing; maybe set attrs

    def GetSvnUrl(self):
        # in this task all we take is from trunk (except built binaries in child_task). Because we need the freshest info and tools - we do not release scripts (graph)
        return "arcadia:/arc/trunk/arcadia"

    def CheckoutArcadiaSubfolder(self, arcadia_subfolder, use_cache=True):
        svn_url = self.GetSvnUrl()

        dir_url = pj(svn_url, arcadia_subfolder)

        arcadia_subfolder_local_abs_path = pj(self.arcadia_src_dir, arcadia_subfolder)

        if use_cache:
            with arcadia_sdk.mount_arc_path(dir_url, use_arc_instead_of_aapi=True) as p:
                sdk2.paths.copy_path(str(p), arcadia_subfolder_local_abs_path)
        else:
            sdk2.svn.Arcadia.checkout(dir_url, arcadia_subfolder_local_abs_path)

        return arcadia_subfolder_local_abs_path

    def PrepareArcadia(self):
        self.arcadia_src_dir = pj(str(self.path()), 'local_arcadia')  # TODO check abs_path() - maybe no have it

        self.reactor_dir = self.CheckoutArcadiaSubfolder('quality/user_sessions/reactor')
        sys.path.insert(0, self.reactor_dir)

    def GetArtifactNamespaceToStringMetaValue(self, bin_name):
        from us_processes import file_artifact_spec

        artifact_to_release = file_artifact_spec.getFileArtifactSpec(bin_name).artifactToRelease
        return {artifact_to_release: self.bin_name_to_nirvana_data_id[bin_name]}

    def PrepareReactorReleaseConfig(self):
        import us_reactor.tools.do_release_string_artifacts_lib as config_lib

        data_json = []
        for bin_name, build_task_id_and_svn_url in self.Context.bin_name_to_task_id_and_svn_url.iteritems():
            _, build_from_svn_url = build_task_id_and_svn_url

            artifact_namespace_to_string_meta_value = self.GetArtifactNamespaceToStringMetaValue(bin_name)

            for artifact_namespace, string_meta_value in artifact_namespace_to_string_meta_value.iteritems():
                bin_subdata_json = {
                    config_lib.FROM_SVN: True,
                    config_lib.ATTRS: {
                        "revision": GetRevision(build_from_svn_url),
                        "svn_url": build_from_svn_url,
                        "sandbox_res_id": self.bin_name_to_res_id[bin_name],
                        "nirvana_data_id": self.bin_name_to_nirvana_data_id[bin_name],
                    },
                    config_lib.NAMESPACE: ReactorPathJoin(self.Parameters.reactor_root_path, artifact_namespace),
                    config_lib.STRING_VALUE: string_meta_value,
                }

                data_json.append(bin_subdata_json)

        self.Context.config_content = config_lib.serialize(data_json)
        resource = None
        if self.Parameters.build_only_one_binary:
            resource = UsOneBinReleaseInfo(self, "Release-config with string artifacts with storage-ids of nirvana-resources with binaries", "us_binaries_artifacts_config_resource_directory", ttl=30)
        else:
            resource = resources.UsBinariesReleaseInfo(self, "Release-config with string artifacts with storage-ids of nirvana-resources with binaries", "us_binaries_artifacts_config_resource_directory", ttl=30)

        resource_data = sdk2.ResourceData(resource)
        resource_data.path.mkdir(0o755, parents=True, exist_ok=True)
        resource_data.path.joinpath("us_bins_config.txt").write_bytes(self.Context.config_content)

    def on_execute(self):
        logging.info('ReleaseUserSessionsBinariesTask: Start')
        self.Validate()
        if self.Parameters.build_only_one_binary:
            self.CreateOneBuildSubtaskIfNeeded(self.Parameters.build_only_one_binary)
        else:
            self.CreateBuildSubtasksIfNeeded()
        # self.CashBinariesInSandbox() # TODO: but maybe this logic will be inside PrepareBinaries(). on the other hand cashing doesn't need acradia and shoild be as soon as possible. And
        # PrepareBinaries() needs arcadia (for syncing to nirvana. It means that you should somehow separate it. Or maybe it's okay to sync a bit later, after checkouting arcadia,
        # maybe it won't fail.
        self.PrepareArcadia()  # no need to do it before build - arcadia tells us about reactor and nirvana details, not build details
        self.PrepareBinaries()
        self.PrepareReactorReleaseConfig()

    def GetFetchBinMethod(self, bin_name, bin_spec):
        if bin_spec.regular_release and self.Parameters.reg_customize_binaries or not bin_spec.regular_release and self.Parameters.nonreg_customize_binaries:
            fetch_bin_method = getattr(self.Parameters, get_how_to_build_bin_parameter_str(bin_name))
            if not fetch_bin_method:
                fetch_bin_method = DEFAULT_GENERAL_METHOD
            if fetch_bin_method != DEFAULT_GENERAL_METHOD:
                return fetch_bin_method

        fetch_bin_method = self.Parameters.reg_binaries_build_method if bin_spec.regular_release else self.Parameters.nonreg_binaries_build_method

        return fetch_bin_method

    def ShouldApplyBinariesCashingLogic(self, arcadia_url):
        return GetRevision(arcadia_url) != 'HEAD' and not self.Parameters.prohibit_using_cache

    def CreateOneBuildSubtask(self, binary_name, bin_spec, fetch_method, bin_name_to_task_id_and_svn_url):
        if fetch_method == CUSTOM_ARCADIA_URL:
            build_from_svn_url = getattr(self.Parameters, get_arcadia_url_bin_parameter_str(binary_name))
        elif fetch_method == GENERAL_ARCADIA_URL:
            build_from_svn_url = self.Parameters.reg_general_arcadia_url if bin_spec.regular_release else self.Parameters.nonreg_general_arcadia_url
        else:
            raise Exception("How to build binary {}?!".format(binary_name))

        # TODO: for cash-logic
        # attrs_for_fetching_ready_bin = [{BUILD_SVN_PATH_ATTR_NAME: build_from_svn_url, "released": "stable"}, {BUILD_SVN_PATH_ATTR_NAME: build_from_svn_url, "released": "testing"}] if self.ShouldApplyBinariesCashingLogic(build_from_svn_url) else None

        # (bin_resource_id, bin_build_task_id) = us_bin.get_binary_from_svn_path(binary_name, USER_SESSIONS_BINARIES[binary_name],
                                                                           # self, build_from_svn_url, attrs_for_fetching_ready_bin)

        # if bin_resource_id is not None:
            # bin_name_to_ready_resource_id[binary_name] = bin_resource_id
        # else:
        subtask_type = sdk2.Task["YA_MAKE"]

        # TODO: ttl somehow. or after - set ttl-attrs myself
        params = {
                'arch': 'linux',
                'checkout_arcadia_from_url': build_from_svn_url,
                'targets': bin_spec.target,
                'arts': pj(bin_spec.target, binary_name),
                'result_rt': str(bin_spec.resource_type),
                'build_system': 'semi_distbuild',
                'build_type': 'release',
                'use_aapi_fuse': True,
                'aapi_fallback': True,
                'check_return_code': True,
                'result_single_file': True,
                'result_ttl': '30',
                'build_output_ttl': 1,
                'build_output_html_ttl': 1,
                'allure_report_ttl': 1,
                consts.STRIP_BINARIES: True,
        }

        subtask = subtask_type(self, description='Building %s binary' % binary_name, **params)
        sdk2.Task.server.task[subtask.id].update({'requirements': {'disk_space': 80737418240, 'ram': 4096}})
        subtask.enqueue()
        bin_name_to_task_id_and_svn_url[binary_name] = (subtask.id, build_from_svn_url)
        return subtask

    def CreateOneBuildSubtaskIfNeeded(self, binary_name):
        if (self.Context.bin_name_to_task_id_and_svn_url == ctm.NotExists):
            bin_name_to_task_id_and_svn_url = {}
            binary_spec = REACTOR_BINARIES[binary_name]
            fetch_method = self.GetFetchBinMethod(binary_name, binary_spec)
            if fetch_method == DO_NOT_BUILD:
                return
            else:
                subtask = self.CreateOneBuildSubtask(binary_name, binary_spec, fetch_method, bin_name_to_task_id_and_svn_url)

            self.Context.bin_name_to_task_id_and_svn_url = bin_name_to_task_id_and_svn_url

            # TODO: for cash-logic
            # self.ctx[BIN_NAME_TO_READY_RESOURCE_ID] = bin_name_to_ready_resource_id

            raise sdk2.WaitTask([subtask], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def CreateBuildSubtasksIfNeeded(self):
        if (self.Context.bin_name_to_task_id_and_svn_url == ctm.NotExists):
            # haven't created build_tasks yet
            subtasks = []
            bin_name_to_task_id_and_svn_url = {}
            # bin_name_to_ready_resource_id = {} # TODO: for cash-logic

            for binary_name, bin_spec in REACTOR_BINARIES.iteritems():
                fetch_method = self.GetFetchBinMethod(binary_name, bin_spec)
                if fetch_method == DO_NOT_BUILD:
                    continue
                else:
                    subtasks.append(self.CreateOneBuildSubtask(binary_name, bin_spec, fetch_method, bin_name_to_task_id_and_svn_url))

            self.Context.bin_name_to_task_id_and_svn_url = bin_name_to_task_id_and_svn_url

            # TODO: for cash-logic
            # self.ctx[BIN_NAME_TO_READY_RESOURCE_ID] = bin_name_to_ready_resource_id

            raise sdk2.WaitTask(subtasks, ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)
        # elif not utils.check_all_subtasks_done():
            # utils.restart_broken_subtasks()

    def DoRelease(self):
        reac_token_path = self.GetReactorTokenPath()

        config_path = pj(str(self.path()), 'do_release_config_file')
        print >>open(config_path, 'w'), self.Context.config_content

        # TODO reactor-server to Parameters?
        cmd = ["{} {}".format(sys.executable, pj(self.reactor_dir, "us_reactor", "tools", "do_release_string_artifacts.py")),
               "-s", "reactor.yandex-team.ru",
               "-t", reac_token_path,
               "-c", config_path,
               "-v"]
        result, error = RunProcess(cmd, self.GetEnv(), log_prefix="do_release_bin_artifacts")
        return result

    def on_release(self, release_params):
        self.PrepareArcadia()
        self.DoRelease()  # release artifacts
        # TODO: release sb-resources. UPD: take info from Context in order to ignore nonactual child-tasks

        # TODO: the regress-check described below will be implemented inside releasing tool, not in the code of this sb-task

        # check current revision - through reactor-api the freshest artifact-inctance before generating and check its attribute revision (str atribute because all attrs are strings but we'll extract
        # integer) and fail if no attribute or if current-prod revision is higher (but there is force-release flag, whci is default False)
        # maybe this check do twice - here right before releasing and there in the beginning of on_execute (we can even put this check inside Validate
