# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.logs.HashedSessionsDiff import SessionsDiffTask
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.logs.release_helpers.UserSessionsHelper import UserSessionsHelper
import sandbox.projects.release_machine.rm_notify as rm_notify


@rm_notify.notify2()
class GetDiffResourceForUS(sdk2.Task):
    """
        Get diff resource link
    """

    class Parameters(rm_params.ComponentName2):
        diff_task_id = sdk2.parameters.String('Number of Diff task', required=True)
        branch_url = sdk2.parameters.ArcadiaUrl('path of new release branch', required=True)
        release_num = sdk2.parameters.String('Release number', default=None)

    def on_execute(self):
        children = sdk2.Task[self.Parameters.diff_task_id].find(task_type=sdk2.Task[SessionsDiffTask.type], hidden=True).first()
        self.Context.children_id_num = str(children)
        diff_resource = sdk2.Resource['SESSIONS_DIFF_TABLES_LIST'].find(task=children).first()

        message = ""
        if diff_resource:
            message = "!!CHECK DIFF HERE!!\nhttps://sandbox.yandex-team.ru/resource/" + str(diff_resource.id) + "/view"
        else:
            message = "!!(green)DIFF IS EMPTY!!"

        message += "\n\n((https://sandbox.yandex-team.ru/task/" + self.Parameters.diff_task_id + "/view Priemka task))\n((https://sandbox.yandex-team.ru/task/" + str(children.id) + "/view Diff task))"

        UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            branch_url=self.Parameters.branch_url,
            message=message,
            send_to_tg=True,
            send_to_st=True,
            is_summon_people_to_st=True,
            add_duty_login=True,
            prepare_diff_res=True,
            release_num=self.Parameters.release_num,
            bin_diff_task_id=self.Parameters.diff_task_id,
            component_name=self.Parameters.component_name,
        ).enqueue()
