# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk import sandboxapi
from sandbox.projects.logs.resources import UsBinariesReleaseInfo
from sandbox.sandboxsdk.process import run_process
import re
from sandbox.common.types import task as ctt
import sandbox.projects.release_machine.rm_notify as rm_notify


def get_last_success_resource(res_type=UsBinariesReleaseInfo, arch=sandboxapi.ARCH_LINUX):
    last_released_res = sdk2.Resource.find(
        type=res_type,
    ).order(-sdk2.Resource.id).limit(30)

    for res in last_released_res:
        task = sdk2.Resource[res.id].task
        url = task.Parameters.reg_general_arcadia_url

        # check url for nonzero to filter out manual builds
        if (
            task.status in ctt.Status.RELEASED and
            url is not None
        ):
            return url

    raise Exception("No release in last 30 resources")


@rm_notify.notify2()
class GetLastGoodReleaseInfo(sdk2.Task):
    """
        Get last success release info
    """

    class Parameters(sdk2.Task.Parameters):
        new_branch = sdk2.parameters.ArcadiaUrl('path of new release branch', required=True)

    def RunProcess(self, cmd, log_prefix=None, exception_if_nonzero_code=True):
        cmd_str = ' '.join([str(cmd_elem) for cmd_elem in cmd])
        process = run_process(
            cmd_str,
            outs_to_pipe=True, check=False, shell=True, wait=True,
            log_prefix=log_prefix,
        )
        result, error = process.communicate()
        if exception_if_nonzero_code and process.returncode != 0:
            raise Exception(error)
        return result, error

    def on_execute(self):
        cmd = ['svn', 'log', 'svn+ssh://arcadia.yandex.ru' + self.Parameters.new_branch.replace('arcadia:', ''), '--stop-on-copy', '--limit', '1', '-r', 'r1:HEAD', '--xml', '|', 'grep', '-Ei', '"revision="', '|', 'grep', '-oEi', '"[0-9]+"']
        result, error = self.RunProcess(cmd)
        new_revision = re.sub(r"\W", "", result)
        self.Context.svn_new_branch_revision = new_revision
        self.Context.svn_new_branch_path = self.Parameters.new_branch + '/arcadia@' + new_revision
        self.Context.new_branch_name = '-'.join(self.Parameters.new_branch.replace('arcadia:/arc/branches/user_sessions/', '').split('/'))
        self.Context.svn_old_branch_path = get_last_success_resource()
