# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.projects.logs.release_helpers.UserSessionsHelper import UserSessionsHelper
import sandbox.projects.release_machine.input_params2 as rm_params


class UserSessionsRMBinInfo(sdk2.Resource):
    """
        File with RM US Bin build info
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    z2_id = sdk2.parameters.String()
    reactor_id = sdk2.parameters.String()
    branch = sdk2.parameters.String()


class UserSessionsRMScriptsInfo(sdk2.Resource):
    """
        File with RM US Scripts build info
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    z2_id = sdk2.parameters.String()
    reactor_id = sdk2.parameters.String()
    branch = sdk2.parameters.String()
    fallback = sdk2.parameters.Bool()


class PrepareUSRMResource(sdk2.Task):
    class Parameters(rm_params.ComponentName2):
         with sdk2.parameters.RadioGroup("Just a radio field group") as mode:
                mode.values.Binaries = None
                mode.values.Scripts = None
         z2_task_id = sdk2.parameters.String('Number of z2 build task', required=False)
         reactor_task_id = sdk2.parameters.String('Number of reactor build task', required=True)
         branch_url = sdk2.parameters.ArcadiaUrl('path of new release branch', required=True)
         release_num = sdk2.parameters.String('Release number', default=None)
         fallback_mode = sdk2.parameters.Bool("Is fallback release", default_value=False)

    def on_execute(self):
        if (self.Parameters.z2_task_id or self.Parameters.fallback_mode) and self.Parameters.reactor_task_id:
            scripts_info = self.path('scripts_info.txt')
            f = open(str(scripts_info), 'w')
            f.write("Test")
            f.close()
        else:
            raise Exception("No parent tasks")
        message = ""
        if self.Parameters.mode == "Binaries":
            sdk2.ResourceData(UserSessionsRMBinInfo(
                self,
                "Output file",
                str(scripts_info),
                z2_id=self.Parameters.z2_task_id,
                reactor_id=self.Parameters.reactor_task_id,
                branch=self.Parameters.branch_url
            ))
            message = "Binaries build tasks finished"
        else:
            sdk2.ResourceData(UserSessionsRMScriptsInfo(
                self,
                "Output file",
                str(scripts_info),
                z2_id=self.Parameters.z2_task_id,
                reactor_id=self.Parameters.reactor_task_id,
                branch=self.Parameters.branch_url,
                fallback=self.Parameters.fallback_mode,
            ))
            message = "Scripts build tasks finished"
            if self.Parameters.fallback_mode:
                message = "FALLBACK MODE!\n" + message

        message = message + "\n((https://sandbox.yandex-team.ru/task/{}/view Z2 build task))\n((https://sandbox.yandex-team.ru/task/{}/view Reactor build task))".format(self.Parameters.z2_task_id, self.Parameters.reactor_task_id)
        UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            branch_url=self.Parameters.branch_url,
            message=message,
            send_to_tg=True,
            send_to_st=True,
            release_num=self.Parameters.release_num,
            is_summon_people_to_st=True,
            add_duty_login=True,
            component_name=self.Parameters.component_name,
        ).enqueue()
