# -*- coding: utf-8 -*-
from sandbox import sdk2
import logging
import datetime
import time
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.core.task_env as task_env
from sandbox.common.types import task as ctt
from sandbox.projects.release_machine_tasks.ReleaseSearchComponentZ2 import ReleaseSearchComponentZ2
import sandbox.projects.release_machine.input_params2 as rm_params
from sandbox.projects.logs.release_helpers import UserSessionsHelper
from sandbox.projects.logs.release_helpers.PrepareUSRMResource import UserSessionsRMBinInfo
from sandbox.projects.logs.release_helpers.PrepareUSRMResource import UserSessionsRMScriptsInfo
import sandbox.projects.release_machine.rm_notify as rm_notify

INFRA_TOKEN_OWNER = 'zomb-sean'
INFRA_TOKEN_NAME = 'SCARAB_INFRA_TOKEN'

@rm_notify.notify2()
class ReleaseUserSessionsBinOnTime(sdk2.Task):
    """
        Release user sessions binaries on time
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [task_env.TaskRequirements.startrek_client]
        client_tags = task_env.TaskTags.startrek_client

    class Parameters(rm_params.ComponentName2):
        branch_url = sdk2.parameters.ArcadiaUrl('path of new release branch', required=True)
        release_number = sdk2.parameters.String('RM release number', required=True)
        release_immediately = sdk2.parameters.Bool('release immediately', default=False)
        with sdk2.parameters.RadioGroup("Release mode") as mode:
                mode.values.Binaries = None
                mode.values.Scripts = None
        fallback_mode = sdk2.parameters.Bool('Fallback mode', default=False)

    def start_event_in_infra(self, timestamp):
        infra_token = sdk2.Vault.data(INFRA_TOKEN_OWNER, INFRA_TOKEN_NAME)
        return UserSessionsHelper.add_event_to_infra(self.Parameters.mode, infra_token, self.Parameters.release_number, self.Parameters.branch_url, timestamp, self.Parameters.component_name)

    def send_to_st(self, message, wait_sessions=False, binaries_release=False,  yt_path=None, event_id=None, ts=None):
        UserSessionsHelper.UserSessionsHelper(
            self,
            description="Child of test task {}".format(self.id),
            binaries_release=binaries_release,
            branch_url=self.Parameters.branch_url,
            message=message,
            send_to_tg=True,
            send_to_st=True,
            release_num=self.Parameters.release_number,
            is_summon_people_to_st=True,
            add_duty_login=True,
            wait_sessions_mode=wait_sessions,
            wait_sessions_ts=ts,
            yt_sessions_path=yt_path,
            component_name=self.Parameters.component_name,
            event_id=event_id,
        ).enqueue()

    def on_execute(self):
        mode = self.Parameters.mode
        if not self.Context.z2_id and not self.Context.reactor_id:
            if mode == "Binaries":
                resource = UserSessionsRMBinInfo.find(
                    attrs=dict(branch=self.Parameters.branch_url)
                ).first()
            else:
                attrs=dict(branch=self.Parameters.branch_url, fallback=self.Parameters.fallback_mode)
                resource = UserSessionsRMScriptsInfo.find(
                    attrs=attrs
                ).first()
            if resource:
                logging.info('self.memoize_stage.get_id')
                self.Context.z2_id = resource.z2_id
                logging.info(str(self.Context.z2_id))
                self.Context.reactor_id = resource.reactor_id
                logging.info(str(self.Context.reactor_id))
            else:
                raise Exception("No resources for branch {}".format(str(self.Parameters.branch_url)))
        m = datetime.datetime.now().minute
        logging.info('Current time {}'.format(m))
        with self.memoize_stage.z2:
            diff = 0
            if not self.Parameters.release_immediately:
                if m < 35 and m >= 5:
                    diff = 36 - m
                else:
                    if m > 30:
                        diff = 66 - m
                    else:
                        diff = 5 - m
            logging.info('Time to start {}'.format(diff))
            time.sleep(diff * 60)
            if not self.Parameters.fallback_mode:
                z2_task = self.release_z2(self.Context.z2_id, self.Parameters.release_number, self.Parameters.component_name)
                self.Context.z2_subtask_id = z2_task
                raise sdk2.WaitTask([z2_task], ctt.Status.Group.FINISH, timeout=620)
        with self.memoize_stage.reactor:
            if not self.Parameters.fallback_mode:
                z2_task = self.Context.z2_subtask_id
                if (self.server.task[z2_task].read()["status"] == ctt.Status.SUCCESS):
                    logging.info('Deploy Reactor is ok #{}'.format(z2_task))
                else:
                    self.send_to_st("{}.\nFail Z2 deploy - ((https://sandbox.yandex-team.ru/task/{} Z2 deploy Task))".format(mode, z2_task))
                    raise Exception("Z2 subtask #{} is failed".format(z2_task))
            self.release_reactor(self.Context.reactor_id)
            raise sdk2.WaitTask([self.Context.reactor_id], [ctt.Status.Group.BREAK, ctt.Status.RELEASED], timeout=420)
        if (self.server.task[self.Context.reactor_id].read()["status"] == ctt.Status.RELEASED):
            logging.info('Deploy Reactor is ok #{}'.format(self.Context.reactor_id))
        else:
            self.send_to_st("{}.\nFail reactor deploy - ((https://sandbox.yandex-team.ru/task/{} Reactor deploy task))".format(mode, self.Context.reactor_id))
            raise Exception("Reactor subtask #{} is failed".format(self.Context.reactor_id))
        logging.info('IS OK {}'.format(datetime.datetime.now().minute))
        msg = "{} released.\nDeploy reactor is ok - ((https://sandbox.yandex-team.ru/task/{} Deploy reactor task))\nDeploy Z2 is ok - ((https://sandbox.yandex-team.ru/task/{} Deploy Z2 task))".format(mode, self.Context.reactor_id, self.Context.z2_subtask_id)
        if self.Parameters.fallback_mode:
            msg = "!!! FALLBACK MODE !!!\n" + msg
        da = datetime.datetime.now()
        if da.minute > 0 and da.minute < 30:
            da = da.replace(minute=0, second=0)
        else:
            da = da.replace(minute=30, second=0)
        ts = int(time.mktime(da.timetuple()))
        msg = msg + "\n{} released. Waiting sessions {} (timestamp={})\nhttps://yt.yandex-team.ru/hahn/navigation?path=//user_sessions/pub/search/fast/{}".format(mode, da.strftime('%d %b %Y %H:%M'), ts, ts)
        self.send_to_st(msg)
        event_id = self.start_event_in_infra(int(ts))
        release_bin = mode == "Binaries"
        self.send_to_st(msg, binaries_release=release_bin, wait_sessions=True, yt_path='//user_sessions/pub/search/fast/{}/clean'.format(ts), event_id=event_id, ts=ts)

    def release_z2(self, bin_task_id, release_number, component_name):
        z2_task = ReleaseSearchComponentZ2(
            self,
            kill_timeout=500,
            description="Child of test task {}".format(self.id),
            z2_config_id="MR_VELES02",
            roll_to=rm_const.ReleaseStatus.stable,
            component_name=component_name,
            package_tasks=[bin_task_id],
            release_number=release_number,
            marks_resources_as_released=False,
            need_send_st=False,
        ).enqueue()
        return z2_task.id

    def release_reactor(self, reactor_task):
        self.server.release(
            task_id=reactor_task,
            type="stable",
            subject="Release"
        )
