# -*- coding: utf-8 -*-
import sandbox.projects.release_machine.core.task_env as task_env
from sandbox import sdk2
import sandbox.projects.release_machine.helpers.startrek_helper as sh
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.components.all as rmc
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.projects.release_machine.rm_notify as rm_notify


@rm_notify.notify2()
class SendMessageToStFromRM(sdk2.Task):
    """
        Send message to release ST ticket
    """

    class Requirements(sdk2.Task.Requirements):
        environments = [task_env.TaskRequirements.startrek_client]
        client_tags = task_env.TaskTags.startrek_client
        cores = 1  # exactly 1 core
        ram = 4096  # 4GiB or less

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
         st_message = sdk2.parameters.String('Message to ST', required=True)
         summonees = sdk2.parameters.String('Summon', default=None)
         maillistSummonees = sdk2.parameters.String('maillistSummonees', default=None)

    def on_execute(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        last_scope_num = c_info.last_scope_num
        st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        st_helper.comment(
            last_scope_num,
            self.Parameters.st_message,
            c_info,
            summonees=self.Parameters.summonees.split(',') if self.Parameters.summonees else None,
            maillist_summonees=self.Parameters.maillistSummonees.split(',') if self.Parameters.maillistSummonees else None,
        )
