# -*- coding: utf-8 -*-
import requests
import json
import logging
import time
from os.path import join as pj
from sandbox import sdk2
from datetime import datetime
from sandbox.common.types import task as ctt
from sandbox.common.types import resource as ctr
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import environments
import sandbox.projects.release_machine.core.task_env as task_env
from sandbox.common.errors import TaskFailure
import sandbox.common.types.notification as ctn
from sandbox.common.types.resource import State
from sandbox.projects.common import link_builder as lb
from sandbox.projects.common.arcadia import sdk as arcadia_sdk
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.projects.release_machine.helpers.startrek_helper as sh
import sandbox.projects.release_machine.components.all as rmc
import sandbox.projects.release_machine.core.const as rm_const
import sandbox.projects.release_machine.rm_notify as tg
from sandbox.projects.BuildSearch import BuildSearch
import sandbox.projects.release_machine.changelogs as rm_ch
import sandbox.projects.release_machine.resources as rm_res
from sandbox.projects.rtmr.RtmrGraphDeploy import RtmrGraphDeploy


RTMR_FIRST_CLUSTER = "rtmr-vla"
RTMR_SECOND_CLUSTER = "rtmr-sas"
RTMR_SOLOMON_LOGS_PROCESS = "https://solomon.yandex-team.ru/?project=rtmr&cluster={}&service=kpi&dashboard=rtmr-log-lags-newest&proxylabel=direct&b=1h&e="
RTMR_SOLOMON_YF_STATUS = "https://solomon.yandex-team.ru/?project=yf&cluster={}&service=yf+functions&host=cluster&dashboard=yf-function-direct&l.jobSetPath=user_sessions&l.version=Total&b=1h&e="
US_TG_ID = '-1001174341921'
RTMR_TG_ID = '-1001403226286'
INFRA_URL = 'https://infra-api.yandex-team.ru/v1/events'
WAIT_TABLE_PATH_TEMPLATE = '//user_sessions/pub/search/fast/{}/clean'


class UserSessionsRMannouncementInfo(sdk2.Resource):
    """
        File with RM US announcement info
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()


class UserSessionsRMBinDiffInfo(sdk2.Resource):
    """
        File with RM US announcement info
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()
    diff_task_id = sdk2.parameters.String()

class UserSessionsRTMRPrepareTaskInfo(sdk2.Resource):
    """
        File with RM US announcement info
    """
    releasable = False
    any_arch = True
    executable = False
    auto_backup = True
    branch = sdk2.parameters.String()
    prepare_task_id = sdk2.parameters.String()

YQL_TOKEN_OWNER = 'USERSESSIONSTOOLS'
YQL_TOKEN_NAME = 'SCARAB_YQL_TOKEN'
INFRA_TOKEN_OWNER = 'zomb-sean'
INFRA_TOKEN_NAME = 'SCARAB_INFRA_TOKEN'

WAKE_UP_TIME = 9
GOOD_NIGHT_TIME = 24
# TODO get from staff API
TG_LOGINS = {
    'bagiro44': '@bagiro44',
    'gavrgavr': '@gavrgav',
    'shadowgorn': '@shadowgorn',
    'kkhamitov' : '@lberserq',
    'ngc224': '@ngc292',
    'sinister': '@azmariel',
    'dalamar': '@bestrezen',
    'kender': '@kenderolly',
    'mmatrosova': '@mirrada',
    'exoron': '@twexoron'
    }

def get_ticket_key(release_num, component_name):
    st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
    c_info = rmc.COMPONENTS[component_name]()
    release_num = release_num if release_num else c_info.last_scope_num
    return st_helper.find_ticket_by_release_number(release_num, c_info).key

def get_revision(url):
    if url.count("@") != 1:
        return None
    return url.split("@")[-1]

def prepare_infra_config(release_type, release_num, branch, timestamp, component_name, type_of_event):
    serviceId = 288
    if type_of_event == "us_release":
        title = "Update {} #{}({})".format(release_type, release_num, get_revision(branch))
        description = "Update {} on Z2 and reactor".format(release_type)
        environmentId = 380
        startTime = timestamp
    else:
        title = "Update US tasks on {} release #{}({})".format(type_of_event, release_num, get_revision(branch))
        description = "Update US tasks on {}".format(type_of_event)
        startTime = timestamp + 3600
        finishTime = timestamp + 4200
        if type_of_event == "rtmr-vla":
            environmentId = 2874
        if type_of_event == "rtmr-man4":
            environmentId = 2875
        if type_of_event == "rtmr-sas":
            environmentId = 3414

    payload = {
      "title": title,
      "description": description,
      "environmentId": environmentId,
      "serviceId": serviceId,
      "startTime": startTime,
      "type": "maintenance",
      "severity": "major",
      "tickets": str(get_ticket_key(release_num, component_name)),
      "sendEmailNotifications": False,
      "setAllAvailableDc": True
    }
    if not type_of_event == "us_release":
        payload["finishTime"] = finishTime
    return payload

def add_event_to_infra(release_type, token, release_num, branch, timestamp, component_name, type_of_event="us_release"):
    payload = prepare_infra_config(release_type, release_num, branch, timestamp, component_name, type_of_event)
    headers = {'Authorization': 'OAuth {}'.format(token), 'Content-Type': 'application/json'}
    r = requests.post(INFRA_URL, data=json.dumps(payload), headers=headers)
    if r.status_code == 200:
        j = json.loads(r.content)
        return j["id"]
    return None


def remove_event_from_infra(event_id, token):
    if not event_id:
        return

    payload = {}
    headers = {'Authorization': 'OAuth {}'.format(token), 'Content-Type': 'application/json'}
    r = requests.delete(INFRA_URL + "/" + str(event_id), data=json.dumps(payload), headers=headers)
    logging.info(r.content)

    return r.content

def finish_infra_event(event_id, finish_time, token):
    if not event_id:
        return

    payload = {"finishTime": int(finish_time)}
    headers = {'Authorization': 'OAuth {}'.format(token), 'Content-Type': 'application/json'}
    r = requests.put(INFRA_URL + "/" + str(event_id), data=json.dumps(payload), headers=headers)
    logging.info(r.content)

    return r.content

class UserSessionsHelper(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [task_env.TaskRequirements.startrek_client, environments.PipEnvironment('yandex-yt', version='0.10.8')]
        client_tags = task_env.TaskTags.startrek_client
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
        release_num = sdk2.parameters.String('Release number', default=None)
        binaries_release = sdk2.parameters.Bool(
            "Is binaries stage",
            default_value=False,
        )
        announce = sdk2.parameters.Bool(
            "Announce finished release",
            default_value=False,
        )
        close_st = sdk2.parameters.Bool(
            "Close release ticket",
            default_value=False,
        )
        send_to_tg = sdk2.parameters.Bool(
            "Send message to telegram",
            default_value=False,
        )
        send_to_email = sdk2.parameters.Bool(
            "Send via email",
            default_value=False,
        )
        send_to_st = sdk2.parameters.Bool(
            "Send message to st",
            default_value=False,
        )
        prepare_diff_res = sdk2.parameters.Bool(
            "Prepare resource with diff task id",
            default_value=False,
        )
        set_bin_released = sdk2.parameters.Bool(
            "Set resource in buld search as released",
            default_value=False,
        )
        is_summon_people_to_st = sdk2.parameters.Bool(
            "Summon people to st",
            default_value=False,
        )
        is_summon_maillist_to_st = sdk2.parameters.Bool(
            "Summon mail list to st",
            default_value=False,
        )
        mark_as_urgent = sdk2.parameters.Bool(
            "Mark as urgent",
            default_value=False,
        )
        add_duty_login = sdk2.parameters.Bool(
            "Add duty login to message",
            default_value=False,
        )
        wait_sessions_mode = sdk2.parameters.Bool(
            "Do wait sessions",
            default_value=False,
        )
        wait_sessions_check_interval = sdk2.parameters.Integer(
            "Check sessions interval in seconds",
            default_value=1200,
        )
        wait_sessions_ts = sdk2.parameters.Integer(
            "Waiting sessions timestamp",
        )
        ralib_date = sdk2.parameters.String(
            "Date for ralib test",
        )
        event_id = sdk2.parameters.String('Id of event in infra', default=None)
        test_option = sdk2.parameters.Bool(
            "TEST OPTION",
            default_value=False,
        )
        subject = sdk2.parameters.String('Mail subject', default=None)
        branch_url = sdk2.parameters.ArcadiaUrl('path of new release branch', required=True)
        message = sdk2.parameters.String('st/tg/email message', default=None)
        summonees = sdk2.parameters.String('Summon logins', default=None)
        maillistSummonees = sdk2.parameters.String('Maillist summonees emails', default=None)
        bin_diff_task_id = sdk2.parameters.String('bin_diff_task_id', default=None)
        yt_sessions_path = sdk2.parameters.String('yt sessions path', default=None)
        rtmr_prepare_resource = sdk2.parameters.Bool(
            "Prepare resource for rtmr release",
            default_value=False,
        )
        rtmr_release_mode = sdk2.parameters.Bool(
            "Release RTMR after 1h and 24 h",
            default_value=False,
        )
        rtmr_yf_task = sdk2.parameters.String('RTMR YF bin task #', default=None)

    class Context(sdk2.Context):
        checkout_arcadia_from_url = None
        infra_events = {}
        ralib_date = None
        rtmr_cluster_name = None
        yt_sessions_path = None

    def get_revision(self, url):
        if url.count("@") != 1:
            return None
        return url.split("@")[-1]

    def get_summonees(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        duty_login = c_info.get_responsible_for_release()
        logging.info('duty login {}'.format(duty_login))
        summonees = []
        if self.Parameters.summonees and self.Parameters.summonees != '':
            summonees.extend(self.Parameters.summonees.split(','))
        if self.Parameters.add_duty_login and duty_login:
            summonees.append(duty_login)
        logging.info('summonees {}'.format(str(summonees.append)))
        return summonees

    def get_ticket_key(self):
        st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        release_num = self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num
        return st_helper.find_ticket_by_release_number(release_num, c_info).key

    def send_msg_to_st(self, message, need_summon_people, need_summon_maillist):
        st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        release_num = self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num
        summonees = self.get_summonees()
        revision = get_revision(self.Parameters.branch_url)
        revision_str = 'Revision #{}. '.format(revision) if revision else ''
        message = '{}{}'.format(revision_str, message)
        st_helper.comment(
            release_num,
            message,
            c_info,
            summonees=summonees if need_summon_people and summonees else None,
            maillist_summonees=self.Parameters.maillistSummonees.split(',') if need_summon_maillist and self.Parameters.maillistSummonees else None,
        )

    def close_st_issue(self):
        st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        release_num = self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num
        issue = st_helper.find_ticket_by_release_number(release_num, c_info)
        st_helper.close_issue(issue, 'Closing obsolete ticket, because {} branch is released'.format(release_num))

    def send_msg_to_tg(self, message, chat_ids=[US_TG_ID], need_q=True, need_summon_logins=True):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        not_sleep_time = WAKE_UP_TIME < datetime.now().hour < GOOD_NIGHT_TIME
        summonees = self.get_summonees()
        if need_summon_logins and summonees and not_sleep_time:
            for index, r in enumerate(summonees):
                summonees[index] = TG_LOGINS[r]
            summonees_str = ', '.join(summonees)
            message = '{} {}'.format(message, summonees_str)
        release_num = self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num
        revision = get_revision(self.Parameters.branch_url)
        revision_str = '({})'.format(revision) if revision else ''
        message = 'Release #{}{}. {}'.format(release_num, revision_str, message)
        tg.send_tm_message(self, message, chat_ids)

    def send_email(self, subject, message, maillistSummonees):
        self.server.notification(
            subject=subject,
            body=message,
            recipients=[maillistSummonees],
            transport=ctn.Transport.EMAIL,
            urgent=self.Parameters.mark_as_urgent,
        )

    def prepare_diff_task_info(self, branch, diff_task_id):
        diff_info = self.path('diff_info.txt')
        f = open(str(diff_info), 'w')
        f.write("Diff")
        f.close()
        sdk2.ResourceData(UserSessionsRMBinDiffInfo(
            self,
            "Output file",
            str(diff_info),
            branch=branch,
            diff_task_id=diff_task_id,
        ))

    def set_bin_released(self, branch_name, branch_with_revision):
        resource = UserSessionsRMBinDiffInfo.find(attrs=dict(branch=branch_with_revision)).first()
        if resource:
            diff_childs = sdk2.Task[resource.diff_task_id].find(task_type=sdk2.Task[BuildSearch.type], hidden=True)
            for task in diff_childs:
                logging.info("fffff task {}".format(task.id))
                if sdk2.Task[task.id].Context.checkout_arcadia_from_url == branch_with_revision:
                    self.release_task_resource(task.id)

    def release_task_resource(self, task_id):
        self.server.release(
            task_id=task_id,
            type="stable",
            subject="Release"
        )

    def announce(self, branch):
        resource = UserSessionsRMannouncementInfo.find(attrs=dict(branch=branch), state=State.READY).first()
        if not resource:
            announce_info = self.path('scripts_info.txt')
            f = open(str(announce_info), 'w')
            f.write("Announce")
            f.close()
            sdk2.ResourceData(UserSessionsRMannouncementInfo(
                self,
                "Output file",
                str(announce_info),
                branch=branch
            ))
            logging.info('branch is - {}'.format(branch))
            subject = 'Released {}'.format(branch)
            message = 'Branch is released. \n{} \n{}'.format(branch, get_ticket_key(self.Parameters.release_num, self.Parameters.component_name))
            self.send_msg_to_st(
                message,
                self.Parameters.is_summon_people_to_st,
                self.Parameters.is_summon_maillist_to_st,
            )
            if self.Parameters.send_to_tg:
                self.send_msg_to_tg(message)
            if self.Parameters.send_to_email:
                self.send_email(subject, message, self.Parameters.maillistSummonees)
            if self.Parameters.send_to_st:
                self.send_msg_to_st(
                    message,
                    self.Parameters.is_summon_people_to_st,
                    self.Parameters.is_summon_maillist_to_st,
                )
            self.send_msg_for_linked_tickets()
            if self.Parameters.set_bin_released:
                self.set_bin_released(branch, self.Parameters.branch_url)
            self.update_release_num()

    def prepare_diff_with_prev_sessions(self, timestamp, ytClient):
        attrs = ['uncompressed_data_size', 'row_count']

        main_str = ""
        diff_30mi_str = "-30m diff\n"
        diff_60mi_str = "-1h diff\n"

        main_json = json.loads(ytClient.get(WAIT_TABLE_PATH_TEMPLATE.format(timestamp), attributes=attrs, format="json"))
        minus_30min =  json.loads(ytClient.get(WAIT_TABLE_PATH_TEMPLATE.format(timestamp-1800), attributes=attrs, format="json"))
        minus_60min =  json.loads(ytClient.get(WAIT_TABLE_PATH_TEMPLATE.format(timestamp-3600), attributes=attrs, format="json"))

        for attr_name in attrs:
            main_value = main_json['$attributes'][attr_name]
            main_str = main_str + "{}: {}\n".format(attr_name, main_value)
            minus_30min_value = minus_30min['$attributes'][attr_name]
            min30_diff = main_value-minus_30min_value
            min30_perc = "%.2f" % (min30_diff/float(main_value) * 100)
            diff_30mi_str = diff_30mi_str + "{}: {}%\n".format(attr_name, min30_perc)

            minus_60min_value = minus_60min['$attributes'][attr_name]
            min60_diff = main_value-minus_60min_value
            min60_perc = "%.2f" % (min60_diff/float(main_value) * 100)
            diff_60mi_str = diff_60mi_str + "{}: {}%\n".format(attr_name, min60_perc)
        return "{}\n{}\n{}\n".format(main_str, diff_30mi_str, diff_60mi_str)

    def wait_sessions(self):
        from yt.wrapper import YtClient
        token = sdk2.Vault.data(YQL_TOKEN_OWNER, YQL_TOKEN_NAME)
        client = YtClient('hahn', token)
        yt_sessions_path = self.Parameters.yt_sessions_path
        message = ''
        attempts = 24
        sessions_not_ready = True
        try:
            clean_table = WAIT_TABLE_PATH_TEMPLATE.format(self.Parameters.wait_sessions_ts)
            clean_table_minus_30min =  WAIT_TABLE_PATH_TEMPLATE.format(self.Parameters.wait_sessions_ts-1800)
            clean_table_minus_60min =  WAIT_TABLE_PATH_TEMPLATE.format(self.Parameters.wait_sessions_ts-3600)
            sessions_not_ready = (not client.exists(yt_sessions_path) or not client.exists(clean_table) or not client.exists(clean_table_minus_30min)
                 or not client.exists(clean_table_minus_60min)) and (attempts != 0)
        except:
            logging.info('Fail connect to YT')

        while(sessions_not_ready):
            attempts -= 1
            logging.info('counter is {}'.format(str(attempts)))
            raise sdk2.WaitTime(self.Parameters.wait_sessions_check_interval)

        if attempts == 0:
            message = "Sessions {} is late. Check them manually https://yt.yandex-team.ru/hahn/operation?filter={}".format(yt_sessions_path, yt_sessions_path)
        else:
            message = 'Sessions are ready https://yt.yandex-team.ru/hahn/navigation?path={}\n'.format(yt_sessions_path)
            message += self.prepare_diff_with_prev_sessions(self.Parameters.wait_sessions_ts, client)
            message += "\nCheck their size and keep checking errors anomalies for a few hours:\nhttps://nda.ya.ru/3UgEvN"
        if self.Parameters.send_to_tg:
            self.send_msg_to_tg(message)
        if self.Parameters.send_to_st:
            self.send_msg_to_st(
                message,
                self.Parameters.is_summon_people_to_st,
                self.Parameters.is_summon_maillist_to_st,
            )
        infra_token = sdk2.Vault.data(INFRA_TOKEN_OWNER, INFRA_TOKEN_NAME)
        logging.info("event id - " + str(self.Parameters.event_id))
        if self.Parameters.binaries_release:
            self.send_msg_to_tg("Please run SUCESS_RELEASE_MAIL_USER_SESSIONS. \nPlease run SUCESS_RELEASE_MAIL_USER_SESSIONS. \nPlease run SUCESS_RELEASE_MAIL_USER_SESSIONS. \nPlease run SUCESS_RELEASE_MAIL_USER_SESSIONS. \n")
        if self.Parameters.event_id:
            finish_infra_event(self.Parameters.event_id, "%.0f" % time.time(), infra_token)

    def CheckoutArcadiaSubfolder(self, arcadia_subfolder, use_cache=True):
        dir_url = "arcadia:/arc/trunk/arcadia/{}".format(arcadia_subfolder)
        arcadia_subfolder_local_abs_path = pj(self.arcadia_src_dir, arcadia_subfolder)

        if use_cache:
            with arcadia_sdk.mount_arc_path(dir_url, use_arc_instead_of_aapi=True) as p:
                sdk2.paths.copy_path(str(p), arcadia_subfolder_local_abs_path)
        else:
            sdk2.svn.Arcadia.checkout(dir_url, arcadia_subfolder_local_abs_path)
        return arcadia_subfolder_local_abs_path

    def update_release_num(self):
        release_num = self.Parameters.release_num
        if not release_num:
            return
        self.arcadia_src_dir = pj(str(self.path()), 'local_arcadia')
        branch_file_dir = self.CheckoutArcadiaSubfolder('quality/userdata', use_cache=False)
        f = open(str('{}/override_source_branch'.format(branch_file_dir)), 'w')
        f.write(release_num)
        f.close()
        with ssh.Key(self, "zomb-sean", "Scarab_zomb_key"):
            message = 'User sessions new branch #{} released \n SKIP_CHECK'.format(release_num)
            try:
                svn.Arcadia.commit(
                    ['{}/override_source_branch'.format(branch_file_dir)],
                    message,
                    user='zomb-sean',
                )
            except svn.SvnError as err:
                if 'ew review request' in str(err):
                    self.set_info('\n' + str(err), do_escape=False)
                else:
                    raise Exception(str(err))

    def send_msg_for_linked_tickets(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        st_helper = sh.STHelper(sdk2.Vault.data(rm_const.COMMON_TOKEN_OWNER, rm_const.COMMON_TOKEN_NAME))
        release_num = self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num
        my_attrs = {
            "component": self.Parameters.component_name,
            "minor_release_num": 0,
        }
        if release_num:
            my_attrs["major_release_num"] = release_num
        changelog_resource = sdk2.Resource.find(
            state=ctr.State.READY,
            resource_type=rm_res.RELEASE_MACHINE_CHANGELOG,
            attrs=my_attrs
        ).first()
        comment_text = "User sessions released to production. Release includes commits of this ticket.\n" \
            "https://st.yandex-team.ru/{}\nRelease number: {}"
        if changelog_resource:
            changelog = rm_ch.get_rm_changelog(changelog_resource)
            for change in changelog.get("changes", []):
                for ticket in change.get("startrek_tickets", []):
                    try:
                        issue = st_helper.get_ticket_by_key(ticket)
                        issue.comments.create(
                            text=comment_text.format(
                                get_ticket_key(release_num, self.Parameters.component_name),
                                release_num
                            )
                        )
                    except Exception:
                        logging.info("No access to %s", ticket)

    def get_release_number(self):
        c_info = rmc.COMPONENTS[self.Parameters.component_name]()
        return self.Parameters.release_num if self.Parameters.release_num else c_info.last_scope_num

    def run_release_to_yf_task(self, cluster_name):
        resource = UserSessionsRTMRPrepareTaskInfo.find(attrs=dict(branch=self.Parameters.branch_url)).first()
        bin_task_id = resource.prepare_task_id
        message = u'Начинается релиз в {}. Если нужно срочно прекратить релиз - останови его на этой странице https://sandbox.yandex-team.ru/task/{}/children'.format(cluster_name, self.id)
        self.send_msg_to_tg(message, [US_TG_ID])
        rtmr_message = u'Начинается релиз UserSessions в {}. Следить за прогрессом можно здесь https://sandbox.yandex-team.ru/task/{}/children'.format(cluster_name, self.id)
        self.send_msg_to_tg(rtmr_message, [RTMR_TG_ID], False, False)

        deploy_task = RtmrGraphDeploy(
            self,
            description="Deploy User sessions usertasks to YF on {}".format(cluster_name),
            priority=self.Parameters.priority,
            cluster=cluster_name,
            graph="user_sessions",
            build_task=bin_task_id,
            cleanup_missing=True,
            oauth_token_name="ROBOT_MAKE_SESSIONS"
        )
        deploy_task.enqueue()
        raise sdk2.WaitTask(deploy_task, ctt.Status.Group.FINISH|ctt.Status.Group.BREAK, wait_all=True)

    def announce_rtmr_release(self, cluster_name, mode):
        if not cluster_name:
            return

        infra_token = sdk2.Vault.data(INFRA_TOKEN_OWNER, INFRA_TOKEN_NAME)
        duty_logins = ', '.join(self.get_summonees())

        message_rtmr = None
        message_us = None

        if mode == 'start':
            da = datetime.now()
            ts = int(time.mktime(da.timetuple()))
            self.Context.infra_events[cluster_name] = add_event_to_infra(None,
                                                                         infra_token,
                                                                         self.get_release_number(),
                                                                         self.Parameters.branch_url,
                                                                         ts,
                                                                         self.Parameters.component_name,
                                                                         type_of_event=cluster_name)

            message = u'Через 1 час состоится автоматический релиз кода User Sessions в {}'.format(cluster_name)
            message_rtmr = message + u' и eсли это невозможно, обратитесь к дежурному US: {}'.format(duty_logins)
            message_us = message + u' и для его остановки нужно стопнуть таску: {}'.format(lb.task_link(self.id, plain=True))
        elif mode == 'stop':
            remove_event_from_infra(self.Context.infra_events.get(cluster_name), infra_token)
            message = u'Релиз кода UserSessions в {} остановлен'.format(cluster_name)
            message_rtmr = message + u', подробности у дежурного US: {}'.format(duty_logins)
            message_us = message
        else:
            raise Exception("Unknown mode: {}".format(mode))

        if message_rtmr:
            self.send_msg_to_tg(message_rtmr, [RTMR_TG_ID])
        if message_us:
            self.send_msg_to_tg(message_us, [US_TG_ID])

    def check_subtasks(self):
        subtasks = self.find()
        if any(subtask.status != ctt.Status.SUCCESS for subtask in subtasks):
            for subtask in subtasks:
                if subtask.status != ctt.Status.SUCCESS:
                    message = u'Упала таска деплоя в YF, прийдется катить руками https://wiki.yandex-team.ru/logs/release/release_machine/#eslitaskadeplojartmrupalainapravilasjuda'
                    self.send_msg_to_tg(message, [US_TG_ID])
                    raise TaskFailure("Subtask {} finished with status {}".format(subtask.id, subtask.status))
        else:
            logging.info("Success testing!")

    def prepare_rtmr_prepare_resource(self):
        yf_task_id = self.Parameters.rtmr_yf_task
        rtmr_info = self.path('rtmr_info.txt')
        f = open(str(rtmr_info), 'w')
        f.write(yf_task_id)
        f.close()
        sdk2.ResourceData(UserSessionsRTMRPrepareTaskInfo(
            self,
            "Output file",
            str(rtmr_info),
            branch=self.Parameters.branch_url,
            prepare_task_id=self.Parameters.rtmr_yf_task
        ))

    def get_rtmr_monitoring_name(self):
        raw_name = self.Context.rtmr_cluster_name
        if raw_name == "rtmr-man4":
            return "rtmr_man4"
        return raw_name

    def on_execute(self):
        if self.Parameters.ralib_date:
            self.Context.yt_sessions_path = self.Parameters.yt_sessions_path
            self.Context.ralib_date = self.Parameters.ralib_date
        branch = self.Parameters.branch_url.replace('arcadia:/arc/branches/', '').split('/arcadia@')[0]
        if self.Parameters.test_option:
            self.send_msg_for_linked_tickets()
        if self.Parameters.announce:
            self.announce(branch)
        elif self.Parameters.rtmr_prepare_resource:
            self.prepare_rtmr_prepare_resource()
        elif self.Parameters.rtmr_release_mode:
            with self.memoize_stage.announce_vla_release:
                self.Context.rtmr_cluster_name = RTMR_FIRST_CLUSTER
                self.announce_rtmr_release(self.Context.rtmr_cluster_name, "start")
                raise sdk2.WaitTime(3600)
            with self.memoize_stage.vla_release:
                self.run_release_to_yf_task(self.Context.rtmr_cluster_name)
            with self.memoize_stage.wait_one_day:
                monitoring_name = self.get_rtmr_monitoring_name()
                message = u'Релиз в {} окончен. Посмотреть, что всё хорошо можно здесь {} и здесь {}'.format(self.Context.rtmr_cluster_name,
                                                                                                             RTMR_SOLOMON_LOGS_PROCESS.format(monitoring_name),
                                                                                                             RTMR_SOLOMON_YF_STATUS.format(monitoring_name))
                self.Context.rtmr_cluster_name = None
                self.send_msg_to_tg(message, [US_TG_ID])
                self.check_subtasks()
                raise sdk2.WaitTime(82800)
            with self.memoize_stage.announce_man_release:
                self.Context.rtmr_cluster_name = RTMR_SECOND_CLUSTER
                self.announce_rtmr_release(self.Context.rtmr_cluster_name, "start")
                raise sdk2.WaitTime(3600)
            with self.memoize_stage.man_release:
                self.run_release_to_yf_task(self.Context.rtmr_cluster_name)

            monitoring_name = self.get_rtmr_monitoring_name()
            message = u'Релиз в {} окончен. Посмотреть, что всё хорошо можно здесь {} и здесь {}'.format(self.Context.rtmr_cluster_name,
                                                                                                         RTMR_SOLOMON_LOGS_PROCESS.format(monitoring_name),
                                                                                                         RTMR_SOLOMON_YF_STATUS.format(monitoring_name))
            self.Context.rtmr_cluster_name = None
            self.send_msg_to_tg(message, [US_TG_ID])
            self.check_subtasks()
        elif self.Parameters.wait_sessions_mode:
            self.wait_sessions()
        else:
            if self.Parameters.close_st:
                self.close_st_issue()
            if self.Parameters.send_to_tg:
                self.send_msg_to_tg(self.Parameters.message)
            if self.Parameters.send_to_email:
                self.send_email(self.Parameters.subject, self.Parameters.message, self.Parameters.maillistSummonees)
            if self.Parameters.send_to_st:
                self.send_msg_to_st(
                    self.Parameters.message,
                    self.Parameters.is_summon_people_to_st,
                    self.Parameters.is_summon_maillist_to_st,
                )
            if self.Parameters.prepare_diff_res:
                self.prepare_diff_task_info(self.Parameters.branch_url, self.Parameters.bin_diff_task_id)
            if self.Parameters.set_bin_released:
                self.set_bin_released(branch, self.Parameters.branch_url)

    def on_break(self, prev_status, status):
        if status in ctt.Status.STOPPED:
            self.announce_rtmr_release(self.Context.rtmr_cluster_name, "stop")
        super(UserSessionsHelper, self).on_break(prev_status, status)

