# coding: utf-8
import os

from sandbox.sdk2.resource import AbstractResource
from sandbox.projects.resource_types.releasers import user_sessions_releasers

# ########################################################################
# WARNING: add new resource in USER_SESSIONS_RESOURCES_LIST registry below
# ########################################################################


class CREATE_SESSIONS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл построителя пользовательских сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 40
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/create/create_sessions'


class CREATE_SESSIONS_TESTS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл аркадийных тестов сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/createlib/tests/prog/create_sessions_test'


class USER_SESSIONS_SAMPLE_BY_UID_EXECUTABLE(AbstractResource):
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/sample_by_uid/sample_by_uid'


class EXTRACT_TAKEOUT_EXECUTABLE(AbstractResource):
    """
        Executable file to extract data from user sessions for Takeout service
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/extract_takeout/extract_takeout'


class RALIB_RULES_EXECUTABLE(AbstractResource):
    """
        Executable file to calculate metrics
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/ralib_rules/ralib_rules'


class RALIB_ETALON_BINARY(AbstractResource):
    """
        Executable file for testing RAlib's speed
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/ralib_etalon_perfomance_tester/ralib_etalon_perfomance_tester'


class SURPLUS_METRICS_EXECUTABLE(AbstractResource):
    """
        Executable file to calculate surplus metrics
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_metrics/surplus_metrics/surplus_metrics'


class SPY_LOG_SESSION_ACTIVITY_EXTRACTION_EXECUTABLE(AbstractResource):
    """
        Executable file for extracting visits activity from spy_log to separate activity table
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/spy_log_sessions_activity_extraction/spy_log_session_activity_extraction'


class SPY_LOG_ACTIVITY_JOIN_EXECUTABLE(AbstractResource):
    """
        Executable file for joining visits activity from attached traffic item to owner item
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/spy_log_activity_join/spy_log_activity_join'


class BAOBAB_VALIDATOR_EXECUTABLE(AbstractResource):
    """
        Executable file for validating baobab-trees
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/baobab/tools/baobab_counter_validator/cpp/baobab_counter_validator'


class CREATE_NANO_SESSIONS_EXECUTABLE(AbstractResource):
    """
        Executable file for creating nano sessions
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/create_nano_sessions/create_nano_sessions'


class SESSIONS_DIRECT_ADS_DESCRIPTIONS(AbstractResource):
    """
        Resource file with ads descriptions dict for buiding user_sessions
    """
    releasable = True
    any_arch = False
    executable = False
    auto_backup = True
    releasers = user_sessions_releasers


class COMMON_LOGS_JOINER_EXECUTABLE(AbstractResource):
    """
        Join hitlog to chevent log via hitlogid field
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/common_logs_joiner/common_logs_joiner'


class FILTER_BS_DSP_LOG_EXECUTABLE(AbstractResource):
    """
        Join hitlog to chevent log via hitlogid field
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/rtb_ad_logs_filters/filter_bs_dsp_log/filter_bs_dsp_log'


class FILTER_BS_RTB_LOG_EXECUTABLE(AbstractResource):
    """
        Join hitlog to chevent log via hitlogid field
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/rtb_ad_logs_filters/filter_bs_rtb_log/filter_bs_rtb_log'


class SPLIT_IMGREQANS_EXECUTABLE(AbstractResource):
    """
        Splits imgreqans-log into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/splitters/split_imgreqans/split_imgreqans'


class SPLIT_REQANS_EXECUTABLE(AbstractResource):
    """
        Splits reqans-log into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/splitters/split_reqans/split_reqans'


class SPLIT_MARKET_CLICKS_EXECUTABLE(AbstractResource):
    """
        Splits market-clicks-log into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'split_market_clicks'
    arcadia_build_path = 'quality/logs/scarab/splitters/market/identity/identity'


class SPLIT_MARKET_CPA_CLICKS_EXECUTABLE(AbstractResource):
    """
        Splits market-cpa-clicks-log into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'split_market_cpa_clicks'
    arcadia_build_path = 'quality/logs/scarab/splitters/market/identity/identity'


class SPLIT_MARKET_ACCESS_EXECUTABLE(AbstractResource):
    """
        Splits market-access into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'split_market_access'
    arcadia_build_path = 'quality/logs/scarab/splitters/market/identity/identity'


class SPLIT_MARKET_REPORT_EXECUTABLE(AbstractResource):
    """
        Splits market-report into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'split_market_main_report'
    arcadia_build_path = 'quality/logs/scarab/splitters/market/identity/identity'


class SPLIT_MARKET_SHOWS_EXECUTABLE(AbstractResource):
    """
        Splits market-shows into 2 logs - with scarab rows and with non-scarab rows
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'split_market_shows'
    arcadia_build_path = 'quality/logs/scarab/splitters/market/identity/identity'


class IMG_REQANS_FILTER_MERGER(AbstractResource):
    """
        Executable file for merge new imgreqans log rows with specified stypes
        to old imgreqans log without rows with that stypes
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/img_reqans_filter_merger/img_reqans_filter_merger'


class SESSIONS_RTB_PAGEIDS(AbstractResource):
    """
       rtb_pageids
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class LOGSNG2SCARAB_EXECUTABLE(AbstractResource):
    """
        Executable file for converting mobile logs to scarab
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/logsng2scarab/logsng2scarab'


class SESSIONS_YLOGIN_ENC_KEY_TXT(AbstractResource):
    """
        ylogin_enc_key.txt
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class UNIQUE_WATCH_LOG_EXECUTABLE(AbstractResource):
    """
        Executable tool for unique watch log sessions
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/unique_watch_log/unique_watch_log'


class ENTITY_RECOMMENDER_ACCESS2SCARAB_EXECUTABLE(AbstractResource):
    """
        Executable file for converting entity_recommender_access to scarab
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/entity_recommender_access2scarab/entity_recommender_access2scarab'


class HTTP_ADAPTER_ACCESS2SCARAB_EXECUTABLE(AbstractResource):
    """
        Executable file for converting http_adapter-access to scarab logs
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/http_adapter_access2scarab/http_adapter_access2scarab'


class CHECK_SESSIONS_EXISTENCE_EXECUTABLE(AbstractResource):
    """
        Executable file for checking sessions status in rem/reactor and YT
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/reactor/us_processes/check_sessions_existence/check_sessions_existence'


class TYPE_PARSE_LIB_ERROR_EXECUTABLE(AbstractResource):
    """
        Executable file to calculate error statistics
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/type_parse_lib_error/type_parse_lib_error'


class SESSIONS_DIFF_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл диффера пользовательских сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'sessions_diff'
    arcadia_build_path = 'quality/user_sessions/diff/user_sessions_diff'


class HASHED_SESSIONS_DIFF_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл умного диффера пользовательских сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'hashed_sessions_diff'
    arcadia_build_path = 'quality/user_sessions/hashed_diff/hashed_user_sessions_diff'


class REPORT_LOGS_TESTS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл тестера логов репорта
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/tools/report_releases_tester/report_releases_tester'


class CREATE_SCARAB_SESSIONS_EXECUTABLE(AbstractResource):
    """
        Executable file. Builds user_sessions in scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/create_scarab_sessions/create_scarab_sessions'


class REQANS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for reqans-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/reqans2scarab/reqans2scarab'


class WEATHER_ACCESS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for weather-access-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/weather_access2scarab/weather_access2scarab'


class IMGREQANS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for imgreqans-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/imgreqans2scarab/imgreqans2scarab'


class JOINED_BS_DSP_AND_BS_RTB_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Convert joined bs-dsp-log and bs-rtb-log to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/joined_bs_dsp_rtb2scarab/joined_bs_dsp_rtb2scarab'


class MERGE_SESSIONS_EXECUTABLE(AbstractResource):
    """
        Merge sessions
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/reactor/us_processes/nirvana_graphs/merge_sessions/merge_sessions'


class MARKET_RECOMMEND_CLICK_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-recommend-click to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_recommend_click2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/recommend/click/market_recommend_click2scarab'


class MARKET_RECOMMEND_PREVIEW_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-recommend-preview to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_recommend_preview2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/recommend/preview/market_recommend_preview2scarab'


class MARKET_RECOMMEND_CLICK_ACTIVITY_EXECUTABLE(AbstractResource):
    """
        Converter for recommend-click events to activity-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_recommend_click_activity'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/recommend_click_activities/market_recommend_click_activity'


class MARKET_API_ACCESS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-api-access to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_api_access2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/api_access/market_api_access2scarab'


class MARKET_BLUE_TABLE_EXECUTABLE(AbstractResource):
    """
        Extrator of blue market from the whole market logs
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_blue_table'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/blue_table/market_blue_table'


class MARKET_GOALS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-goals-log to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/market_goals2scarab/market_goals2scarab'


class MARKET_APP_METRICA_EXECUTABLE(AbstractResource):
    """
        Converter of api-metrica-log to scarab format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/converters/market_app_metrica2scarab/market_app_metrica2scarab'


class MARKET_CLICKS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-clicks-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_clicks2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/clicks/market_clicks2scarab'


class MARKET_CLICKS_VENDOR_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-vendor-clicks-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_vendor_clicks2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/clicks_vendor/market_vendor_clicks2scarab'


class MARKET_CPA_CLICKS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-cpa-clicks-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_cpa_clicks2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/cpa_clicks/market_cpa_clicks2scarab'


class MARKET_FEATURE_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-feature-log from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_feature2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/features_set/market_feature2scarab'


class MARKET_CLICKS_ORDERS_PLACED_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-clicks-orders-placed from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_clicks_orders_placed2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/clicks_orders/placed/market_clicks_orders_placed2scarab'


class MARKET_CLICKS_ORDERS_BILLED_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-clicks-orders-billed from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_clicks_orders_billed2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/clicks_orders/billed/market_clicks_orders_billed2scarab'


class MARKET_ORDERS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-orders from raw format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_orders2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/orders/placed/market_orders2scarab'


class MARKET_DELIVERED_ORDERS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-delivered-orders from raw format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_delivered_orders2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/orders/delivered/market_delivered_orders2scarab'


class MARKET_ACCESS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-access from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_access2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/access/market_access2scarab'


class MARKET_REPORT_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-report from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_main_report2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/report/market_main_report2scarab'


class MARKET_SHOWS_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-shows from old format to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_shows2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/shows/market_shows2scarab'


class MARKET_ALICE_TO_SCARAB_EXECUTABLE(AbstractResource):
    """
        Converter for market-alice-log to scarab-format
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'market_alice2scarab'
    arcadia_build_path = 'quality/logs/scarab/converters/market2scarab/alice/market_alice2scarab'


class ERROR_STATS_EXECUTABLE(AbstractResource):
    """
        Executable file. Calculates user sessions errors statistics
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/error_stats/error_stats'

class REQUEST_PROFILE_SPLITTER_EXECUTABLE(AbstractResource):
    """
        Executable file. Splits report-request-profile-event-log
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/logs/scarab/splitters/split_request_profile/split_request_profile'


class MARKET_FRONT_METRICS_LOGS(AbstractResource):
    """
        To build sessions for front and report metrics in aquarium
    """
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


class USER_SESSIONS_ERRORS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл тестирования пользовательских сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    ttl = 40
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/user_sessions_errors/user_sessions_errors'


class LOGS_YT_FETCHER_TS_EXECUTABLE(AbstractResource):
    """
        Исполняемый файл фетчера логов для YT
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_name = 'yt_fetching_by_timestamp'
    arcadia_build_path = 'quality/logs/tools/yt_fetching_by_timestamp/yt_fetcher'


class CUT_KEY_ALL_EXECUTABLE(AbstractResource):
    """
       Вспомогательная утилитка для расчета диффов сессий
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/cut_key_all/cut_key_all'


class SPY_LOG_SESIONS_URL_EXTRACTION_EXECUTABLE(AbstractResource):
    """
        Executable file. Extract url info from spy log sessions.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/spy_log_sessions_url_extraction/spy_log_sessions_url_extraction'


class SPY_LOG_SESIONS_URL_FILTER_EXECUTABLE(AbstractResource):
    """
        Executable file. Filter spy_log like sessions based on url frequency info.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/spy_log_sessions_url_filter/spy_log_sessions_url_filter'


class SPY_LOG_MOBILE_FILTER_FOR_SPY_V2_EXECUTABLE(AbstractResource):
    """
        Executable file. Filter mobile rows in spy_log like sessions.
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/spy_log_mobile_filter_for_spy_v2/spy_log_mobile_filter_for_spy_v2'


class SPLIT_RT_SESSIONS_EXECUTABLE(AbstractResource):
    """
        Executable file. Split rt-based sessions logs by tables (sessions, yandex_servers, etc)
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/split_rt_sessions/split_rt_sessions'


class SESSIONS_GEOHELPER(AbstractResource):
    """
       Файл geohelper для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers
    #  TODO arcadia_build_path = 'tools/geo/geohelpers_create'


class SESSIONS_USER_TYPE_RESOLVER(AbstractResource):
    """
       Файл user_type_resolver для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers
    #  TODO arcadia_build_path = 'kernel/geo'


class SESSIONS_BETA_LIST(AbstractResource):
    """
       Файл beta_list.txt для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class SESSIONS_BLOCKSTAT(AbstractResource):
    """
       Файл blockstat.dict для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class SESSIONS_BLOCKSTAT_JSON(AbstractResource):
    """
       blockstat.dict.json
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class SESSIONS_DIRECT_PAGEIDS(AbstractResource):
    """
       Файл direct_pageids для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class SESSIONS_DIRECT_RESOURCENO_DICT(AbstractResource):
    """
       Файл direct_recourceno_dict для построения ессий
    """
    auto_backup = True
    releasable = True
    releasers = user_sessions_releasers


class SESSIONS_TTL_PROPS_REMOVER_EXECUTABLE(AbstractResource):
    """
        Executable file. remove expired data from user_sessions
    """
    releasable = True
    any_arch = False
    executable = True
    auto_backup = True
    releasers = user_sessions_releasers
    arcadia_build_path = 'quality/user_sessions/tools/ttl_props_remover/ttl_props_remover'


class UsBinariesReleaseInfo(AbstractResource):
    """
        File with serialized json with artifacts info for releasing
    """
    releasers = user_sessions_releasers
    releasable = True
    any_arch = True
    executable = False
    auto_backup = True


USER_SESSIONS_RESOURCES_LIST = [
    BAOBAB_VALIDATOR_EXECUTABLE,
    CHECK_SESSIONS_EXISTENCE_EXECUTABLE,
    COMMON_LOGS_JOINER_EXECUTABLE,
    CREATE_NANO_SESSIONS_EXECUTABLE,
    CREATE_SCARAB_SESSIONS_EXECUTABLE,
    CREATE_SESSIONS_EXECUTABLE,
    CREATE_SESSIONS_TESTS_EXECUTABLE,
    CUT_KEY_ALL_EXECUTABLE,
    ENTITY_RECOMMENDER_ACCESS2SCARAB_EXECUTABLE,
    ERROR_STATS_EXECUTABLE,
    REQUEST_PROFILE_SPLITTER_EXECUTABLE,
    EXTRACT_TAKEOUT_EXECUTABLE,
    FILTER_BS_DSP_LOG_EXECUTABLE,
    FILTER_BS_RTB_LOG_EXECUTABLE,
    HASHED_SESSIONS_DIFF_EXECUTABLE,
    HTTP_ADAPTER_ACCESS2SCARAB_EXECUTABLE,
    IMG_REQANS_FILTER_MERGER,
    IMGREQANS_TO_SCARAB_EXECUTABLE,
    JOINED_BS_DSP_AND_BS_RTB_TO_SCARAB_EXECUTABLE,
    LOGSNG2SCARAB_EXECUTABLE,
    LOGS_YT_FETCHER_TS_EXECUTABLE,
    MARKET_ACCESS_TO_SCARAB_EXECUTABLE,
    MARKET_ALICE_TO_SCARAB_EXECUTABLE,
    MARKET_API_ACCESS_TO_SCARAB_EXECUTABLE,
    MARKET_APP_METRICA_EXECUTABLE,
    MARKET_BLUE_TABLE_EXECUTABLE,
    MARKET_CLICKS_ORDERS_BILLED_TO_SCARAB_EXECUTABLE,
    MARKET_CLICKS_ORDERS_PLACED_TO_SCARAB_EXECUTABLE,
    MARKET_CLICKS_TO_SCARAB_EXECUTABLE,
    MARKET_CLICKS_VENDOR_TO_SCARAB_EXECUTABLE,
    MARKET_CPA_CLICKS_TO_SCARAB_EXECUTABLE,
    MARKET_FEATURE_TO_SCARAB_EXECUTABLE,
    MARKET_FRONT_METRICS_LOGS,
    MARKET_GOALS_TO_SCARAB_EXECUTABLE,
    MARKET_RECOMMEND_CLICK_ACTIVITY_EXECUTABLE,
    MARKET_RECOMMEND_CLICK_TO_SCARAB_EXECUTABLE,
    MARKET_RECOMMEND_PREVIEW_TO_SCARAB_EXECUTABLE,
    MARKET_REPORT_TO_SCARAB_EXECUTABLE,
    MARKET_SHOWS_TO_SCARAB_EXECUTABLE,
    MARKET_ORDERS_TO_SCARAB_EXECUTABLE,
    MARKET_DELIVERED_ORDERS_TO_SCARAB_EXECUTABLE,
    RALIB_ETALON_BINARY,
    RALIB_RULES_EXECUTABLE,
    REPORT_LOGS_TESTS_EXECUTABLE,
    REQANS_TO_SCARAB_EXECUTABLE,
    SESSIONS_BETA_LIST,
    SESSIONS_BLOCKSTAT,
    SESSIONS_BLOCKSTAT_JSON,
    SESSIONS_DIFF_EXECUTABLE,
    SESSIONS_DIRECT_ADS_DESCRIPTIONS,
    SESSIONS_DIRECT_PAGEIDS,
    SESSIONS_DIRECT_RESOURCENO_DICT,
    SESSIONS_GEOHELPER,
    SESSIONS_RTB_PAGEIDS,
    SESSIONS_USER_TYPE_RESOLVER,
    SESSIONS_YLOGIN_ENC_KEY_TXT,
    SPLIT_IMGREQANS_EXECUTABLE,
    SPLIT_MARKET_ACCESS_EXECUTABLE,
    SPLIT_MARKET_CLICKS_EXECUTABLE,
    SPLIT_MARKET_CPA_CLICKS_EXECUTABLE,
    SPLIT_MARKET_REPORT_EXECUTABLE,
    SPLIT_MARKET_SHOWS_EXECUTABLE,
    SPLIT_REQANS_EXECUTABLE,
    SPY_LOG_ACTIVITY_JOIN_EXECUTABLE,
    SPY_LOG_SESSION_ACTIVITY_EXTRACTION_EXECUTABLE,
    SURPLUS_METRICS_EXECUTABLE,
    TYPE_PARSE_LIB_ERROR_EXECUTABLE,
    UNIQUE_WATCH_LOG_EXECUTABLE,
    USER_SESSIONS_ERRORS_EXECUTABLE,
    USER_SESSIONS_SAMPLE_BY_UID_EXECUTABLE,
    WEATHER_ACCESS_TO_SCARAB_EXECUTABLE,
    MERGE_SESSIONS_EXECUTABLE,
    SPY_LOG_SESIONS_URL_EXTRACTION_EXECUTABLE,
    SPY_LOG_SESIONS_URL_FILTER_EXECUTABLE,
    SPY_LOG_MOBILE_FILTER_FOR_SPY_V2_EXECUTABLE,
    SPLIT_RT_SESSIONS_EXECUTABLE,
]


#  from sandbox.projects.common.build.ArcadiaTask
def get_binary_name(resource_type):
    arcadia_build_name = getattr(
        resource_type, 'arcadia_build_name', os.path.basename(resource_type.arcadia_build_path)
    )
    return arcadia_build_name


USER_SESSIONS_BINARIES = {}


for res in USER_SESSIONS_RESOURCES_LIST:
    if not res.executable:
        continue

    name = get_binary_name(res)
    assert name
    assert name not in USER_SESSIONS_BINARIES, "Duplicated binary name {} in USER_SESSIONS_BINARIES".format(name)

    USER_SESSIONS_BINARIES[name] = res
