# -*- coding: utf-8 -*-

import re
import os
import json
import logging
import urllib2
import requests

from sandbox import sdk2

from sandbox import sandboxsdk
from sandbox.sandboxsdk import ssh
from sandbox.sandboxsdk import svn
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process


from sandbox import projects
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.common.constants as consts

ALERT_JSON_TEMPLATE = {
    "id": "user_sessions_DAILY_razladki_CREATE_SCARAB_LIB",
    "projectId": "user_sessions",
    "name": "razladki DAILY CREATE_SCARAB_LIB",
    "createdBy": "bagiro44",
    "updatedBy": "bagiro44",
    "groupByLabels": [
        "diagnosis",
        "platform",
        "version",
        "event_type"
    ],
    "notificationChannels": [
        "CREATE_SCARAB_LIB_chanel"
    ],
    "type": {
        "expression": {
            "program": "",
            "checkExpression": "status"
            }
    },
    "periodMillis": 1382400000,
    "delaySeconds": 0
}

NOTIFICATION_CHANEL_JSON_TEMPLATE = {
    "id": "{}_chanel",
    "projectId": "user_sessions",
    "name": "{}_chanel",
    "notifyAboutStatuses": [
        "ALARM"
    ],
    "createdBy": "bagiro44",
    "updatedBy": "bagiro44",
    "method": {
        "email": {
            "subjectTemplate": "New solomon",
            "contentTemplate": "",
            "recipients": []
        }
    }
}

SOLOMON_PROGRAM_TEMPLATE = (
    "// Exported from https://razladki-wow.n.yandex-team.ru/workspace/335/version/10\n"
    "let _c__input = load1('project=user_sessions&cluster=hahn&service=razladki&provider={}&diagnosis=*&platform={}&time-period=1d&version=*&event_type=*');"
    "\nlet _c_input = tail(_c__input, 172800s);\nlet _cond = count(filter_by_time(tail(_c_input, 1), '[1h - 2d]')) > 0;\n"
    "let _t__i_input = load1('project=user_sessions&cluster=hahn&service=razladki&provider={}&diagnosis=*&platform={}&time-period=1d&version=*&event_type=*');"
    "\nlet _t__input_vec = tail(_t__i_input, 259200s);\n"
    "let _t__s__input = load1('project=user_sessions&cluster=hahn&service=razladki&provider={}&diagnosis=*&platform={}&time-period=1d&version=*&event_type=*');\n"
    "let _t__s_train = drop_tail(_t__s__input, 259200s);\n"
    "let _t__adj_vec = seasonal_adjusted(_t__s_train, _t__input_vec, 1, 'anyday', 0h, 0.1);\nlet _t__lower_bad = transform(-3.0 - _t__adj_vec, 'heaviside');\n"
    "let _t__upper_bad = transform(_t__adj_vec - 3.0, 'heaviside');\nlet _t_input = _t__lower_bad + _t__upper_bad;\n"
    "let _tval = sum(_t_input) > 0.5 * count(_t_input);\nlet _fval = false;\nlet status = _cond ? _tval : _fval;"
)

SOLOMON_URL = 'http://solomon.yandex.net/api/v2/projects/user_sessions/'

SOLOMON_TOKEN_OWNER = 'USERSESSIONSTOOLS'
SOLOMON_TOKEN_NAME = 'SCARAB_SOLOMON_TOKEN'


class AddNewProviderToScarab(sdk2.Task):
    class Parameters(sdk2.Parameters):
        providerName = sdk2.parameters.String(
            'provider_name',
            description='Имя нового провайдера. Примеры: MARKET, MOBILE_SEARCH_APP',
            multiline=False,
            required=True
        )

        is_need_ios = sdk2.parameters.Bool(
            u"Я буду использовать скарабей в iOS",
            default=False,
        )

        is_need_android = sdk2.parameters.Bool(
            u"Я буду использовать скарабей в Android",
            default=False,
        )

        with is_need_ios.value[True] and is_need_android.value[True]:
            is_need_separates_email = sdk2.parameters.Bool(
                u"Использовать разные имена рассылок для ios и андроид",
                default=False,
            )

            with is_need_separates_email.value[True]:
                ios_mail = sdk2.parameters.String(
                    'ios_provider_mail',
                    description=(
                        u'Имя рассылки для ошибок ios (без @yandex-team.ru, разделять запятыми). Ex: bagiro44'
                    ),
                    multiline=False,
                    required=True
                )
                android_mail = sdk2.parameters.String(
                    'android_provider_mail',
                    description=(
                        u'Имя рассылки для ошибок android (без @yandex-team.ru, разделять запятыми). Ex: bagiro44'
                    ),
                    multiline=False,
                    required=True
                )

        mail = sdk2.parameters.String(
            'provider_mail',
            description=u'Имя рассылки для ошибок логгирования (Для других ошибок, если используете специальные рассылки для iOS и android)',
            multiline=False,
            required=True
        )

        arcadiaUrl = sdk2.parameters.ArcadiaUrl()

    class Requirements(sdk2.Task.Requirements):
        environments = (
            environments.PipEnvironment('pyscarab'),
            environments.PipEnvironment('yql'),
        )

    def on_execute(self):
        logging.info('AddNewProvider: Start task')
        arcadia_url = self.Parameters.arcadiaUrl
        provider = self.Parameters.providerName.upper()
        output_template_xsd_list = str(self.path('arcadia/scarab/xsd', provider.lower() + '.xsd'))
        ya_make_cpp_file = str(self.path('arcadia/scarab/api/cpp_gen/ya.make'))
        cpp_separator_file = str(self.path('arcadia/scarab/template/cpp/user_sessions.mtl'))
        ios_path = str(self.path('arcadia/scarab/api/swift'))
        android_path = str(self.path('arcadia/scarab/api/java-mobile-minimal'))
        src_dir = 'scarab'
        sandbox_task_config = 'sandbox/projects/logs/scarab/config'
        logging.info('AddNewProvider: clone and build alerts info')
        arcadia_dir = self.clone(arcadia_url, [src_dir, sandbox_task_config])
        self.build(arcadia_dir, [src_dir, sandbox_task_config])

        android_paths = None
        new_mobile_app_choises_element = '"{}",'.format(provider.lower())
        deploy_task_choises_dir = str(self.path('arcadia', sandbox_task_config))
        if self.Parameters.is_need_android:
            android_choises_list = deploy_task_choises_dir + '/deploy_android.py'
            self.add_new_provider_for_regex(new_mobile_app_choises_element, android_choises_list)
            android_paths = self.add_new_android_provider(provider, android_path)

        ios_paths = None
        if self.Parameters.is_need_ios:
            ios_choises_list = deploy_task_choises_dir + '/deploy_ios.py'
            self.add_new_provider_for_regex(new_mobile_app_choises_element, ios_choises_list)
            ios_paths = self.add_new_ios_provider(provider, ios_path)

        mail = ''
        if self.Parameters.mail:
            mail = self.Parameters.mail + ';'
        if self.Parameters.ios_mail:
            mail = '{}ios:[{}];'.format(mail, self.Parameters.ios_mail)
        if self.Parameters.android_mail:
            mail = '{}android:[{}];'.format(mail, self.Parameters.android_mail)
        logging.info('AddNewProvider: Add to common.xsd')
        self.add_new_provider_to_file(provider, str(self.path('arcadia/scarab/xsd/common.xsd')), mail)
        self.add_new_alert(provider, mail)
        self.add_xsd_template(provider, output_template_xsd_list)
        is_mobile = self.Parameters.is_need_ios or self.Parameters.is_need_android
        self.add_new_provider_to_xsd_list(provider, str(self.path('arcadia/scarab/api/ya.make.inc')), is_mobile)
        self.add_new_provider_to_cpp_yamake(provider, ya_make_cpp_file)

        commit_paths = [
            str(self.path('arcadia/scarab/xsd/common.xsd')),
            str(self.path('arcadia/scarab/api/ya.make.inc')),
            output_template_xsd_list,
            ya_make_cpp_file,
            cpp_separator_file,
            deploy_task_choises_dir
        ]
        if android_paths:
            commit_paths = commit_paths + android_paths
        if ios_paths:
            commit_paths = commit_paths + ios_paths

        if self.Parameters.is_need_ios or self.Parameters.is_need_android:
            self.add_new_provider_to_user_session_uid_getter(provider, cpp_separator_file)
            commit_paths.append(cpp_separator_file)
        with ssh.Key(self, "zomb-sean", "Scarab_zomb_key"):
            message = 'Add new provider - ' + provider + '. Owner - ' + self.Parameters.owner + ' REVIEW: new'
            try:
                svn.Arcadia.commit(
                    commit_paths,
                    message,
                    user='zomb-sean',
                    with_revprop=["arcanum:review-publish=yes"]
                )
            except svn.SvnError as err:
                if 'ew review request' in str(err):
                    self.set_info('\n' + str(err), do_escape=False)
                else:
                    raise Exception(str(err))
            logging.info('AddNewProvider: Finish task')

    def clone(self, arcadia_url, _):
        return sdk.do_clone(arcadia_url, self)

    def build(self, arcadia_dir, api):
        sdk.do_build(
            build_system=consts.YMAKE_BUILD_SYSTEM,
            source_root=arcadia_dir,
            targets=api,
            build_type=consts.RELEASE_BUILD_TYPE,
            results_dir=str(self.path('python_conv')),
            clear_build=False,
            use_dev_version=False,
            sanitize=False,
            checkout=True,
        )

    @staticmethod
    def add_new_provider_for_regex(text, path):
        s = open(path).read()
        line = re.sub(
            r"#PLACE_FOR_NEW_PROVIDER",
            text + '\n    #PLACE_FOR_NEW_PROVIDER',
            s
        )
        f = open(path, 'w')
        f.write(line)
        f.close()

    @staticmethod
    def add_new_provider_for_template(provider, template_name, output_template_xsd_list):
        task_source_directory = os.path.dirname(projects.logs.scarab.AddNewScarabProvider.__file__)
        s = open(task_source_directory+'/' + template_name).read()
        s = s.replace('%%PROVIDER_PLACE%%', provider.upper())
        f = open(output_template_xsd_list, 'w')
        f.write(s)
        f.close()

    def add_new_android_provider(self, provider, android_path):
        new_provider_dir = android_path + '/' + provider.lower()
        if not os.path.exists(new_provider_dir):
            os.makedirs(new_provider_dir)
        android_new_provider_ya_make_path = new_provider_dir + '/ya.make'
        self.add_new_provider_for_template(
            provider + '_XSD_LIST',
            'android_template_ya_make',
            android_new_provider_ya_make_path
        )
        android_ya_make_path = android_path + '/ya.make'
        self.add_new_provider_for_regex(provider.lower(), android_ya_make_path)
        svn.Arcadia.add(new_provider_dir)
        return [android_ya_make_path, new_provider_dir]

    def create_new_brunch_in_ios_repo(self, provider):
        with ssh.Key(self, 'bagiro44', "Bitbucket"):
            gitlog_path = os.path.join(sandboxsdk.paths.get_logs_folder(), 'git.log')
            with open(gitlog_path, 'a') as git_log:
                logging.info('===Clone scarabey-api-swift===')
                run_process(
                    ['git', 'clone', 'git@bitbucket.browser.yandex-team.ru:ml/scarabey-api-swift.git'],
                    shell=True,
                    timeout=10000,
                    work_dir=str(self.path()),
                    stdout=git_log,
                    outputs_to_one_file=True
                )

                run_process(
                    ['git', 'checkout', '-b', provider],
                    shell=True,
                    timeout=10000,
                    work_dir=str(self.path('scarabey-api-swift')),
                    stdout=git_log,
                    outputs_to_one_file=True
                )

                run_process(
                    ['git', 'push', 'origin', provider],
                    shell=True,
                    timeout=10000,
                    work_dir=str(self.path('scarabey-api-swift')),
                    stdout=git_log,
                    outputs_to_one_file=True
                )

    def add_new_ios_provider(self, provider, ios_path):
        self.create_new_brunch_in_ios_repo(provider.lower())
        new_provider_dir = ios_path + '/swift-' + provider.lower()
        if not os.path.exists(new_provider_dir):
            os.makedirs(new_provider_dir)
        ios_new_provider_ya_make_path = new_provider_dir + '/ya.make'
        self.add_new_provider_for_template(
            provider + '_XSD_LIST',
            'ios_template_ya_make',
            ios_new_provider_ya_make_path
        )
        ios_ya_make_path = ios_path + '/ya.make'
        self.add_new_provider_for_regex('swift-' + provider.lower(), ios_ya_make_path)
        svn.Arcadia.add(new_provider_dir)
        return [ios_ya_make_path, new_provider_dir]

    def untar(self, tarball=None):
        if tarball is None:
            tarball = str(self.path('scarab', 'api', self.api, 'generated.tar'))
        generated = sandboxsdk.paths.make_folder(str(self.path('generated-sources')))
        run_process(
            ['tar', 'xf', tarball, '-C', generated],
            log_prefix='tar',
            shell=True,
            check=True,
            timeout=10000
        )

    @staticmethod
    def check_provider_exist(provider, filename):
        s = open(filename, 'r+').read()
        mo = re.search('enumeration value="'+provider+'"', s, re.MULTILINE | re.DOTALL)
        if mo:
            return True
        return False

    def add_new_provider_to_file(self, provider, filename, mail=None):
        if not self.check_provider_exist(provider, filename):
            s = open(filename).read()
            new_provider_str = (
                '<xs:enumeration value="{}" sc:providerMail="{}"/>\n'.format(
                    provider.upper(), mail
                ),
                '      <!-- Point for new provider -->'
            )
            s = s.replace('<!-- Point for new provider -->', new_provider_str)
            f = open(filename, 'w')
            f.write(s)
            f.close()
        else:
            raise Exception("Provider " + provider + " is used before")

    @staticmethod
    def send_alert_to_solomon(data, isAlert=True):
        api = "alerts" if isAlert else "notificationChannels"
        url = SOLOMON_URL + api
        logging.info("Sending to solomon")
        token = sdk2.Vault.data(SOLOMON_TOKEN_OWNER, SOLOMON_TOKEN_NAME)
        headers = {
            'Content-type': 'application/json',
            'Accept': 'application/json',
            'Authorization': 'OAuth ' + token
        }
        logging.info("Request: " + data)
        response = requests.post(url, data=data, headers=headers)
        logging.info("Response: " + response.content)
        response.raise_for_status()
        logging.info("Sent all to solomon")

    def add_alert(json_):
        logging.debug(json_)
        url = 'http://razladki.yandex-team.ru/admin/api/set_subscription'
        req = urllib2.Request(url, json_)
        # noinspection PyBroadException
        try:
            response = urllib2.urlopen(req, timeout=60)
            print response.read()
        except Exception:
            logging.exception('Error')

    @staticmethod
    def get_members(members):
        if '[' in members:
            members = members.replace("[", "")
            members = members.replace("]", "")
        if ',' in members:
            return members.split(',')
        return [members]

    def create_and_send_alarm_json(self, provider, members, platform=None):
        NOTIFICATION_CHANEL_JSON_TEMPLATE["method"]["email"]["recipients"] = members
        alert_id = "razladki_user_sessions_DAILY_{}{}"
        alert_name = "Razladki DAILY {} {}"
        if platform:
            NOTIFICATION_CHANEL_JSON_TEMPLATE["id"] = "razladki_{}_{}_chanel".format(provider, platform)
            NOTIFICATION_CHANEL_JSON_TEMPLATE["name"] = "Razladki {} {} chanel".format(provider, platform)
            alert_id = alert_id.format(provider, "_"+platform)
            alert_name = alert_name.format(provider, platform)
            ALERT_JSON_TEMPLATE["type"]["expression"]["program"] = SOLOMON_PROGRAM_TEMPLATE.format(
                provider, platform, provider, platform, provider, platform)
        else:
            NOTIFICATION_CHANEL_JSON_TEMPLATE["id"] = "razladki_{}_chanel".format(provider)
            NOTIFICATION_CHANEL_JSON_TEMPLATE["name"] = "Razladki {} chanel".format(provider)
            alert_id = alert_id.format(provider, "")
            alert_name = alert_name.format(provider, "")
            ALERT_JSON_TEMPLATE["type"]["expression"]["program"] = SOLOMON_PROGRAM_TEMPLATE.format(
                provider, "*", provider, "*", provider, "*")
        ALERT_JSON_TEMPLATE["id"] = alert_id
        ALERT_JSON_TEMPLATE["name"] = alert_name
        ALERT_JSON_TEMPLATE["notificationChannels"] = [NOTIFICATION_CHANEL_JSON_TEMPLATE["id"]]
        alert_link_template = "https://solomon.yandex-team.ru/admin/projects/user_sessions/alerts/{}/subAlerts?filterByEvalStatus=ALARM"
        NOTIFICATION_CHANEL_JSON_TEMPLATE["method"]["email"]["contentTemplate"] = alert_link_template.format(alert_id)
        self.send_alert_to_solomon(json.dumps(NOTIFICATION_CHANEL_JSON_TEMPLATE), False)
        self.send_alert_to_solomon(json.dumps(ALERT_JSON_TEMPLATE))

    def add_new_provider_to_xsd_list(self, provider, filename, is_mobile):
        if is_mobile:
            mobile_xsd_list = "\n".join((
                'SET (' + provider.upper() + '_XSD_LIST',
                '    ${XSD_DIR}/common.xsd',
                '    ${XSD_DIR}/' + provider.lower() + '.xsd',
                '    ${XSD_DIR}/scarab_attributes.xsd',
                '    )'
            ))
            self.add_new_provider_for_regex(mobile_xsd_list, filename)
        s = open(filename).read()
        line = re.sub(
            r"\bXSD_LIST\b",
            'XSD_LIST\n    ${XSD_DIR}/' + provider.lower() + '.xsd',
            s
        )
        f = open(filename, 'w')
        f.write(line)
        f.close()

    @staticmethod
    def add_new_provider_to_cpp_yamake(provider, filename):
        s = open(filename).read()
        enum_line = re.sub(
            r"#PLACE_FOR_NEW_PROVIDER_ENUM",
            "GENERATE_ENUM_SERIALIZATION(" + provider.lower() + "/basic_type.h)" + '\n#PLACE_FOR_NEW_PROVIDER_ENUM',
            s
        )

        deploy_line = re.sub(
            r"#PLACE_FOR_NEW_PROVIDER_DEPLOY",
            '    deploy/' + provider.lower() + '/ya.make\n#PLACE_FOR_NEW_PROVIDER_DEPLOY',
            enum_line
        )

        h_line = (
            provider.lower() + '/basic_type.h\n'
            '    ' + provider.lower() + '/basic_type.cpp\n'
            '    ' + provider.lower() + '/basic_type_builder.h\n'
            '    ' + provider.lower() + '/basic_type_builder.cpp\n'
            '    ' + provider.lower() + '/event.h\n'
            '    ' + provider.lower() + '/event_impl.h\n'
            '    ' + provider.lower() + '/event_impl.cpp\n'
            '    ' + provider.lower() + '/event_builder.h\n'
            '    ' + provider.lower() + '/event_builder.cpp\n'
            '    ' + provider.lower() + '/serialization.h\n'
            '    ' + provider.lower() + '/serialization.cpp\n'
            '    ' + provider.lower() + '/deserialization.h\n'
            '    ' + provider.lower() + '/deserialization.cpp\n'
        )

        line = re.sub(
            r"#PLACE_FOR_NEW_PROVIDER_CLASSES",
            h_line + "\n    #PLACE_FOR_NEW_PROVIDER_CLASSES",
            deploy_line
        )

        f = open(filename, 'w')
        f.write(line)
        f.close()

    def add_xsd_template(self, provider, output_template_xsd_list):
        self.add_new_provider_for_template(provider, 'template.xsd', output_template_xsd_list)

    @staticmethod
    def add_new_provider_to_user_session_uid_getter(provider, filename):
        s = open(filename).read()

        h_line = (' or (module(event) = \'' + provider.lower() + '\')')

        # noinspection PyPep8
        line = re.sub(
            r"mobileEvents:OrderedSet\(EClassifier\) = loadEvents\(\)->select\(event \| \(\(module\(event\) = 'mobile'\)",
            'mobileEvents:OrderedSet(EClassifier) = loadEvents()->select(event | ((module(event) = \'mobile\')' + h_line,
            s
        )

        f = open(filename, 'w')
        f.write(line)
        f.close()

    def add_new_alert(self, provider, mail_part):
        platform = None
        logging.info('AddNewProvider: MAIL - ' + mail_part)
        line = mail_part.split(';')
        for lElement in line:
            if lElement != '':
                if ':' in lElement:
                    platform_and_members = lElement.split(':')
                    platform = platform_and_members[0]
                    members = self.get_members(platform_and_members[1])
                else:
                    members = self.get_members(lElement)
                members.append('scarab-alerts@yandex-team.ru')
                self.create_and_send_alarm_json(provider, members, platform)
