# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.common.types import task as ctt
from sandbox.projects.common.build import YaPackage
import sandbox.projects.release_machine.rm_notify as rm_notify
import sandbox.projects.logs.scarab.common as sc


@rm_notify.notify2()
class DeployScarabPythonApi(sc.DeployScarabBaseV2):
    api = 'python3'

    class Parameters(sc.DeployScarabBaseV2.Parameters):
        publish_packages = sdk2.parameters.Bool('Publish packages to PyPi and Ubuntu repositories', default_value=False)

    class Context(sc.DeployScarabBaseV2.Context):
        ya_package_task_id = None

    def CreateYaPackage(self):
        assert self.Context.published_revision, "No published revision"

        package_file = 'packages/debian/mapreduce/yandex-python-scarab/yandex-python-scarab.json'
        description = 'yandex-python-scarab version {} revision {}'.format(self.Context.source_revision,
                                                                           self.Context.published_revision)

        arcadia_url = self.destination_arcadia_url(revision=self.Context.published_revision)

        YaPackageClass = sdk2.Task['YA_PACKAGE']
        subtask = YaPackageClass(
            self,
            description=description,
            checkout_arcadia_from_url=arcadia_url,
            packages=package_file,
            use_new_format=True,
            host_platform='linux',
            package_type=YaPackage.DEBIAN,
            publish_package=True,
            publish_to='search-precise',
            key_user='zomb-prj-216',
        ).enqueue()

        self.Context.ya_package_task_id = subtask.id

        raise sdk2.WaitTask([subtask.id], ctt.Status.Group.FINISH | ctt.Status.Group.BREAK, wait_all=True)

    def on_execute(self):
        with self.memoize_stage.generate_api:
            self.PrepareArcadia()

            env = dict(SCARAB_MINOR_VERSION=str(self.get_minor_version()),
                       SCARAB_BUILD_VERSION=self.Context.source_revision)

            if self.Parameters.publish_packages:
                env['SCARAB_DEPLOY_TARGET'] = 'pypi'

            self.GenerateAPI(env=env)
            self.CheckChangedFiles(filter_exclude=lambda f: f.endswith('/scarab/version.py'))

        with self.memoize_stage.do_deploy:
            self.CommitAPI()

            if self.Parameters.publish_packages:
                if self.changed_files or self.Parameters.force:
                    self.CreateYaPackage()

        subtask_id = self.Context.ya_package_task_id
        if subtask_id:
            subtask = sdk2.Task[subtask_id]
            assert subtask, "No subtask {}".format(subtask_id)
            if subtask.status != ctt.Status.SUCCESS:
                raise TaskFailure("YaPackage deploy failed")
