import os
import sys
from pbxproj import XcodeProject


def getFiles(path):
    fileslist = []
    for dirname, dirnames, filenames in os.walk(path):
        for subdirname in dirnames:
            print(os.path.join(dirname, subdirname))
        for filename in filenames:
            if filename.endswith(".swift"):
                fileslist.append(os.path.join(dirname, filename))
                print(os.path.join(dirname, filename))
        if '.git' in dirnames:
            dirnames.remove('.git')
    return fileslist


project_dir = sys.argv[1] + '/ScarabApiSwift'
project = XcodeProject.load(sys.argv[1]+'/ScarabApiSwift.xcodeproj/project.pbxproj')
mainGroup = project.get_or_create_group('ScarabApiSwift')
commonGroup = project.get_or_create_group('Common', parent=mainGroup)
eventBuildierGroup = project.get_or_create_group('EventBuildier', parent=mainGroup)

swiftFiles = getFiles(project_dir + '/Common')
for file in swiftFiles:
    print("add - "+file)
    project.add_file(file, parent=commonGroup, target_name='ScarabApiSwift')

swiftFiles = getFiles(project_dir + '/EventBuildier')
for file in swiftFiles:
    print("add - "+file)
    project.add_file(file, parent=eventBuildierGroup, target_name='ScarabApiSwift')

project.add_file(os.path.join(project_dir, 'MetricaHelper.swift'), parent=mainGroup, target_name='ScarabApiSwift')

project.save()
