import os
import sys
from pbxproj import XcodeProject


def getFiles(path):
    fileslist = []
    for dirname, dirnames, filenames in os.walk(path):
        for subdirname in dirnames:
            print(os.path.join(dirname, subdirname))
        for filename in filenames:
            if filename.endswith(".swift"):
                fileslist.append(os.path.join(dirname, filename))
        if '.git' in dirnames:
            dirnames.remove('.git')
        if 'EventBuildierProtocol.swift' in fileslist:
            fileslist.remove('EventBuildierProtocol.swift')
    return fileslist


print('Project file for delete - ' + sys.argv[1] + '/ScarabApiSwift.xcodeproj/project.pbxproj')
project = XcodeProject.load(sys.argv[1] + '/ScarabApiSwift.xcodeproj/project.pbxproj')

swiftFiles = getFiles(sys.argv[1]+'/ScarabApiSwift/Common')
swiftFiles = swiftFiles + getFiles(sys.argv[1]+'/ScarabApiSwift/EventBuildier')
swiftFiles.append(sys.argv[1]+'/ScarabApiSwift/MetricaHelper.swift')

for file in swiftFiles:
    files_parts = file.replace(sys.argv[1]+"/", "")
    project.remove_files_by_path(files_parts)

project.save()
print("Save project")
