from sandbox.sandboxsdk.process import run_process
from sandbox.projects.logs.scarab.common import DeployScarabBase
from sandbox.projects.common.build import parameters
from sandbox.sandboxsdk.environments import SvnEnvironment
import sandbox.common.types.misc as ctm
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.common.constants as consts
from sandbox.projects import resource_types


class CppChildTask(DeployScarabBase):
    type = "SCARAB_CROSS_LANG_CPP_TASK"

    """ This task build and compile cpp autotest project and produce test json for python and cpp. """

    environment = (
        SvnEnvironment(),
    )

    dns = ctm.DnsType.DNS64

    def on_execute(self):
        arcadia_url = self.ctx.get(parameters.ArcadiaUrl.name)
        task_dir = str(self.path('cpp_cross_lang'))
        cross_lang_path = 'scarab/static/cross_lang_test'
        api = 'cpp'
        self.clone_and_buld(arcadia_url, cross_lang_path + '/' + api)
        work_dir = task_dir + '/' + cross_lang_path + '/' + api
        events_dir = str(self.path('arcadia')) + '/' + cross_lang_path
        input_events = events_dir + '/input_events.txt'
        output_events = events_dir + '/cpp_events.txt'
        run_process([str(work_dir)+'/cpp', '-i', input_events, '-o', output_events], work_dir=work_dir, shell=True, timeout=10000, log_prefix='run_converter', outputs_to_one_file=True)
        self.create_resource(
            description='C++ JSON events for C++ and Python',
            resource_path=output_events,
            resource_type=resource_types.PLAIN_TEXT,
            attributes={
                "task_id": self.id,
                "lang": "cpp"
            }
        )

    def clone_and_buld(self, arcadia_url, api):
        arcadia_dir = sdk.do_clone(arcadia_url, self)
        sdk.do_build(
            build_system=consts.YMAKE_BUILD_SYSTEM,
            source_root=arcadia_dir,
            targets=[api],
            build_type=consts.RELEASE_BUILD_TYPE,
            results_dir=str(self.path('cpp_cross_lang')),
            clear_build=False,
            use_dev_version=False,
            sanitize=False,
            checkout=True,
        )
