from sandbox.projects.logs.scarab.common import DeployScarabBase
from sandbox.projects.logs.common import copy_and_add
from sandbox.projects.common.build import parameters
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.projects.common.arcadia import sdk
from sandbox.sandboxsdk.process import run_process
from sandbox.projects.common.environments import SandboxMavenEnvironment
from sandbox.projects import resource_types
import sandbox.common.types.misc as ctm
import sandbox.projects.common.constants as consts

from sandbox.projects.common.environments import SandboxJavaJdkEnvironment
import logging
import os
import sandbox.sandboxsdk.paths as sdk_paths


class JavaChildTask(DeployScarabBase):
    type = "SCARAB_CROSS_LANG_JAVA_TASK"

    """ This task build and compile java autotest project and produce test json for python. """

    environment = (
        SvnEnvironment(),
        SandboxMavenEnvironment('3.3.9'),
        SandboxJavaJdkEnvironment('1.8.0'),
    )

    dns = ctm.DnsType.DNS64

    def on_execute(self):
        arcadia_url = self.ctx.get(parameters.ArcadiaUrl.name)
        logging.info('JavaChildTask: Start task')
        logging.info('JavaChildTask: Start clone and build autotest events')
        self.generate_cross_lang_test(api='java-mobile-minimal', url=arcadia_url, static_dir='scarab/static')
        copy_and_add(self.path() + '/generated-sources', self.path() + '/static/generated-sources')
        pom_path = self.path() + '/static/java'
        rm_command = 'rm ' + self.path() + '/static/generated-sources/java/ru/yandex/se/scarab/api/common/AutoTest/EventTestBuilder.java'
        run_process(rm_command, shell=True, check=True, timeout=10000, work_dir=pom_path)
        logging.info('JavaChildTask: Finish clone and build autotest events')
        mvnlog_path = os.path.join(sdk_paths.get_logs_folder(), 'mvn.log')
        mvnerr_path = os.path.join(sdk_paths.get_logs_folder(), 'mvn.err')
        mvn_cmd = ['mvn', 'clean', 'compile', 'package', 'jar:jar'] + [
            '-f', os.path.join(pom_path, 'pom-cross-lang.xml'),
            '-Dscarab.artifact.suffix=-cross-lang',
            '-Dscarab.version=1.0',
            '-Dmaven.project.artifactId=scarab-',
            '-Dmaven.project.groupId=ru.yandex.se.log',
            '-Dmaven.project.name=scarab-',
            '-Dmaven.project.version=1.1.0',
            '--settings', os.path.join(pom_path, 'settings.xml'),
            '-Pandroid'
        ]
        logging.info('JavaChildTask: Start maven build')
        with open(mvnlog_path, 'a') as mvn_log, open(mvnerr_path, 'a') as mvn_err:
            run_process(mvn_cmd, shell=True, check=True, timeout=10000, work_dir=pom_path, stdout=mvn_log, stderr=mvn_err)
        logging.info('JavaChildTask: Finish maven build')
        logging.info('JavaChildTask: start run test')
        jar_dir = pom_path + '/target'
        input_events = self.path() + '/static/cross_lang_test/input_events.txt'
        output_events = self.path() + '/java_events.txt'
        java_command_log_path = os.path.join(sdk_paths.get_logs_folder(), 'java.log')
        java_command_err_path = os.path.join(sdk_paths.get_logs_folder(), 'java.err')
        java_command = 'java -classpath scarab-cross-lang-1.0.jar ru.yandex.se.scarab.api.common.CrossLangEntryPoint ' + input_events + ' ' + output_events
        with open(java_command_log_path, 'a') as java_log, open(java_command_err_path, 'a') as java_err:
            run_process(java_command, shell=True, check=True, timeout=10000, work_dir=jar_dir, stdout=java_log, stderr=java_err)
        logging.info('JavaChildTask: finish run test')
        logging.info('JavaChildTask: prepare resource')
        self.create_resource(
            description='Java JSON events for C++ and Python',
            resource_path=output_events,
            resource_type=resource_types.PLAIN_TEXT,
            attributes={
                "task_id": self.id,
                "lang": "java"
            }
        )
        logging.info('JavaChildTask: finish task')

    def clone_and_build(self, arcadia_url, api, result_path):
        arcadia_dir = sdk.do_clone(arcadia_url, self)
        sdk.do_build(build_system=consts.YMAKE_BUILD_SYSTEM,
                     source_root=arcadia_dir,
                     targets=[api],
                     build_type=consts.RELEASE_BUILD_TYPE,
                     results_dir=result_path,
                     clear_build=False,
                     use_dev_version=False,
                     sanitize=False,
                     checkout=True)
