from sandbox.projects.logs.scarab.common import DeployScarabBase
from sandbox.projects.logs.common import copy_and_add
from sandbox.projects.common.build import parameters
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.sandboxsdk.process import run_process
from sandbox.projects import resource_types
import sandbox.common.types.misc as ctm

import logging
import os
import sandbox.sandboxsdk.paths as sdk_paths


class PerlChildTask(DeployScarabBase):
    type = "SCARAB_CROSS_LANG_PERL_TASK"

    """ This task build and compile perl autotest project and produce test json for python. """

    environment = (
        SvnEnvironment(),
    )

    client_tags = "CUSTOM_SCARAB"  # ios-test47-dom0

    dns = ctm.DnsType.DNS64

    def on_execute(self):
        arcadia_url = self.ctx.get(parameters.ArcadiaUrl.name)
        logging.info('PerlChildTask: Start task')
        logging.info('PerlChildTask: Start clone and build autotest events')
        self.generate_cross_lang_test(api='perl', url=arcadia_url, static_dir='scarab/static')
        copy_and_add(self.path() + '/generated-sources/perl/Scarab', self.path() + '/static/cross_lang_test/perl/Scarab')
        input_events = self.path() + '/static/cross_lang_test/input_events.txt'
        output_events = self.path() + '/static/cross_lang_test/perl/Scarab/perl_events.txt'
        script_path = self.path() + '/static/cross_lang_test/perl/Scarab'
        perl_command = ['perl', 'test.pl', input_events]
        mvnlog_path = os.path.join(sdk_paths.get_logs_folder(), 'mvn.log')
        mvnerr_path = os.path.join(sdk_paths.get_logs_folder(), 'mvn.err')
        with open(mvnlog_path, 'a') as mvn_log, open(mvnerr_path, 'a') as mvn_err:
            run_process(perl_command, shell=True, check=True, timeout=10000, work_dir=script_path, stdout=mvn_log, stderr=mvn_err)
        logging.info('PerlChildTask: prepare resource')
        self.create_resource(
            description='Perl JSON events for C++ and Python',
            resource_path=output_events,
            resource_type=resource_types.PLAIN_TEXT,
            attributes={
                "task_id": self.id,
                "lang": "perl"
            }
        )
        logging.info('Per;ChildTask: finish task')
