from sandbox.projects.logs.scarab.common import DeployScarabBase
from sandbox.projects.logs.common import copy_and_add

from sandbox.projects.common.build import parameters
from sandbox.sandboxsdk.process import run_process
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.environments import SvnEnvironment
from sandbox.projects import resource_types

import logging
import sys


class SwiftChildTask(DeployScarabBase):
    type = "SCARAB_CROSS_LANG_SWIFT_TASK"

    """ This task build and compile swift autotest project and produce test json for python. """

    environment = (
        environments.PipEnvironment('pbxproj', version="2.7.0"),
        SvnEnvironment(),
    )

    client_tags = "CUSTOM_SCARAB"  # ios-test47-dom0

    def on_execute(self):
        logging.info('SwiftChildTask: Start task')
        run_process(['svn', '--version'], shell=True, timeout=10000, work_dir=self.path(), log_prefix='svn_version', outputs_to_one_file=True)
        logging.info('SwiftChildTask: Start clone and build autotest events')
        self.generate_cross_lang_test(api='swift', url=self.ctx.get(parameters.ArcadiaUrl.name), static_dir='scarab/static')
        logging.info('SwiftChildTask: Finish clone and build autotest events')
        logging.info('SwiftChildTask: Start copy files to xcode project')
        copy_and_add(self.path() + '/static/cross_lang_test/swift', self.path() + '/cross_lang_test')
        copy_and_add(self.path() + '/generated-sources/swift', self.path() + '/cross_lang_test/SwiftScarabCLTool/SwiftScarabCLTool')
        logging.info('SwiftChildTask: Start add files to xcode project')
        scarab_cl_dir = self.path() + '/cross_lang_test/updateXprojScripts'
        scarab_cl_proj_dir = self.path() + '/cross_lang_test/SwiftScarabCLTool'
        run_process(['sh', 'update.sh', self.path()+'/cross_lang_test/SwiftScarabCLTool'], shell=True, timeout=10000,
                    work_dir=scarab_cl_dir, log_prefix='update_xproj', outputs_to_one_file=True)
        logging.info('SwiftChildTask: python path - ' + sys.executable)
        run_process([sys.executable, 'addNewClassesToProj.py', self.path()+'/cross_lang_test/SwiftScarabCLTool'], shell=True, timeout=10000,
                    work_dir=scarab_cl_dir, log_prefix='update_xproj', outputs_to_one_file=True)
        run_process(['xcodebuild'], shell=True, timeout=10000, work_dir=scarab_cl_proj_dir, log_prefix='run_xproj', outputs_to_one_file=True)
        bin_dir = scarab_cl_proj_dir + '/build/Release'
        input_events = self.path() + '/static/cross_lang_test/input_events.txt'
        output_events = self.path() + '/swift_events'
        run_process(['./SwiftScarabCLTool', input_events, output_events], shell=True, check=True, timeout=10000, work_dir=bin_dir,
                    log_prefix='create_events', outputs_to_one_file=True)
        logging.info('SwiftChildTask: prepare resource')
        self.create_resource(
            description='Swift JSON events for C++ and Python',
            resource_path=output_events + '/SwiftJson.txt',
            resource_type=resource_types.PLAIN_TEXT,
            attributes={
                "task_id": self.id,
                "lang": "swift"
            }
        )
        logging.info('SwiftChildTask: finish task')
