import requests
import json

TITLE_TEMPLATE = 'Update {}'
DESCRIPTION_TEMPLATE = 'Update from sandbox task https://sandbox.yandex-team.ru/task/{}/view'
TESTING_URL = 'https://bb.yandex-team.ru/rest/api/1.0/projects/MOBILE/repos/testing/pull-requests'
PROD_URL = 'https://bb.yandex-team.ru/rest/api/1.0/projects/MOBILE/repos/monorepo/pull-requests'


class Monorepo:
    def create_pr(self, branch_name, isTesting=True, sbTaskId=None, token=None):
        url = TESTING_URL if isTesting else PROD_URL
        slug = 'testing' if isTesting else 'monorepo'
        title = TITLE_TEMPLATE.format(branch_name)
        desc = DESCRIPTION_TEMPLATE.format(sbTaskId)
        payload = {
            "title": title,
            "description": desc,
            "state": "OPEN",
            "open": True,
            "closed": False,
            "fromRef": {
                "id": branch_name,
                "repository": {
                    "slug": slug,
                    "name": None,
                    "project": {
                        "key": "MOBILE"
                    }
                }
            },
            "toRef": {
                "id": "master",
                "repository": {
                    "slug": slug,
                    "name": None,
                    "project": {
                        "key": "MOBILE"
                    }
                }
            },
            "locked": False,
            "reviewers": [
                {"user": {"name": "mrdekk"}},
                {"user": {"name": "thevery"}}
            ],
            "links": {"self": [None]}
        }
        headers = {
            "Authorization": token,
            "Content-Type": "application/json"
        }
        r = requests.post(url, data=json.dumps(payload), headers=headers)
        return r.content
