# -*- coding: utf-8 -*-
from sandbox import sdk2
from sandbox.sandboxsdk import environments
from sandbox.sandboxsdk.process import run_process
import sandbox.projects.common.constants as consts
from sandbox.projects.common.arcadia import sdk
import sandbox.projects.release_machine.input_params2 as rm_params
import sandbox.common.types.resource as ctr
from sandbox.common.types import task as ctt
from sandbox.projects.yql.RunYQL2 import RunYQL2
from sandbox.projects.logs import resources

import datetime
import os
import json
import logging

TABLE_PROPS_REMOVER_PATH = 'quality/user_sessions/tools/ttl_props_remover'
YT_TOKEN_OWNER = 'robot-make-sessions'
YT_TOKEN_NAME = 'sec-01daxfs11zg96x6vwey9pg5q5n#secret'


def get_default_tables_non_staff():
    tables_list = [
        'clean',
        'factors',
        'frauds',
        'frauds.factors',
        'frauds.tech',
        'outstaff',
        'outstaff.factors',
        'outstaff.tech',
        'robots',
        'robots.factors',
        'robots.tech',
        'tech',
        'unknown',
        'unknown.factors',
        'unknown.tech',
        'yandex_robots',
        'yandex_servers',
        'yandex_servers.factors',
    ]

    return ','.join(tables_list)


def get_default_tables_staff():
    return ','.join(['yandex_staff', 'yandex_staff.factors', 'yandex_staff.tech'])


class RunRemovePropsTTl(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt', version='0.10.8')]
        cores = 1
        ram = 4096

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(rm_params.ComponentName2):
        path_to_tables = sdk2.parameters.String('Path to tables', required=True)
        tables_list = sdk2.parameters.String(
            'list of tables comma separated e.g"clean, frauds, tech"', default=get_default_tables_non_staff()
        )
        dst_path = sdk2.parameters.String('destination path', required=True)

        path_to_staff = sdk2.parameters.String('path to staff dir')
        staff_tables_list = sdk2.parameters.String(
            'list of tables comma separated e.g"clean, frauds, tech"', default=get_default_tables_staff()
        )
        # dont_use_cached_result = sdk2.parameters.Bool('Do not use cached result resource', required=False, default=False)
        yt_token = sdk2.parameters.YavSecret('YavSecret with yt-token', default=YT_TOKEN_NAME)
        yt_cluster = sdk2.parameters.String('cluster', default='hahn', required=True)
        leave_old = sdk2.parameters.Bool('leave old data')
        arc_path = sdk2.parameters.String('Arcadia url for ttl_props_remover')
        arcadia_patch = sdk2.parameters.String('Arcadia patch in common format arc:review_id/zippatch/etc')

    def clone_and_build(self, arcadia_url, api, result_dir, patch=None):
        with sdk.mount_arc_path(arcadia_url, use_arc_instead_of_aapi=True) as arcadia_dir:
            sdk.do_build(
                build_system=consts.YMAKE_BUILD_SYSTEM,
                source_root=arcadia_dir,
                targets=[api],
                build_type=consts.RELEASE_BUILD_TYPE,
                results_dir=str(result_dir),
                clear_build=False,
                use_dev_version=False,
                sanitize=False,
                checkout=False,
                patch=patch,
            )

    def prepare_bin_as_resource(self, path):
        sdk2.ResourceData(
            resources.SESSIONS_TTL_PROPS_REMOVER_EXECUTABLE(
                self,
                'ttl props remover for structured tables',
                str(path),
                branch=self.Parameters.arc_path,
                parent_task_id=self.id,
            )
        )

    def search_bin(self):
        try:
            resource = resources.SESSIONS_TTL_PROPS_REMOVER_EXECUTABLE.find(
                attrs=dict(branch=self.Parameters.arc_path)
            ).first()
            if resource:
                self.Context.use_bin_from_res = True
                return str(sdk2.ResourceData(resource).path)
        except:
            return None
        return None

    def create_client(self):
        from yt.wrapper import YtClient

        yt_client = YtClient(token=self.token, proxy=self.Parameters.yt_cluster)
        return yt_client

    def on_execute(self):
        prep_res = None
        if not prep_res:
            logging.info('Building/searching binary')
            result_path = self.path('builded')
            work_dir = str(self.path())
            ttl_props_remover_path = self.search_bin()
            work_dir = str(result_path) + '/' + TABLE_PROPS_REMOVER_PATH
            self.clone_and_build(
                self.Parameters.arc_path,
                TABLE_PROPS_REMOVER_PATH,
                result_path,
                self.Parameters.arcadia_patch,
            )
            ttl_props_remover_path = str(work_dir) + '/ttl_props_remover'
            self.token = self.Parameters.yt_token.data()[self.Parameters.yt_token.default_key]
            self.client = self.create_client()
            
            os.environ['YT_TOKEN'] = self.token
            if not self.Context.run:
                logging.info('Running remover')
                cmd_args = [
                    ttl_props_remover_path,
                    '--src_dir',
                    self.Parameters.path_to_tables,
                    '--src_tables',
                    self.Parameters.tables_list,
                    '--server',
                    self.Parameters.yt_cluster,
                    '--dst_dir',
                    self.Parameters.dst_path,
                ]
                if self.Parameters.path_to_staff:
                    cmd_args.extend(['--staff_dir', self.Parameters.path_to_staff])
                    cmd_args.extend(['--staff_tables', self.Parameters.staff_tables_list])

                if self.Parameters.leave_old:
                    cmd_args.append('--leave_old')

                try:
                    run_process(
                        cmd_args,
                        work_dir=work_dir,
                        shell=True,
                        log_prefix='ttl_props_remover_path',
                        outputs_to_one_file=True,
                    )
                    if not self.Parameters.leave_old:
                        logging.info('Starting move tables')
                        for table in self.Parameters.tables_list:
                            log.debug('move {}'.format(table))
                            yt.move(
                                os.path.join(self.Parameters.dst_path, table),
                                os.path.join(self.Parameters.src_path, table),
                            )
                            for table in self.Parameters.staff_tables_list:
                                yt.move(
                                    os.path.join(self.Parameters.dst_path, table),
                                    os.path.join(self.Parameters.staff_dir, table),
                                )

                except Exception as e:
                    raise e

                self.Context.run = True
