import json
import urllib2
import httplib
import sys
import logging

SOLOMON_FORMAT = "%Y-%m-%dT%H:%M:%SZ"

def send_to_solomon(cluster, common_sensors_dict, data_sensors_list, token, dry):
    data = {}
    data["commonLabels"] = {
        "task-name": "data_size",
        "time-period": "1d",
    }
    data["commonLabels"].update(common_sensors_dict)
    data["sensors"] = data_sensors_list
    sensors_json = json.dumps(data, indent=4)
    logging.info("SENDING: {}".format(sensors_json))

    solomon_address = 'http://solomon.yandex.net/api/v2/push?project=user_sessions&cluster={}&service=rem-tasks'.format(cluster)
    http_request = urllib2.Request(solomon_address, headers = {"Content-Type": "application/json", "Authorization": "OAuth {}".format(token)})
    try:
        logging.debug("SENDING request to solomon: " + sensors_json)
        if not dry:
            http_response = urllib2.urlopen(http_request, sensors_json, timeout=40)

            if http_response.getcode() != httplib.OK:
                pass
                # TODO: handle

        return True
    except Exception as e:
        msg = "Exception: {}. Sensors json: {}".format(e, sensors_json)
        print >> sys.stderr, msg
        logging.info(msg)
        return False
