from sandbox.projects.sandbox_ci.utils.request import send_request


def get_image_hash(registry_url, tag):
    url = 'https://dockinfo.yandex-team.ru/api/docker/resolve?registryUrl={registry_url}&tag={tag}'.format(
        registry_url=registry_url,
        tag=tag
    )

    resp = send_request('get', url, headers=None, verify=False)
    if resp.ok:
        return resp.json()['hash']
    else:
        raise Exception("Failed to get hash for image '{}.{}' with code {}: {}".format(
            registry_url, tag, resp.status_code, resp.text))
