from collections import namedtuple


MailProject = namedtuple(
    'MailProject',
    'title, package_path, registry_image, build_path, qa_components, canary_components, prod_components, yamake_env_vars, yamake_definition_flags'
)

PROJECTS = [
    MailProject(title='Ava',
                package_path='mail/ava/package/package.json',
                registry_image='mail/ava/ava',
                build_path='mail/ava',
                qa_components=['mail.ava.testing.ava'],
                canary_components=['mail.ava.testing.ava'],  # FIXME: just for test
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Beagle',
                package_path='mail/beagle/package/package.json',
                registry_image='mail/beagle/beagle',
                build_path='mail/beagle',
                qa_components=['mail.beagle.testing.api', 'mail.beagle.testing.workers'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Calendar',
                package_path='mail/calendar/package/package.json',
                registry_image='mail/calendar',
                build_path='mail/calendar',
                qa_components=['mail.calendar-public.testing.caldav', 'mail.calendar-public.testing.worker', 'mail.calendar-public.testing.web',
                               'mail.calendar-yt.testing.caldav', 'mail.calendar-yt.testing.worker', 'mail.calendar-yt.testing.web'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='CALENDAR_YT_STAFF_TOKEN_PATH=$(vault:file:MAIL:calendar-staff-api-token) CALENDAR_TVMTOOL_TOKEN_PATH=$(vault:file:MAIL:calendar-tvmtool-token) '\
                                + 'CALDAV_USER_TOKEN_PATH=$(vault:file:MAIL:caldavcompluser)',
                yamake_definition_flags=''),
    MailProject(title='Calendar-mailhook',
                package_path='mail/github/logbroker-client-common/package/package.json',
                registry_image='mail/calendar-mailhook-processor',
                build_path='mail/github/logbroker-client-common',
                qa_components=['mail.calendar-yt.testing.calendar-mailhook'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Callmeback-api',
                package_path='mail/callmeback/package/api/package.json',
                registry_image='mail/callmeback/callmeback-api',
                build_path='mail/callmeback',
                qa_components=['mail.callmeback.test.api'],
                canary_components=[],
                prod_components=['mail.callmeback.prod.api'],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Callmeback-dbstats',
                package_path='mail/callmeback/package/dbstats/package.json',
                registry_image='mail/callmeback/callmeback-dbstats',
                build_path='mail/callmeback',
                qa_components=['mail.callmeback.test.dbstats'],
                canary_components=[],
                prod_components=['mail.callmeback.prod.dbstats'],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Callmeback-worker',
                package_path='mail/callmeback/package/worker/package.json',
                registry_image='mail/callmeback/callmeback-worker',
                build_path='mail/callmeback',
                qa_components=['mail.callmeback.test.worker'],
                canary_components=[],
                prod_components=['mail.callmeback.prod.worker'],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Cerberus',
                package_path='mail/cerberus/package/package.json',
                registry_image='mail/cerberus',
                build_path='mail/cerberus',
                qa_components=['mail.cerberus-public.testing.worker', 'mail.cerberus-public.testing.cerberus',
                               'mail.cerberus-yt.testing.worker', 'mail.cerberus-yt.testing.cerberus'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Ciao',
                package_path='mail/ciao/package/package.json',
                registry_image='mail/ciao/ciao',
                build_path='mail/ciao',
                qa_components=['mail.ciao.qa.api'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Collie',
                package_path='mail/collie/package/package.json',
                registry_image='mail/collie/collie',
                build_path='mail/collie',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Doberman',
                package_path='mail/doberman/package/package.json',
                registry_image='mail/webmail/doberman',
                build_path='mail/doberman',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Detemple',
                package_path='mail/apphost/detemple/package/package.json',
                registry_image='mail/detemple/detemple',
                build_path='mail/apphost/detemple',
                qa_components=['mail.detemple.prestable.detemple'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Eset',
                package_path='mail/av/eset/package/package.json',
                registry_image='mail/av/eset',
                build_path='mail/av/eset',
                qa_components=['mail.av.qa.eset'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='FirstLine',
                package_path='mail/firstline/package/package.json',
                registry_image='mail/firstline/firstline',
                build_path='mail/firstline',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Furita',
                package_path='mail/furita/package/package.json',
                registry_image='mail/furita/furita',
                build_path='mail/furita',
                qa_components=['mail.furita.unstable.furita', 'mail.furita.qa.furita', 'mail.furita-corp.qa.furita'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Husky',
                package_path='mail/husky/package/package.json',
                registry_image='mail/husky/husky',
                build_path='mail/husky',
                qa_components=['mail.husky.test.husky-worker'],
                canary_components=['mail.husky.prod.husky-canary', 'mail.husky.corp.husky-canary'],
                prod_components=['mail.husky.prod.husky-worker', 'mail.husky.corp.husky-worker'],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Ipa',
                package_path='mail/ipa/package/package.json',
                registry_image='mail/ipa/ipa',
                build_path='mail/ipa',
                qa_components=['mail.ipa.testing.api', 'mail.ipa.testing.workers',
                               'mail.ipa.load.api', 'mail.ipa.load.mock', 'mail.ipa.load.workers', 'mail.ipa.load.workers-collectors'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='MdbSave',
                package_path='mail/mdbsave/package/package.json',
                registry_image='mail/mdbsave/mdbsave',
                build_path='mail/mdbsave',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='RateSrv',
                package_path='mail/ratesrv/package/package.json',
                registry_image='mail/ratesrv/ratesrv',
                build_path='mail/ratesrv',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='MessageBody',
                package_path='mail/message_body/package/package.json',
                registry_image='mail/mbody/mbody',
                build_path='mail/message_body',
                qa_components=['mail.mbody.qa.mbody'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Mops',
                package_path='mail/mops/package/package.json',
                registry_image='mail/mops/mops',
                build_path='mail/mops',
                qa_components=['mail.mops.qa.mops'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Mthr',
                package_path='mail/mthr/package/package.json',
                registry_image='mail/mthr/mthr',
                build_path='mail/mthr',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='MxnetApply',
                package_path='mail/apphost/mxnet_apply/package/package.json',
                registry_image='mail/mxnet_apply/mxnet_apply',
                build_path='mail/apphost/mxnet_apply',
                qa_components=['mail.mxnet-apply.testing.mxnet-apply'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Mxtests',
                package_path='mail/mxtests/docker/mxtests/package.json',
                registry_image='mail/mxtests/mxtests',
                build_path='mail/mxtests',
                qa_components=['mail.mxtests.testing.mxtests', 'mail.mxtests.qa.mxtests'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Notsolitesrv',
                package_path='mail/notsolitesrv/package/package.json',
                registry_image='mail/notsolitesrv/notsolitesrv',
                build_path='mail/notsolitesrv',
                qa_components=["mail.notsolitesrv.qa.notsolitesrv", "mail.notsolitesrv-corp.qa.notsolitesrv"],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Nwsmtp',
                package_path='mail/nwsmtp/package/package.json',
                registry_image='mail/nwsmtp/nwsmtp',
                build_path='mail/nwsmtp',
                qa_components=['mail.nwsmtp.qa.mxback', 'mail.nwsmtp.qa.mxfront', 'mail.nwsmtp.qa.smtp', 'mail.nwsmtp.qa.smtp-devices', 'mail.nwsmtp.qa.yaback',
                               'mail.nwsmtp-corp.qa.smtpcorp', 'mail.nwsmtp-corp.qa.mxcorp', 'mail.nwsmtp-corp.qa.mxbackcorp', 'mail.nwsmtp-corp.qa.outback'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Ohio',
                package_path='mail/ohio/package/package.json',
                registry_image='mail/ohio/ohio',
                build_path='mail/ohio',
                qa_components=['mail.ohio.testing.api'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='QMgr',
                package_path='mail/qmgr/deploy/qmgr/package/package.json',
                registry_image='mail/qmgr',
                build_path='mail/qmgr',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Reminders',
                package_path='mail/reminders/package/package.json',
                registry_image='mail/reminders',
                build_path='mail/reminders',
                qa_components=['mail.reminders.testing.api', 'mail.reminders.testing.worker'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='REMINDERS_XIVA_PUSH_TOKEN=$(vault:file:MAIL:reminders-xiva-push-token) REMINDERS_SUP_PUSH_TOKEN=$(vault:file:MAIL:reminders-sup-push-token)',
                yamake_definition_flags='-DJDK_VERSION=8'),
    MailProject(title='Retriever',
                package_path='mail/retriever/package/package.json',
                registry_image='mail/retriever/retriever',
                build_path='mail/retriever',
                qa_components=['mail.retriever.prestable.retriever'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Samsara',
                package_path='mail/samsara/package/package.json',
                registry_image='mail/samsara/samsara',
                build_path='mail/samsara',
                qa_components=['mail.samsara.testing.samsara'],
                canary_components=[],
                prod_components=['mail.samasara.production', 'mail.samasara.intranet-production'],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Settings',
                package_path='mail/ymsettings/package/settings.json',
                registry_image='mail/settings/settings',
                build_path='mail/ymsettings',
                qa_components=['mail.settings.prestable.settings'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='ShingerPrint',
                package_path='mail/apphost/shinger_print/package/package.json',
                registry_image='mail/shinger_print/shinger_print',
                build_path='mail/apphost/shinger_print',
                qa_components=['mail.shinger-print.testing.shinger-print'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Shiva',
                package_path='mail/shiva/package/package.json',
                registry_image='mail/shiva/shiva',
                build_path='mail/shiva',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Sms',
                package_path='mail/sms/package/package.json',
                registry_image='mail/sms/sms',
                build_path='mail/sms',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='TemplateIdentifier',
                package_path='mail/apphost/template_identifier/package/package.json',
                registry_image='mail/sherlock/template_identifier',
                build_path='mail/apphost/template_identifier',
                qa_components=['mail.template-identifier.production.daemon-prestable'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='TemplateMaster',
                package_path='mail/template_master/package/package.json',
                registry_image='mail/template_master',
                build_path='mail/template_master',
                qa_components=['mail.template-master.testing.template-master'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='YamaildevBot',
                package_path='mail/bots/dev_bot/package/package.json',
                registry_image='mail/telegram_bot/telegram_bot',
                build_path='mail/bots/dev_bot',
                qa_components=[],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='Yaqt',
                package_path='mail/yaqt/package/package.json',
                registry_image='mail/yaqt/yaqt',
                build_path='mail/yaqt',
                qa_components=['mail.husky.test.yaqt'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
    MailProject(title='York',
                package_path='mail/york/package/package.json',
                registry_image='mail/york/york-corp',
                build_path='mail/york',
                qa_components=['mail.york-corp.testing.york'],
                canary_components=[],
                prod_components=[],
                yamake_env_vars='',
                yamake_definition_flags=''),
]
