from requests import codes
from sandbox.projects.sandbox_ci.utils.request import send_request
from sandbox.projects.common import link_builder as lb


class StarTrackApi(object):
    def __init__(self, token, url='https://st-api.yandex-team.ru'):
        self._url = url
        self._token = token
        self._headers = {
            'Authorization': 'OAuth {token}'.format(token=self._token)
        }

    def _api_url(self, path):
        return "{}/v2/{}".format(self._url, path)

    def add_comments(self, issues, text=None, attachments_ids=None, summonees=None,
                     maillist_summonees=None, task_id=None):
        errors = []
        task_url_text = "\n----\nSent from job: {}".format(lb.task_link(task_id, plain=True)) if task_id else ""
        for issue in issues:
            try:
                self.__add_comment(issue, text=text + task_url_text, attachments_ids=attachments_ids,
                                   summonees=summonees, maillist_summonees=maillist_summonees)
            except Exception as e:
                errors.append({"task": issue, "error": str(e)})
        return errors

    def __add_comment(self, issue, text=None, attachments_ids=None, summonees=None,
                      maillist_summonees=None):
        url = self._api_url("issues/{}/comments".format(issue))
        params = {}

        def add_param(name, param):
            if param:
                params[name] = param

        add_param('text', text)
        add_param('attachments_ids', attachments_ids)
        add_param('summonees', summonees)
        add_param('maillist_summonees', maillist_summonees)

        res = send_request('post', url, headers=self._headers, json=params)
        if res.status_code != codes.created:
            raise Exception("Failed to comment issue {} with code {}: {}".format(
                issue, res.status_code, res.text))
