import logging
from sandbox import sdk2
from multiprocessing.dummy import Pool


class SmtpLimits(sdk2.Resource):
    """ Plaintext file resource """


class GenerateSmtpLimits(sdk2.Task):
    """ A simple task which writes to a file. """

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 30*60

    def on_execute(self):
        from sandbox.projects.mail.GenerateSmtpLimits.lib import smtp

        p = Pool(20)

        result = p.map(lambda server: (server, smtp.get_size(server)), smtp.get_domains())
        result.sort()

        resource = sdk2.ResourceData(SmtpLimits(
            self, "Output file", "smtplimits.lst"
        ))

        text = []
        for r in result:
            if r[1] is None:
                logging.error('cannot get limits for '+r[0])
            else:
                text.append('{0} {1}'.format(r[0], r[1]))

        resource.path.write_bytes('\n'.join(text))
