import logging
import dns.resolver
from smtplib import SMTP
import library.python.resource


def smtp(server):
    return SMTP(server, timeout=30)


def query(server):
    return dns.resolver.query(server, 'MX')


def raise_and_log(s):
    logging.error(s)
    raise RuntimeError(s)


def parse_size(s):
    try:
        for ext in s.split('\n'):
            if ext.lower().startswith('size'):
                return int(ext.split()[1])
    except Exception as e:
        raise_and_log('parse_size: an exception while parsing: ' + str(e))

    raise_and_log('parse_size: cannot find SIZE extension src:' + s)


def ehlo(server, tries=3):
    logging.debug('smtp {server}'.format(server=server))
    s = None
    for i in range(tries):
        try:
            s = smtp(server)
            resp = s.ehlo()

            if resp[0] == 250:
                return resp[1]
        except Exception as e:
            raise_and_log('smtp {server}: try {i} exception {e}'.format(server=server, e=e, i=i))
        finally:
            if s is not None:
                s.quit()

    raise_and_log('smtp {server}: try limit'.format(server=server))


def get_mx_server(server):
    try:
        return '.'.join(query(server)[0].exchange[:-1])
    except Exception as e:
        raise_and_log('dns {server}: exception {e}'.format(server=server, e=e))


def get_size(server):
    mx = None
    resp = None
    try:
        mx = get_mx_server(server)
        resp = ehlo(mx)
        ret = parse_size(resp)
        logging.info('global {server}: size {size}'.format(server=server, size=ret))
        return ret
    except Exception as e:
        logging.error('global {server}: cannot get ehlo mx={mx} resp={resp} exception={e}'.format(server=server, mx=mx, resp=resp, e=e))

    return None


def get_domains():
    return library.python.resource.find('domains').split('\n')
