# -*- coding: utf-8 -*-

import pytest
from sandbox.projects.mail.GenerateSmtpLimits.lib import smtp
from mock import patch, Mock


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.smtp')
def test_should_return_ehlo_response_on_success_250_code(smtpMock):
    serv = Mock()
    serv.ehlo = Mock()
    serv.ehlo.return_value = (250, 'some_string')
    serv.quit = Mock()
    smtpMock.return_value = serv

    assert smtp.ehlo('') == 'some_string'
    serv.ehlo.assert_called_once()
    serv.quit.assert_called_once()


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.smtp')
def test_should_retry_on_smtp_fail_code(smtpMock):
    TRIES = 4
    serv = Mock()
    serv.ehlo = Mock()
    serv.ehlo.side_effect = [(500, 'some_string')] * (TRIES-1) + [(250, 'some_string')]
    serv.quit = Mock()
    smtpMock.return_value = serv

    assert smtp.ehlo('', TRIES) == 'some_string'
    assert serv.ehlo.call_count == TRIES
    assert serv.quit.call_count == TRIES


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.smtp')
def test_should_raise_on_errors(smtpMock):
    serv = Mock()
    serv.ehlo = Mock()
    serv.ehlo.side_effect = RuntimeError('')
    serv.quit = Mock()
    smtpMock.return_value = serv

    with pytest.raises(RuntimeError):
        smtp.ehlo('')

    serv.ehlo.return_value = None
    with pytest.raises(RuntimeError):
        smtp.ehlo('')

    smtpMock.side_effect = RuntimeError('')
    serv.quit.reset_mock()
    with pytest.raises(RuntimeError):
        smtp.ehlo('')
    serv.quit.assert_not_called()
