# -*- coding: utf-8 -*-

from sandbox.projects.mail.GenerateSmtpLimits.lib import smtp
from mock import patch, Mock


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.query')
@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.smtp')
def test_should_return_size(sMock, qMock):
    serv = Mock()
    serv.ehlo = Mock()
    serv.ehlo.return_value = (250, 'size 1')
    serv.quit = Mock()
    sMock.return_value = serv

    mx = Mock()
    mx.exchange = ['mx', 'yandex', 'ru', '.']
    qMock.return_value = [mx]

    assert smtp.get_size('') == 1


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.query')
@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.smtp')
def test_should_return_none_on_any_error(sMock, qMock):
    serv = Mock()
    serv.ehlo = Mock()
    serv.ehlo.side_effect = RuntimeError('')
    serv.quit = Mock()
    sMock.return_value = serv

    mx = Mock()
    mx.side_effect = RuntimeError('')
    qMock.return_value = [mx]

    assert smtp.get_size('') is None
