# -*- coding: utf-8 -*-

import pytest
from sandbox.projects.mail.GenerateSmtpLimits.lib import smtp


def test_should_take_first_size_extension():
    assert smtp.parse_size('\n'.join(['asdf qwer', 'size 1', 'size 2'])) == 1


def test_should_compare_in_case_insensitively():
    assert smtp.parse_size('\n'.join(['asdf qwer', 'size 1', 'size 2'])) == 1
    assert smtp.parse_size('\n'.join(['asdf qwer', 'SiZe 1', 'size 2'])) == 1
    assert smtp.parse_size('\n'.join(['asdf qwer', 'SIZE 1', 'size 2'])) == 1


def test_should_raise_an_exception_on_any_error_or_missing_extension():
    with pytest.raises(RuntimeError):
        smtp.parse_size('\n'.join(['asdf qwer', 'size a']))

    with pytest.raises(RuntimeError):
        smtp.parse_size('\n'.join(['asdf qwer']))
