# -*- coding: utf-8 -*-

import pytest
from sandbox.projects.mail.GenerateSmtpLimits.lib import smtp
from mock import patch, Mock


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.query')
def test_should_return_address_without_root_zone(mockQuery):
    mx = Mock()
    mx.exchange = ['mx', 'yandex', 'ru', '.']
    mockQuery.return_value = [mx]
    assert smtp.get_mx_server('') == 'mx.yandex.ru'


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.query')
def test_should_take_first_dns_record(mockQuery):
    mx1 = Mock()
    mx1.exchange = ['mx', 'google', 'com', '.']
    mx2 = Mock()
    mx2.exchange = ['mx', 'yandex', 'ru', '.']
    mockQuery.return_value = [mx1, mx2]

    assert smtp.get_mx_server('') == 'mx.google.com'


@patch('sandbox.projects.mail.GenerateSmtpLimits.lib.smtp.query')
def test_should_raise_none_on_any_error(mockQuery):
    mockQuery.return_value = []
    with pytest.raises(RuntimeError):
        smtp.get_mx_server('')

    mockQuery.side_effect = RuntimeError('')
    with pytest.raises(RuntimeError):
        smtp.get_mx_server('')
