from sandbox import sdk2
from sandbox.common import errors as ce
from sandbox.projects.tank.load_resources.resources import AMMO_FILE

from json import dumps
from time import time
import logging
import requests
import os.path
import random


class MobileApiAmmoGen(sdk2.Task):
    """ Generate ammo file specified for mobile-api shooting """

    class Context(sdk2.Task.Context):
        ammo_resource = ""
        source_file = ""

    class Requirements(sdk2.Requirements):
        cores = 2
        disk_space = 2048  # 2GB
        ram = 1024         # 1GB

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        description = sdk2.parameters.String('Comment for generation')
        source = sdk2.parameters.String('Datasource link', default='https://proxy.sandbox.yandex-team.ru/1277594319', required=True)
        pgtype = sdk2.parameters.String('Users type', default='type500', required=True)
        profile = sdk2.parameters.JSON('Shooting profile', default={"v1_messages": 1}, required=True)
        ammocount = sdk2.parameters.Integer('Bullits count', default=40000, required=True)

        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource('Ammo', required=True)

    def make_ammo(self):
        ammo = AMMO_FILE(self, 'mobile-api ammo', 'ammo.json', ttl=1)
        ammoData = sdk2.ResourceData(ammo)
        try:
            ammoData.path.write_bytes(self.get_ammo_data())
            ammoData.ready()
            self.Context.ammo_resource = str(ammoData.path)
            return ammo
        except Exception as ex:
            raise ce.TaskFailure("Can not create ammo resource. Exception: {}".format(ex))

    def meta_parser(self, ammo_type):
        self.loger.info("Meta parser for type {}".format(ammo_type))
        out = []
        with open(get_source(self.Parameters.source, 'mobile.csv'), "r") as fd:
            for line in fd:
                t1, login, mids, fids, tids, stids, lids, oauth, uid, suid, md5, mdb = line.rstrip()[1:-1].split('","')
                if t1 == ammo_type:
                    meta = dict()
                    meta.update({"type": t1, "login": login, "mids": '["{}"]'.format(mids.replace(',', '","')), "fid": "1"})
                    meta.update({"tids": '["{}"]'.format(tids.replace(',', '","')), "stids": stids.split(',')})
                    meta.update({"lids": lids.split(','), "oauth": oauth, "uid": uid, "md5": md5, "mdb": mdb})
                    out.append(meta)
        self.loger.info("Meta parser finish")
        return out

    def set_distr_from_json(self):
        out = []
        for i in xrange(self.Parameters.ammocount):
            out.append(weighted_json_choice(self.Parameters.profile))
        self.distr = out

    def get_ammo_data(self):
        self.loger.info("Start ammo data generator")
        bullits = list()
        i = 0
        meta_length = len(self.meta)
        self.loger.info("Meta lenght is {}".format(meta_length))
        for handler in self.distr:
            bullit = dict()
            mid1, mid2, mid3 = get_n_elements(self.meta[i % meta_length]["mids"], 3)
            tid1, tid2, tid3 = get_n_elements(self.meta[i % meta_length]["tids"], 3)
            if handler in self.legal_handlers:
                bullit.update({"tag": handler, "login": self.meta[i % meta_length]["login"], "uid": self.meta[i % meta_length]["uid"]})
                bullit.update({"oauth": self.meta[i % meta_length]["oauth"], "tids": self.meta[i % meta_length]["tids"], "mids": self.meta[i % meta_length]["mids"]})
                bullits.append(bullit)
                i += 1
        self.loger.info("Finish ammo data generator")
        return ("\n".join(dumps(bullit) for bullit in bullits)).replace('\\"', '"').replace('"[', '[').replace(']"', ']').encode('utf-8')

    def on_execute(self):
        self.loger = logger()
        self.loger.info("Start task")
        self.legal_handlers = [
            "v1_messages",
            "v1_ava2",
            "v1_xlist",
            "v1_uaz",
            "v1_message_body",
            "v2_classification",
            "v1_attach",
            "v1_mark_read",
            "v1_settings",
            "v1_push",
            "v1_abook_top",
            "v1_reset_fresh",
            "v2_reset_fresh",
            "v1_abook_suggest",
            "v1_ava",
            "v1_only_new",
            "v1_set_parameters",
            "v2_get_newsletters"
        ]
        self.set_distr_from_json()
        self.meta = self.meta_parser(self.Parameters.pgtype)

        with self.memoize_stage.make_ammo:
            self.Parameters.ammo = self.make_ammo()
        # ==== End Of Class ==== #


def logger():
    logger = logging.getLogger('%s_%s' % (__name__, time()))
    logger.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'mobileapi_ammogen.log',
        maxBytes=1024 * 1024,
        backupCount=5
    )
    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    logger.addHandler(file_handler)
    return logger


def get_source(url, dst):
    session = requests.session()
    try:
        with open(dst, 'wb') as resource:
            resource.write(session.get(url, stream=True).content)
        return os.path.abspath(dst)
    except Exception as ex:
        raise ce.TaskFailure("Can't download resource {}. Ex: {}".format(dst, ex))
    finally:
        session.close()


# Functions for generation ammo data
def weighted_json_choice(choices):
    ''' dict where key is choice and value probability '''
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


def dedup_str_list(str_list):
    out=[]
    for s in str_list:
        if s not in out:
            out.append(s)
    return out


def get_n_elements(str_list, num):
    indices = list()
    out = list()
    if len(str_list) < num:
        return None
    while len(indices) < num:
        i = random.randint(0, len(str_list)-1)
        if i not in indices:
            indices.append(i)
    for i in indices:
        out.append(str_list[i])
    return out
