# coding: utf-8
import json
from collections import namedtuple

import requests


SwatProject = namedtuple(
    'SwatProject',
    'title, host, tank_config_url, ammo_url, reference_shootings, setup_hooks'
)


def beagle_setup_hook():
    session = requests.Session()
    for org_id in range(1, 11):
        # Мок автоматически генерирует содержимое организации, когда кто-то к ней обращается.
        # Поэтому, протыкаем 10 организаций.
        r = session.get('http://directory-mock-1.directory-mock.load.beagle.mail.stable.qloud-d.yandex.net/v11/organizations/{}/'.format(org_id))
        assert r.json()['id'] == org_id


PROJECTS = (
    SwatProject(
        title='beagle',
        host='api-1.api.load.beagle.mail.stable.qloud-d.yandex.net',
        tank_config_url='https://a.yandex-team.ru/api/tree/blob/trunk/arcadia/mail/beagle/load/config.yaml?repo=arc',
        ammo_url='http://directory-mock-1.directory-mock.load.beagle.mail.stable.qloud-d.yandex.net/ammo',
        reference_shootings=['2447847'],
        setup_hooks=[beagle_setup_hook],
    ),
    SwatProject(
        title='ipa',
        host='api-1.api.load.ipa.mail.stable.qloud-d.yandex.net',
        tank_config_url='https://a.yandex-team.ru/api/tree/blob/trunk/arcadia/mail/ipa/load/config.yaml?repo=arc',
        ammo_url='https://a.yandex-team.ru/api/tree/blob/trunk/arcadia/mail/ipa/load/ammo?repo=arc',
        reference_shootings=['2447190'],
        setup_hooks=[],
    ),
)
