from sandbox import sdk2
from sandbox.sdk2 import yav
from sandbox.common import errors as ce
from sandbox.projects.tank.load_resources.resources import AMMO_FILE

from multiprocessing import Pool
from time import sleep
import logging
import requests
import httplib
import os.path
import random
import json
import time
import os
import re


WORKERS = 32
PASSPORT_HOST = 'passport-test.yandex.ru'


class WebApiAmmoGen(sdk2.Task):
    """ Generate ammofile for web-api,quinn and liza shooting """

    class Context(sdk2.Task.Context):
        ammo_resource = ""
        source_file = ""
        experiments_file = ""

    class Requirements(sdk2.Requirements):
        cores = 2
        disk_space = 2048  # 2GB
        ram = 1024         # 1GB

        class Caches(sdk2.Requirements.Caches):
            pass  # means that task do not use any shared caches

    class Parameters(sdk2.Parameters):
        description = sdk2.parameters.String('Comment for generation')
        wmi = sdk2.parameters.String('Host to ckey', default='7bngfpwx5nxmxwyf.sas.yp-c.yandex.net', required=True)
        source = sdk2.parameters.String('Datasource link', default='https://proxy.sandbox.yandex-team.ru/1210900337', required=True)
        pgtype = sdk2.parameters.String('Users type', default='type500', required=True)
        eweight = sdk2.parameters.Integer('Weight of the experiments users', default=0)
        esource = sdk2.parameters.String('Experiments datasource', default='https://proxy.sandbox.yandex-team.ru/1229816161')
        profile = sdk2.parameters.JSON('Shooting profile', default={"messages@liza": 1}, required=True)

        with sdk2.parameters.Output:
            ammo = sdk2.parameters.Resource('Ammo', required=True)

    def make_ammo(self):
        ammo = AMMO_FILE(self, 'web-api ammo', 'ammo.json', ttl=1)
        ammoData = sdk2.ResourceData(ammo)
        try:
            ammoData.path.write_bytes(self.get_ammo_data())
            ammoData.ready()
            self.Context.ammo_resource = str(ammoData.path)
            return ammo
        except Exception as ex:
            raise ce.TaskFailure("Can not create ammo resource. Exception: {}".format(ex))

    def get_ammo_data(self):
        i = 0
        bullits = list()
        if int(self.Parameters.eweight) > 0:
            experiments = self.get_exp()
        handlers = self.get_handlers()
        for handler in handlers:
            try:
                uri = handler.split('@')[1]
                handler = handler.split('@')[0]
            except IndexError:
                uri = "empty"
            if int(self.Parameters.eweight) == 0:
                _exp = ""
                _eexp = ""
            else:
                number = int(i) % 10
                if number < int(self.Parameters.eweight):
                    _exp = experiments[number][0].replace(" ", "").replace("\n", "")
                    _eexp = experiments[number][1].replace(" ", "").replace("\n", "")
                else:
                    _exp = ""
                    _eexp = ""
            # mid1, mid2, mid3 = get_n_elements(self.meta[i%len(self.meta)]["mids"], 3)
            # tid1, tid2, tid3 = get_n_elements(self.meta[i%len(self.meta)]["tids"], 3)
            bullit = {
                "tag": handler,
                "uid": self.meta[i % len(self.meta)]["uid"],
                "ckey": self.meta[i % len(self.meta)]["ckey"],
                "login": self.meta[i % len(self.meta)]["login"],
                "yandexuid": self.meta[i % len(self.meta)]["yandexuid"],
                "sid2": self.meta[i % len(self.meta)]["ssid2"],
                "mids": self.meta[i % len(self.meta)]["mids"],
                "uri": uri,
                "exp": _exp,
                "eexp": _eexp
            }
            if handler + '@' + uri in self.legal_handlers:
                bullits.append(bullit)
            i += 1
        return ("\n".join(json.dumps(bullit) for bullit in bullits)).replace('\\"', '"').replace('"[', '[').replace(']"', ']').encode('utf-8')

    def meta_parser(self):
        out = []
        pool = Pool(processes=WORKERS)
        source_data = self.get_source_data()
        try:
            out = pool.map(handle, source_data)
        except Exception as ex:
            pool.terminate()
            pool.join()
            raise ce.TaskFailure("Error in meta parser. Exception: {}".format(ex))
        return out

    def get_source_data(self):
        data = []
        secret = yav.Secret("sec-01dv3pah2h340ajp8sbxw83dme")
        pgpass = secret.data()["pgpass"]
        source_file = get_source(self.Parameters.source, 'source.csv')
        self.Context.source_file = source_file
        with open(source_file, "r") as sf:
            for line in sf:
                t1, login, mids, fids, tids, stids, lids, oauth, uid, suid, md5, mdb = line.rstrip()[1:-1].split('","')
                if t1 == self.Parameters.pgtype:
                    data.append((t1, login, mids, fids, tids, stids, lids, oauth, uid, suid, md5, mdb, self.Parameters.wmi, pgpass))
        return data

    def get_handlers(self):
        out = []
        for i in xrange(40000):
            out.append(weighted_json_choice(self.Parameters.profile))
        return out

    def get_exp(self):
        out = []
        experiments_source = get_source(self.Parameters.esource, 'exp.csv')
        if os.path.exists(experiments_source):
            with open(experiments_source, "r") as es:
                for line in es:
                    out.append(line.split(":"))
            self.Context.experiments_file = experiments_source
        else:
            raise ce.TaskFailure("Experiments source is absent")
        return out

    def on_execute(self):
        self.loger = logger()
        self.loger.info("Start generator")
        self.meta = self.meta_parser()
        self.legal_handlers = [
            "root@empty",
            "xiva-sign@empty",
            "service-worker@empty",
            "service-worker-config@empty",
            "print@empty",
            "versions@empty",
            "callback-json@empty",
            "fatal@empty",
            "uid@empty",
            "login@empty",
            "mids@empty",
            # MAILING handlers
            "get-newsletters@v1",
            "get-newsletter-filters@v1",
            "create-newsletter-filters@v1",
            "delete-newsletter-filters@v1",
            "get-messages@v1",
            "get-emails-info@v1",
            "get-ckey@v1",
            "trash-messages@v1",
            "get-folders@v1",
            # JOURNAL handlers
            "do-client-log@journal",
            "do-journal-log@journal",
            "do-action-log@journal",
            # TOUCH handlers
            "do-settings@touch",
            "avatars@touch",
            "account-information,settings,folders,labels,multi-authorization-accounts,messages,user-activity,user-apps-activity@touch",
            "do-messages,folders@touch",
            "do-search-suggest@touch",
            "do-reset-unvisited@touch",
            "do-folder-clear@touch",
            "newsletter-counters@touch",
            "mail-attach-resources@touch",
            "labels,folders@touch",
            "disk-resources-portion@touch",
            "message,message-body@touch",
            "2-messages@touch",
            "5-messages@touch",
            "10-messages@touch",
            "15-messages@touch",
            # LIZA handlers
            "account-information@liza",
            "captcha@liza",
            "collectors@liza",
            "do-label@liza",
            "do-mail-reset-recent-counter@liza",
            "do-messages@liza",
            "do-service-worker-log@liza",
            "email-info@liza",
            "filters@liza",
            "folders@liza",
            "get-user-events@liza",
            "get_user_activity@liza",
            "informer-weather-ng@liza",
            "map-data@liza",
            "message@liza",
            "message-body@liza",
            "message-in-reply-to@liza",
            "message-in-reply-to-ng@liza",
            "message-nearest@liza",
            "messages@liza",
            "messages-pager@liza",
            "messages-types@liza",
            "recipients@liza",
            "reset-unvisited@liza",
            "search-suggest@liza",
            "system-status@liza",
            "todo-timestamp@liza",
            "translate-langs@liza",
            "userphones@liza",
            "ws-header-data@liza",
            # LIZA multihandlers
            "do-messages,folders@liza",
            "do-settings,settings@liza",
            "folders,labels@liza",
            "message-body,message-nearest@liza",
            "user-apps-activity,push-subscriptions@liza",
            "do-messages,folders,labels@liza",
            "folders,labels,messages@liza",
            "folders,labels,messages,message@liza"
        ]

        with self.memoize_stage.make_ammo:
            self.Parameters.ammo = self.make_ammo()
        # ==== End Of Class ==== #


def logger():
    loggerr = logging.getLogger('%s_%s' % (__name__, time.time()))
    loggerr.setLevel(logging.DEBUG)
    formatter = logging.Formatter('%(asctime)s %(levelname)s [%(processName)s: %(threadName)s] %(message)s')
    file_handler = logging.handlers.RotatingFileHandler(
        'webapi_ammogen.log',
        maxBytes=1024 * 1024,
        backupCount=5)
    file_handler.setLevel(logging.DEBUG)
    file_handler.setFormatter(formatter)
    loggerr.addHandler(file_handler)
    return loggerr


def get_source(url, dst):
    session = requests.session()
    try:
        with open(dst, 'wb') as resource:
            resource.write(session.get(url, stream=True).content)
        return os.path.abspath(dst)
    except Exception as ex:
        raise ce.TaskFailure("Can't download resource {}. Ex: {}".format(dst, ex))
    finally:
        session.close()


def weighted_json_choice(choices):
    """ dict where key is choice and value probability """
    total = sum(choices[choice] for choice in choices)
    r = random.uniform(0, total)
    upto = 0
    for choice in choices:
        if upto + choices[choice] >= r:
            return choice
        upto += choices[choice]


def dedup_str_list(str_list):
    out = []
    for s in str_list:
        if s not in out:
            out.append(s)
    return out


def get_n_elements(str_list, num):
    indices = []
    out = []
    if len(str_list) < num:
        print(" list < num ")
        return None
    while len(indices) < num:
        i = random.randint(0, len(str_list)-1)
        if i not in indices:
            indices.append(i)
    for i in indices:
        out.append(str_list[i])
    return out


# ==== HTTP requests and parsers ==== #
def parse_sessionid_cookie(header):
    entries = re.findall('Session_id=([^;]+);', header)
    if not entries:
        return "MFSOB"+header
    return entries[0]


def parse_yandexuid_cookie(header):
    entries = re.findall('yandexuid=([^;]+);', header)
    if not entries:
        return "MFSOB"+header
    return entries[0]


def parse_sessionid2_cookie(header):
    entries = re.findall('sessionid2=([^;]+);', header)
    if not entries:
        return "MFSOB"+header
    return entries[0]


def get_ckey(cookie, wmi, uid):
    connection = httplib.HTTPConnection(wmi, 80)
    headers = {'Cookie': cookie, 'X-Real-IP' : "213.180.206.57", 'Content-Type' : "application/json", 'user-agent': "Pythozilla", 'X-Https-Request': "yes",
                'X-Original-Host': "web-api.yandex.ru", 'X-Original-Uri': "/web-api/models/liza1?_m=get-ckey/v1'", 'x-user-karma': 0}
    connection.request('POST', '/web-api/models/liza1?_m=get-ckey/v1', '{"models":[{"name":"get-ckey/v1"}],"_exp":"","_eexp":""}', headers)
    sleep(0.1)
    doc = json.loads(connection.getresponse().read())
    try:
        return doc['models'][0]['data']['ckey']
    except Exception as ex:
        raise ce.TaskFailure("Can't receive ckey from {}. {}".fomat(wmi, ex))


def get_cookie(login, password):
    headers = {'Content-Type' : 'application/x-www-form-urlencoded; charset=utf-8'}
    connection = httplib.HTTPSConnection(PASSPORT_HOST)
    headers = {'Accept' : '*/*', 'Content-Type' : 'application/x-www-form-urlencoded'}
    connection.request('POST', '/passport?mode=auth', 'login={}&passwd={}&twoweek=yes'.format(login, password), headers)
    headers = connection.getresponse().getheaders()
    connection.close()
    for header in headers:
        if header[0] == 'set-cookie':
            return header[1]
    return None


def handle(tpl):
    t1, login, mids, fids, tids, stids, lids, oauth, uid, suid, md5, mdb, wmi, pgpass = tpl
    cookie = get_cookie(login, pgpass)
    sid = parse_sessionid_cookie(cookie)
    ssid2 = parse_sessionid2_cookie(cookie)
    yandexuid = parse_yandexuid_cookie(cookie)
    ckey = get_ckey('Session_id="{}"; yandex_login={}; yandexuid={}'.format(sid, login, yandexuid), wmi, uid)
    retry = 0
    while ckey == 'null' and retry <= 3:
        ckey = get_ckey('Session_id="{}"; yandex_login={}; yandexuid={}'.format(sid, login, yandexuid), wmi, uid)
        retry += 1
    return {
        "type": t1,
        "login" : login,
        "mids": "[\"{}\"]".format(mids.replace(',', '","')),
        "fid": "1",
        "tids": dedup_str_list(tids.split(',')),
        "stids": stids.split(','),
        "lids": lids.split(','),
        "oauth": oauth,
        "uid": uid,
        "yandexuid": yandexuid,
        "md5": md5,
        "mdb": mdb,
        "ckey": ckey,
        "ssid2": ssid2
    }
