# -*- coding: utf-8 -*-

from sandbox.sandboxsdk import errors as se
from sandbox.sandboxsdk.channel import channel
from sandbox.sandboxsdk.process import run_process

from sandbox.projects.RunScript import RunScript
from sandbox.projects import resource_types

import os


class PlanMailUserEvents(RunScript):
    '''
    Run arbitrary python script from given wheel
    '''
    privileged = True
    type = 'PLAN_MAIL_USER_EVENTS'

    def get_cmdline(self, scriptdir):
        WHEEL_TYPE = str(resource_types.MAIL_PYTHON_USER_EVENTS)
        rlist = channel.sandbox.list_resources(
            resource_type=WHEEL_TYPE,
            omit_failed=True,
            limit=1,
            arch=self.client_info['arch'],
            order_by='-id'
        )
        if not rlist:
            raise se.SandboxTaskFailureError(
                    "Didn't find any resource of type %s" % WHEEL_TYPE
                )
        res_id = rlist[0]
        wheel = self.sync_resource(res_id)

        logfeller_repos = '''
deb http://search-precise.dist.yandex.ru/search-precise/ unstable/all/
deb http://search-precise.dist.yandex.ru/search-precise/ unstable/$(ARCH)/'''
        with open('/etc/apt/sources.list.d/yandex_unstable.list', mode='w') as repo_list:
            repo_list.write(logfeller_repos)
        run_process(['apt-get', 'update'], log_prefix='dpkg')
        run_process(['apt-get', 'install', '-y', 'python-virtualenv'], log_prefix='dpkg')
        run_process(
            [
                'apt-get', 'install', '-y',
                'python-nile=1.12.0',
                'python-qb2',
                'python-wheel=0.29.0-yandex1',
                'python-pyparsing=2.0.3-yandex1',
                'yandex-yt-python=0.7.30-0',
                'yandex-yt-python-yson=0.3.1-0',
                'yandex-search-mr-packet-lib=2545186',
                'yandex-logfeller-client-python=2399385',
                'yandex-yt-transfer-manager-client=0.0.22-0',
                'yandex-yt-python-tools=0.2.108-0',
            ],
            log_prefix='dpkg'
        )
        # with VirtualEnvironment(use_system=True) as venv:
        #     venv.pip('-U pip')
        #     venv.pip(wheel)
        #     return RunScript.on_execute(self)
        venv_dir = os.path.join(scriptdir, 'venv')
        run_process(['/usr/bin/virtualenv', '--system-site-packages', venv_dir], log_prefix='venv')
        run_process([os.path.join(venv_dir, 'bin', 'pip'), 'install', '-U', 'pip', '-i', 'https://pypi.yandex-team.ru/simple/'], log_prefix='venv')
        run_process([os.path.join(venv_dir, 'bin', 'pip'), 'install', '-U', wheel, '-i', 'https://pypi.yandex-team.ru/simple/'], log_prefix='venv')

        return '%s/%s' % (os.path.join(venv_dir, 'bin'), RunScript.get_cmdline(self, scriptdir))


__Task__ = PlanMailUserEvents
