import logging
from sandbox import sdk2
from sandbox.projects.mail.CommonLib.lib.qloud import QloudApi
from multiprocessing.dummy import Pool


class RemoveOldWmiQaEnvironment(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 30*60

    def on_execute(self):
        token = sdk2.Vault.data("robot-gerrit-oauth-platform")
        api = QloudApi('https://platform.yandex-team.ru', token,
            logging.getLogger('QloudApi'))

        p = Pool(20)
        p.map(lambda env: api.delete_environment(env), api.get_environments('mail', 'wmi-qa'))
