import logging
import sandbox.sdk2 as sdk2
import sandbox.common.types.task as ctt
from sandbox.common.errors import TaskFailure
from sandbox.common.errors import VaultError
from sandbox.sdk2 import yav


ROBOT_GERRIT_SECRET_ID = "sec-01d34s477p8fak79sq374swfqa"


class RotateMailNotifyRules(sdk2.Task):

    class Parameters(sdk2.Task.Parameters):
        kill_timeout = 30*60
        owner = "MAIL"
        description = "Rotate duties in notifications rules"
        priority = ctt.Priority(ctt.Priority.Class.USER, ctt.Priority.Subclass.NORMAL)

    def on_execute(self):
        secret = yav.Secret(ROBOT_GERRIT_SECRET_ID)
        from mail.monitoring.common import juggler
        logging.info("Start RotateMailNotifyRules task")
        res = juggler.rotate_duties_in_notify_rule(2665, secret.data()["abc.oauth.token"], "mail.delivery", "5caf433566a3460069a94a65", secret.data()["juggler.oauth.token"])
        logging.info('Result: %s', res.text)
