import logging

from sandbox.projects.mail.UpdateQloudComponent import UpdateQloudComponent
from sandbox.projects.mail.CommonLib.lib.docker import get_image_hash
from sandbox.projects.mail.CommonLib.lib.qloud import QloudApi


class UpdateQloudEnvironment(UpdateQloudComponent):
    """Update all given docker components in Qloud and optionally report result to StarTrack"""

    def on_execute(self):
        token = self._get_vault_data(self.Parameters.qloud_token_vault_item)
        image_url = self.Parameters.image_url
        image_hash = get_image_hash(*image_url.split(':'))
        platform = self._selected_platform()

        api = QloudApi(url=platform.url, token=token,
                       logger=logging.getLogger('QloudApi'))

        sorted_by_env_id = {}
        properties = {'repository': image_url,
                      'hash': image_hash}

        for component in self.Parameters.components:
            sorted_by_env_id.setdefault(self._get_environment_id(component), []).append(
                self._get_component_id(component))

        for environment, components in sorted_by_env_id.iteritems():
            components_id = map(lambda c: self._get_component_id(c), components)

            params = []
            for component_id in components_id:
                params.append({
                    "componentName": component_id,
                    "properties": properties
                })

            version = api.get_environment_deployed_version(environment)
            api.fast_deploy_environment(environment_id=environment,
                                        version=version,
                                        params=params,
                                        comment=self.Parameters.deploy_comment)

        map(api.wait_for_environment_deploy, sorted_by_env_id.keys())
