from sandbox import sdk2
from sandbox.common.types.client import Tag
from sandbox.projects.maps.common.docker_utils_test import DockerTestTask


class BuildDockerAndReleaseTest(DockerTestTask):

    class Requirements(sdk2.Requirements):
        client_tags = Tag.GENERIC

    class Parameters(sdk2.Parameters):
        revision = sdk2.parameters.String('Arcadia revision for docker image build', required=True)
        package_file = sdk2.parameters.String('Package file of docker image to build', required=True)
        nanny_release_to = sdk2.parameters.List('List of stagings to release after build', required=True)
        docker_image_repository = sdk2.parameters.String('Docker image repository', default='maps', required=True)
        docker_user = sdk2.parameters.String('User to push to docker repository', default='robot-maps-sandbox',
                                             required=True)
        docker_token_vault_name = sdk2.parameters.String('Docker user password Vault name',
                                                         default='robot-maps-sandbox-docker-oauth', required=True)
        owner_of_secrets = sdk2.parameters.String('Owner of vault secrets', default='MAPS-CI', required=True)
        overwrite_read_only_files = sdk2.parameters.Bool('Overwrite read-only files in package', default=False)

    def on_execute(self):
        assert self.Parameters.revision.isdigit()

        ya_package_task = self._ya_package_build_docker(
            [self.Parameters.package_file],
            self.Parameters.revision,
            self.Parameters.docker_image_repository,
            self.Parameters.docker_user,
            self.Parameters.docker_token_vault_name,
            self.Parameters.owner_of_secrets,
            self.Parameters.overwrite_read_only_files
        )[0]
        self._verify_subtask(ya_package_task)

        for release_status in self.Parameters.nanny_release_to:
            self.set_info("Releasing to: '{}'".format(release_status))
            self._release_docker_image(ya_package_task, release_status)
