import time
import logging
import os

from sandbox import sdk2
from sandbox.sdk2.helpers import ProcessLog, subprocess

import sandbox.projects.maps.common.jams_common as common


BINARY_LOCAL_RELEASE_DIR = 'release'

DATASET_DIR = 'hist_levels'
DATASET_NAME = 'yandex-maps-jams-historic-levels'

TVM_IDS = {
    'testing': 2021410,
    'stable': 2021408,
}
TVM_SEC_UUIDS = {
    'testing': 'sec-01edbgzpaa24j9vttvrph5nc1z',
    'stable': 'sec-01edbgz5jw2erjqb66s5w7n31b',
}


class BuildHistoricJamsLevels(common.JamsBuildTaskCommon):

    class Parameters(common.JamsBuildTaskCommon.Parameters):
        history_depth_weeks = sdk2.parameters.Integer('Depth of a history to use in weeks', default=10)
        weight_factor = sdk2.parameters.Float('Weight factor to be used in aggregation formula', default=0.8)

    def on_execute(self):
        self.binary_resource_path = str(os.path.abspath(self.binary_resource()))
        self.prepare_ecstatic(TVM_IDS, TVM_SEC_UUIDS)

        self.create_historic_levels(self.Parameters.history_depth_weeks, self.Parameters.weight_factor)

        data_path = str(os.path.abspath('hist_levels'))
        self.ecstatic_upload(data_path, DATASET_NAME, int(time.time()))

    def create_historic_levels(self, depth, factor):
        bin_dir = os.path.join(
            self.binary_resource_path,
            self.Parameters.binary_package_path,
            'bin')

        with ProcessLog(logger=logging.getLogger('create_historic_levels')) as log:
            cmd = [
                os.path.join(bin_dir, 'create_hist_levels'),
                '--depth', str(depth),
                '--factor', str(factor)]
            subprocess.check_call(cmd, stdout=log.stdout, stderr=log.stderr)
