import logging
import os
import shutil
import subprocess
import stat

from sandbox import sdk2


class CalculateStaticPoiDispClassesExecutable(sdk2.Resource):
    releasable = True
    executable = True
    releasers = ['MAPS-GEOQ-RELEASERS']
    release_subscribers = ['olegvp']


class CalculateStaticPoiDispClasses(sdk2.Task):
    class Parameters(sdk2.Task.Parameters):
        executable = sdk2.parameters.Resource(
            'Sandbox resource ID of the executable',
            resource_type=CalculateStaticPoiDispClassesExecutable,
            required=True
        )

        yt_vault = sdk2.parameters.Vault('YT vault', required=True)
        yql_vault = sdk2.parameters.Vault('YQL vault', required=True)

        organisation_user_features_table = sdk2.parameters.String(
            'Organisation user features table', required=True
        )
        output_table = sdk2.parameters.String('Output table', required=True)
        history_dir = sdk2.parameters.String('History directory')

    def on_execute(self):
        resource = sdk2.Resource[self.Parameters.executable]
        resource_data = sdk2.ResourceData(resource)
        executable_path = './executable'
        shutil.copyfile(str(resource_data.path), executable_path)
        os.chmod(
            executable_path, os.stat(executable_path).st_mode | stat.S_IEXEC
        )

        cmd = [
            executable_path,
            '--organisation-user-features-table',
            self.Parameters.organisation_user_features_table,
            '--output-table',
            self.Parameters.output_table
        ]
        if self.Parameters.history_dir:
            cmd += ['--history-dir', self.Parameters.history_dir]

        os.environ['YT_TOKEN'] = self.Parameters.yt_vault.data()
        os.environ['YQL_TOKEN'] = self.Parameters.yql_vault.data()

        with sdk2.helpers.ProcessLog(
            self, logger=logging.getLogger('executable')
        ) as pl:
            subprocess.check_call(
                cmd, stdout=pl.stdout, stderr=subprocess.STDOUT
            )
