import json

from sandbox import sdk2
from sandbox.sandboxsdk import environments


class SpeedBannerStandingEdgesDataset(sdk2.Resource):
    releasable = True
    releasers = ['mlevkov', 'tswr', 'ygorishniy']


class BuildSpeedBannerStandingEdgesDatasetTask(sdk2.Task):
    class Requirements(sdk2.Task.Requirements):
        environments = [environments.PipEnvironment('yandex-yt'),]

    class Parameters(sdk2.Task.Parameters):
        table_name = sdk2.parameters.String('table name', required=True)
        dataset_filename = sdk2.parameters.String('dataset filename', required=True, default='dataset.json')
        yt_token = sdk2.parameters.String('yt token in vault', required=True)

    def _read_standing_edges_table(self):
        import yt.wrapper as yt
        yt_proxy = 'hahn'
        yt_token = sdk2.Vault.data(self.owner, self.Parameters.yt_token)
        ytc = yt.YtClient(proxy=yt_proxy, token=yt_token)
        return ytc.read_table(self.Parameters.table_name, format='json')

    def _create_resource(self, data):
        resource = SpeedBannerStandingEdgesDataset(self, 'dataset', self.Parameters.dataset_filename)
        resource_data = sdk2.ResourceData(resource)
        resource_data.path.write_bytes(json.dumps(list(data)))
        resource_data.ready()

    def on_execute(self):
        data = self._read_standing_edges_table()
        self._create_resource(data)
