import os
import subprocess
import shutil

from sandbox import sdk2
from sandbox.common.errors import TaskFailure
from sandbox.projects.maps.common.ecstatic_bin import MapsEcstaticToolMixin


TVM_IDS = {
    'testing': 2018420,
    'stable': 2018422,
}
TVM_SEC_UUIDS = {
    'testing': 'sec-01e0q9xznk7j2qjd196w49drf3',
    'stable': 'sec-01e0q9z2q3wk1fbhzx7cek4kvb',
}


class JAMS_STATISTICAL_DATASET_RESOURCE(sdk2.Resource):
    """
        Jams statistical data resource type
    """


class UPLOAD_JAMS_STATISTICAL_DATASET_TO_ECSTATIC_TASK(MapsEcstaticToolMixin, sdk2.Task):
    """ Uploads resource from Sandbox to Ecstatic. """
    class Requirements(sdk2.Requirements):
        cores = 1

        class Caches(sdk2.Requirements.Caches):
            pass

    class Parameters(sdk2.Parameters):
        resource_id = sdk2.parameters.String('Data Sandbox Resource ID')
        resource_v2_id = sdk2.parameters.String('Data Sandbox Resource v2 ID', required=False)
        dataset = sdk2.parameters.String('Dataset name')
        version = sdk2.parameters.String('Dataset version')
        environment = sdk2.parameters.String('Ecstatic environment')

    def on_execute(self):
        os.makedirs('data')

        resource = sdk2.Resource[self.Parameters.resource_id]
        resource_data = sdk2.ResourceData(resource)
        shutil.copy(str(resource_data.path), './data/statistical_data.mms')

        if self.Parameters.resource_v2_id:
            resource_v2 = sdk2.Resource[self.Parameters.resource_v2_id]
            resource_v2_data = sdk2.ResourceData(resource_v2)
            shutil.copy(str(resource_v2_data.path), './data/statistical_data.fb')

        try:
            self.ecstatic(
                self.Parameters.environment,
                [
                    'upload',
                    self.Parameters.dataset + '=' + self.Parameters.version,
                    'data',
                    '+prestable', '+stable'
                ],
                tvm_id=TVM_IDS.get(self.Parameters.environment),
                tvm_secret_id=TVM_SEC_UUIDS.get(self.Parameters.environment),
            )
        except subprocess.CalledProcessError as e:
            self.set_info(e.output)
            raise TaskFailure('Ecstatic returned ' + str(e.returncode))
