from sandbox import sdk2
from sandbox.projects.common import constants
from sandbox.projects.common.arcadia import sdk as arcadia_sdk


BINARY_LOCAL_RESOURCE_DIR = 'resource'


class MapsBinaryResource(sdk2.Resource):
    revision = sdk2.Attributes.Integer('Revision', required=True)
    build_path = sdk2.Attributes.String('Path(from Arcadia root) which should be built', required=True)


class MapsBinaryResourceBuilder(sdk2.Task):

    class Requirements(sdk2.Requirements):
        cores = 8
        disk_space = 200 * 1024  # Mb
        ram = 16 * 1024  # Mb

    class Parameters(sdk2.Task.Parameters):
        revision = sdk2.parameters.Integer('Revision', required=True)
        build_path = sdk2.parameters.String('Path(from Arcadia root) which should be built', required=True)

    def on_execute(self):
        self.build(self.Parameters.build_path, self.Parameters.revision)

    def build(self, build_path, revision):
        resource = MapsBinaryResource(
            self,
            'binary {} revision {}'.format(build_path, revision),
            BINARY_LOCAL_RESOURCE_DIR,
            build_path=self.Parameters.build_path,
            revision=self.Parameters.revision
        )

        resource_data = sdk2.ResourceData(resource)

        with arcadia_sdk.mount_arc_path(sdk2.svn.Arcadia.ARCADIA_TRUNK_URL + '@{}'.format(revision)) as arcadia:
            arcadia_sdk.do_build(
                constants.YMAKE_BUILD_SYSTEM,
                arcadia,
                [self.Parameters.build_path],
                constants.RELEASE_BUILD_TYPE,
                clear_build=False,
                results_dir=str(resource_data.path)
            )

        resource_data.ready()
